/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdb.XReportDocumentsSupplier;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.sdbc.XConnection;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import complexlib.Assurance;
import graphical.DateHelper;
import graphical.FileHelper;
import graphical.GlobalLogWriter;
import graphical.ParameterHelper;
import graphical.TimeHelper;
import helper.OfficeProvider;
import helper.PropertyHelper;
import helper.StringHelper;
import helper.URLHelper;
import java.io.File;
import java.util.ArrayList;

public class OpenOfficeDatabaseReportExtractor
extends Assurance {
    private ParameterHelper m_aParameterHelper;
    private XDesktop m_xDesktop = null;
    private OfficeProvider m_aProvider = null;
    private XMultiServiceFactory m_xMultiServiceFactory = null;
    private String m_sMailAddress = null;
    private String m_sParentDistinct = null;
    private static String m_sSourceVersion;
    private static String m_sDestinationVersion;
    private static String m_sSourceName;
    private static String m_sDestinationName;
    private static final int WRITER = 1;
    private static final int CALC = 2;
    private String m_sOutputPath = null;

    public OpenOfficeDatabaseReportExtractor(ParameterHelper _aParameter) {
        this.m_aParameterHelper = _aParameter;
    }

    private XDesktop getXDesktop() {
        if (this.m_xDesktop == null) {
            try {
                XInterface xInterface = (XInterface)this.getMultiServiceFactory().createInstance("com.sun.star.frame.Desktop");
                this.m_xDesktop = UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
            }
            catch (com.sun.star.uno.Exception e) {
                GlobalLogWriter.get().println("ERROR: uno.Exception caught");
                GlobalLogWriter.get().println("Message: " + e.getMessage());
            }
        }
        return this.m_xDesktop;
    }

    private void showElements(XNameAccess _xNameAccess) {
        if (_xNameAccess != null) {
            String[] sElementNames = _xNameAccess.getElementNames();
            for (int i = 0; i < sElementNames.length; ++i) {
                System.out.println("Value: [" + i + "] := " + sElementNames[i]);
            }
        } else {
            System.out.println("Warning: Given object is null.");
        }
    }

    private XMultiServiceFactory getMultiServiceFactory() {
        if (this.m_xMultiServiceFactory == null) {
            this.m_xMultiServiceFactory = this.m_aParameterHelper.getMultiServiceFactory();
        }
        return this.m_xMultiServiceFactory;
    }

    public ArrayList load(String _sDocument) {
        String sOutputPath = this.m_aParameterHelper.getOutputPath();
        File aOutputPath = new File(sOutputPath);
        aOutputPath.mkdirs();
        String sFilename = FileHelper.getBasename(_sDocument);
        String sDestinationFile = FileHelper.appendPath(sOutputPath, sFilename);
        FileHelper.copy(_sDocument, sDestinationFile);
        this.assure("There exists no file: " + sDestinationFile, FileHelper.exists(sDestinationFile));
        String sFileURL = URLHelper.getFileURLFromSystemPath(sDestinationFile);
        GlobalLogWriter.get().println("File URL: " + sFileURL);
        ArrayList aPropertyList = new ArrayList();
        XComponent xDocComponent = this.loadComponent(sFileURL, this.getXDesktop(), aPropertyList);
        GlobalLogWriter.get().println("Load done");
        ArrayList aList = null;
        try {
            XOfficeDatabaseDocument xOfficeDBDoc = UnoRuntime.queryInterface(XOfficeDatabaseDocument.class, (Object)xDocComponent);
            this.assure("can't access DatabaseDocument", xOfficeDBDoc != null);
            XModel xDBSource = UnoRuntime.queryInterface(XModel.class, (Object)xOfficeDBDoc);
            XController aController = xDBSource.getCurrentController();
            this.assure("Controller of xOfficeDatabaseDocument is empty!", aController != null);
            XDatabaseDocumentUI aDBDocUI = UnoRuntime.queryInterface(XDatabaseDocumentUI.class, (Object)aController);
            aDBDocUI.connect();
            boolean isConnect = aDBDocUI.isConnected();
            if (isConnect) {
                GlobalLogWriter.println("Connection is true");
            } else {
                GlobalLogWriter.println("Connection is false");
            }
            XReportDocumentsSupplier xSupplier = UnoRuntime.queryInterface(XReportDocumentsSupplier.class, (Object)xOfficeDBDoc);
            XNameAccess xNameAccess = xSupplier.getReportDocuments();
            this.assure("xOfficeDatabaseDocument returns no Report Document", xNameAccess != null);
            this.showElements(xNameAccess);
            XConnection aActiveConnectionObj = aDBDocUI.getActiveConnection();
            this.assure("ActiveConnection is empty", aActiveConnectionObj != null);
            ArrayList<PropertyValue> aPropertyList2 = new ArrayList<PropertyValue>();
            PropertyValue aActiveConnection = new PropertyValue();
            aActiveConnection.Name = "ActiveConnection";
            aActiveConnection.Value = aActiveConnectionObj;
            aPropertyList2.add(aActiveConnection);
            aList = this.loadAndStoreReports(xNameAccess, aPropertyList2);
            this.createDBEntry();
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("ERROR: Exception caught");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
        }
        this.closeComponent(xDocComponent);
        return aList;
    }

    private String getDocumentPoolName() {
        return "AutogenReportDesignTest";
    }

    private void createDBEntry() {
        String sDBConnection = (String)this.m_aParameterHelper.getTestParameters().get("DB_CONNECTION_STRING");
        if (sDBConnection != null && sDBConnection.length() > 0) {
            GlobalLogWriter.get().println("DBConnection: " + sDBConnection);
            String sFixRefSubDirectory = "ReportDesignFixRef";
            String sSourceVersion = m_sSourceVersion;
            String sSourceName = m_sSourceName;
            String sSourceCreatorType = "";
            String sDestinationVersion = m_sDestinationVersion;
            String sDestinationName = m_sDestinationName;
            String sDestinationCreatorType = "";
            String sDocumentPoolDir = this.getOutputPath();
            String sDocumentPoolName = this.getDocumentPoolName();
            String sSpecial = "";
            TimeHelper.waitInSeconds(1, "wait for DB.");
        }
    }

    private ArrayList loadAndStoreReports(XNameAccess _xNameAccess, ArrayList _aPropertyList) {
        ArrayList<String> aList = new ArrayList<String>();
        if (_xNameAccess != null) {
            String[] sElementNames = _xNameAccess.getElementNames();
            for (int i = 0; i < sElementNames.length; ++i) {
                String sReportName = sElementNames[i];
                XComponent xDoc = this.loadComponent(sReportName, _xNameAccess, _aPropertyList);
                String sDocumentPathName = this.storeComponent(sReportName, xDoc);
                aList.add(sDocumentPathName);
                this.closeComponent(xDoc);
            }
        }
        return aList;
    }

    private String getFormatExtension(Object _xComponent) {
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, _xComponent);
        String sExtension = xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument") ? ".ods" : (xServiceInfo.supportsService("com.sun.star.text.TextDocument") ? ".odt" : ".UNKNOWN");
        return sExtension;
    }

    private String getOutputPath() {
        if (this.m_sOutputPath == null) {
            String sOutputPath = (String)this.m_aParameterHelper.getTestParameters().get("DOC_COMPARATOR_OUTPUT_PATH");
            sOutputPath = StringHelper.removeQuoteIfExists(sOutputPath);
            sOutputPath = FileHelper.appendPath(sOutputPath, DateHelper.getDateTimeForFilename());
            File aOutputFile = new File(sOutputPath);
            aOutputFile.mkdirs();
            this.m_sOutputPath = sOutputPath;
        }
        return this.m_sOutputPath;
    }

    private String storeComponent(String _sName, Object _xComponent) {
        String sOutputPath = this.getOutputPath();
        String sName = _sName + this.getFormatExtension(_xComponent);
        String sBackPathName = sOutputPath = FileHelper.appendPath(sOutputPath, sName);
        String sOutputURL = URLHelper.getFileURLFromSystemPath(sOutputPath);
        ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
        PropertyValue aOverwrite = new PropertyValue();
        aOverwrite.Name = "Overwrite";
        aOverwrite.Value = Boolean.TRUE;
        aPropertyList.add(aOverwrite);
        XStorable aStorable = UnoRuntime.queryInterface(XStorable.class, _xComponent);
        if (aStorable != null) {
            GlobalLogWriter.get().println("store document as URL: '" + sOutputURL + "'");
            try {
                aStorable.storeAsURL(sOutputURL, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
            }
            catch (IOException e) {
                GlobalLogWriter.get().println("ERROR: Exception caught");
                GlobalLogWriter.get().println("Can't write document URL: '" + sOutputURL + "'");
                GlobalLogWriter.get().println("Message: " + e.getMessage());
            }
        }
        return sBackPathName;
    }

    private XComponent loadComponent(String _sName, Object _xComponent, ArrayList _aPropertyList) {
        XComponent xDocComponent = null;
        XComponentLoader xComponentLoader = UnoRuntime.queryInterface(XComponentLoader.class, _xComponent);
        try {
            PropertyValue[] aLoadProperties = PropertyHelper.createPropertyValueArrayFormArrayList(_aPropertyList);
            GlobalLogWriter.get().println("Load component: '" + _sName + "'");
            xDocComponent = xComponentLoader.loadComponentFromURL(_sName, "_blank", 23, aLoadProperties);
            GlobalLogWriter.get().println("Load component: '" + _sName + "' done");
        }
        catch (IOException e) {
            GlobalLogWriter.get().println("ERROR: Exception caught");
            GlobalLogWriter.get().println("Can't load document '" + _sName + "'");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            GlobalLogWriter.get().println("ERROR: Exception caught");
            GlobalLogWriter.get().println("Illegal Arguments given to loadComponentFromURL.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
        }
        return xDocComponent;
    }

    private void closeComponent(XComponent _xDoc) {
        XCloseable xCloseable = UnoRuntime.queryInterface(XCloseable.class, (Object)_xDoc);
        try {
            xCloseable.close(true);
        }
        catch (CloseVetoException e) {
            GlobalLogWriter.get().println("ERROR: CloseVetoException caught");
            GlobalLogWriter.get().println("CloseVetoException occured Can't close document.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
        }
    }
}

