/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.FileHelper;
import graphical.GlobalLogWriter;

class NameDPIPage {
    String Name;
    int DPI;
    int Page;

    private NameDPIPage(String _sName, int _nDPI, int _nPage) {
        this.Name = _sName;
        this.DPI = _nDPI;
        this.Page = _nPage;
    }

    public static NameDPIPage interpret(String _sFilename) {
        String sName;
        String sBasename = FileHelper.getBasename(_sFilename);
        String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String sDPICheck = sNameNoSuffix.substring(sNameNoSuffix.length() - 8, sNameNoSuffix.length() - 4);
        int nDPI = -1;
        int nPage = -1;
        if (sDPICheck.equals("DPI_")) {
            int nDPIStart = sNameNoSuffix.lastIndexOf("_", sNameNoSuffix.length() - 8);
            sName = sNameNoSuffix.substring(0, nDPIStart);
            if (nDPIStart > 0) {
                String sDPI = sNameNoSuffix.substring(nDPIStart + 1, sNameNoSuffix.length() - 8);
                try {
                    nDPI = Integer.valueOf(sDPI);
                }
                catch (NumberFormatException e) {
                    GlobalLogWriter.get().println("DPI: Number format exception");
                }
                String sPage = sNameNoSuffix.substring(sNameNoSuffix.length() - 4);
                try {
                    nPage = Integer.valueOf(sPage);
                }
                catch (NumberFormatException e) {
                    GlobalLogWriter.get().println("Page: Number format exception");
                }
            }
        } else {
            sName = sNameNoSuffix;
        }
        return new NameDPIPage(sName, nDPI, nPage);
    }
}

