/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ImageHelper {
    Image m_aImage;
    int[] m_aPixels;
    int m_w = 0;
    int m_h = 0;
    boolean m_bGrabbed = false;

    private ImageHelper(Image _aImage) {
        this.m_aImage = _aImage;
        this.m_w = this.getWidth();
        this.m_h = this.getHeight();
        int x = 0;
        int y = 0;
        this.m_aPixels = new int[this.m_w * this.m_h];
        PixelGrabber pg = new PixelGrabber(this.m_aImage, x, y, this.m_w, this.m_h, this.m_aPixels, 0, this.m_w);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            System.err.println("interrupted waiting for pixels!");
            return;
        }
        if ((pg.getStatus() & 0x80) != 0) {
            System.err.println("image fetch aborted or errored");
            return;
        }
        this.m_bGrabbed = true;
    }

    public int getWidth() {
        return this.m_aImage.getWidth(null);
    }

    public int getHeight() {
        return this.m_aImage.getHeight(null);
    }

    public int getPixel(int x, int y) {
        return this.m_aPixels[y * this.m_w + x];
    }

    public static ImageHelper createImageHelper(String _sFilename) throws IOException {
        Image aImage = null;
        File aFile = new File(_sFilename);
        ReflectiveOperationException ex = null;
        try {
            Class<?> imageIOClass = Class.forName("javax.imageio.ImageIO");
            Method readMethod = imageIOClass.getDeclaredMethod("read", File.class);
            Object retValue = readMethod.invoke(imageIOClass, aFile);
            aImage = (Image)retValue;
        }
        catch (ClassNotFoundException e) {
            ex = e;
        }
        catch (NoSuchMethodException e) {
            ex = e;
        }
        catch (IllegalAccessException e) {
            ex = e;
        }
        catch (InvocationTargetException e) {
            ex = e;
        }
        if (ex != null) {
            String javaVersion = System.getProperty("java.version");
            throw new IOException("Cannot construct object with current Java version " + javaVersion + ": " + ex.getMessage());
        }
        return new ImageHelper(aImage);
    }
}

