/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.DateHelper;
import graphical.FileHelper;
import graphical.GlobalLogWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HTMLResult {
    private FileWriter m_aOut;
    private String ls;
    static final String TEST_TABLETITLE = "Document";
    static final String VISUAL_STATUS_TABLETITLE = "Visual status";
    static final String VISUAL_STATUS_MESSAGE_TABLETITLE = "Message";
    static final String FIRSTGFX_TABLETITLE = "Original print file as jpeg";

    public HTMLResult(String _sOutputPath, String _sHTMLFilename) {
        FileHelper.makeDirectories("", _sOutputPath);
        String sFilename = FileHelper.appendPath(_sOutputPath, _sHTMLFilename);
        try {
            File outputFile = new File(sFilename);
            this.m_aOut = new FileWriter(outputFile.toString());
            this.ls = System.getProperty("line.separator");
        }
        catch (IOException e) {
            e.printStackTrace();
            GlobalLogWriter.get().println("ERROR: Can't create HTML Outputter");
        }
    }

    private void writeln(String _sStr) {
        try {
            this.m_aOut.write(_sStr);
            this.m_aOut.write(this.ls);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void flush() {
        try {
            this.m_aOut.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void header(String _sTitle) {
        this.writeln("<HTML>");
        this.writeln("<HEAD>");
        this.writeln("<TITLE>" + _sTitle + "</TITLE>");
        this.writeln("<LINK rel=\"stylesheet\" type=\"text/css\" href=\"/gfxcmp_ui/xmloff.css\" media=\"screen\" />");
        this.writeln("<LINK rel=\"stylesheet\" type=\"text/css\" href=\"/gfxcmp_ui/style.css\" media=\"screen\" />");
        this.writeln("</HEAD>");
        this.writeln("<BODY bgcolor=white>");
        this.flush();
    }

    public void indexSection(String _sOfficeInfo) {
        this.writeln("<H2>Results for " + _sOfficeInfo + "</H2>");
        this.writeln("<P>This result was created at: " + DateHelper.getDateTimeForHumanreadableLog());
        this.writeln("<P>Legend:<BR>");
        this.writeln(this.stronghtml(FIRSTGFX_TABLETITLE) + " contains the output printed via 'ghostscript' as a jpeg picture.<BR>");
        this.writeln("<TABLE class=\"infotable\">");
        this.writeln("<TR>");
        this.writeln(this.tableHeaderCell(TEST_TABLETITLE));
        this.writeln(this.tableHeaderCell(""));
        this.writeln(this.tableHeaderCell(VISUAL_STATUS_TABLETITLE));
        this.writeln(this.tableHeaderCell(VISUAL_STATUS_MESSAGE_TABLETITLE));
        this.writeln("</TR>");
        this.flush();
    }

    private String getHREF(String _sHREF, String _sPathInfo) {
        StringBuffer a = new StringBuffer();
        a.append("<A HREF=\"");
        a.append(_sHREF);
        a.append("\">");
        a.append(_sPathInfo);
        a.append("</A>");
        return a.toString();
    }

    private String tableDataCell(String _sValue) {
        StringBuffer a = new StringBuffer();
        a.append("<TD>");
        a.append(_sValue);
        a.append("</TD>");
        return a.toString();
    }

    private String tableHeaderCell(String _sValue) {
        StringBuffer a = new StringBuffer();
        a.append("<TH>");
        a.append(_sValue);
        a.append("</TH>");
        return a.toString();
    }

    public void indexLine(String _sHTMLFile, String _sHTMLName, String _sStatusRunThrough, String _sStatusMessage) {
        this.writeln("<TR>");
        this.writeln(this.tableDataCell(this.getHREF(_sHTMLFile, _sHTMLName)));
        this.writeln(this.tableDataCell(""));
        this.writeln(this.tableDataCell(_sStatusRunThrough));
        this.writeln(this.tableDataCell(_sStatusMessage));
        this.writeln("</TR>");
        this.flush();
    }

    public void close() {
        this.writeln("</TABLE>");
        this.writeln("</BODY></HTML>");
        try {
            this.m_aOut.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String stronghtml(String _sValue) {
        StringBuffer a = new StringBuffer();
        a.append("<STRONG>");
        a.append(_sValue);
        a.append("</STRONG>");
        return a.toString();
    }
}

