/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import complexlib.ComplexTestCase;
import graphical.DirectoryHelper;
import graphical.FileHelper;
import graphical.GlobalLogWriter;
import graphical.HTMLResult;
import graphical.IDocument;
import graphical.IniFile;
import graphical.OfficeException;
import graphical.ParameterHelper;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public abstract class EnhancedComplexTestCase
extends ComplexTestCase
implements IDocument {
    private void callEntry(String _sEntry, ParameterHelper _aParam) {
        log.println("- next file is: ------------------------------");
        log.println(_sEntry);
        File aFile = new File(_aParam.getInputPath());
        String sPath = _aParam.getInputPath();
        if (!aFile.isDirectory()) {
            sPath = FileHelper.getPath(_aParam.getInputPath());
        }
        String sNewSubDir = FileHelper.removeFirstDirectorysAndBasenameFrom(_sEntry, sPath);
        String sNewOutputPath = _aParam.getOutputPath();
        if (sNewSubDir.length() > 0) {
            sNewOutputPath = FileHelper.appendPath(sNewOutputPath, sNewSubDir);
        }
        log.println("sEntry: " + _sEntry + " " + sNewOutputPath);
        try {
            this.checkOneFile(_sEntry, sNewOutputPath, _aParam);
        }
        catch (OfficeException e) {
            GlobalLogWriter.println("Warning: caught OfficeException " + e.getMessage());
            this.assure("Exception caught: " + e.getMessage(), false);
        }
    }

    public void foreachDocumentinInputPath(ParameterHelper _aParam) {
        File aInputPath = new File(_aParam.getInputPath());
        if (aInputPath.isDirectory()) {
            FileFilter aFileFilter = FileHelper.getFileFilter();
            this.traverseDirectory(aFileFilter, _aParam);
        } else {
            this.callEntry(_aParam.getInputPath(), _aParam);
        }
    }

    private void traverseDirectory(FileFilter _aFileFilter, ParameterHelper _aParam) {
        Object[] aList = DirectoryHelper.traverse(_aParam.getInputPath(), _aFileFilter, _aParam.isIncludeSubDirectories());
        if (aList.length == 0) {
            log.println("Nothing to do, there are no document files found.");
        } else {
            for (int i = 0; i < aList.length; ++i) {
                String sEntry = (String)aList[i];
                this.callEntry(sEntry, _aParam);
            }
        }
    }

    public void foreachPSorPDFinInputPath(ParameterHelper _aParam) {
        String sInputPath = _aParam.getInputPath();
        File aInputPath = new File(sInputPath);
        if (aInputPath.isDirectory()) {
            FileFilter aFileFilter = FileHelper.getFileFilterPSorPDF();
            this.traverseDirectory(aFileFilter, _aParam);
        } else if (sInputPath.toLowerCase().endsWith(".ini")) {
            IniFile aIniFile = new IniFile(_aParam.getInputPath());
            while (aIniFile.hasMoreElements()) {
                String sKey = (String)aIniFile.nextElement();
                String sPath = FileHelper.getPath(_aParam.getInputPath());
                String sEntry = FileHelper.appendPath(sPath, sKey);
                File aFile = new File(sEntry);
                this.assure("File '" + sEntry + "' doesn't exists.", aFile.exists(), true);
                if (!aFile.exists()) continue;
                this.callEntry(sEntry, _aParam);
            }
        } else if (sInputPath.toLowerCase().endsWith(".ps") || sInputPath.toLowerCase().endsWith(".pdf") || sInputPath.toLowerCase().endsWith(".prn")) {
            this.callEntry(sInputPath, _aParam);
        } else {
            String sPath = FileHelper.getPath(sInputPath);
            String sBasename = FileHelper.getBasename(sInputPath);
            this.runThroughEveryReportInIndex(sPath, sBasename, _aParam);
        }
    }

    private void runThroughEveryReportInIndex(String _sPath, String _sBasename, ParameterHelper _aParam) {
        String sIndexFile = FileHelper.appendPath(_sPath, "index.ini");
        File aIndexFile = new File(sIndexFile);
        if (aIndexFile.exists()) {
            IniFile aIniFile = new IniFile(sIndexFile);
            if (aIniFile.hasSection(_sBasename)) {
                int nFileCount = aIniFile.getIntValue(_sBasename, "reportcount", 0);
                ArrayList<String> aList = new ArrayList<String>();
                for (int i = 0; i < nFileCount; ++i) {
                    String sValue = aIniFile.getValue(_sBasename, "report" + i);
                    String sPSorPDFName = this.getPSorPDFNameFromIniFile(aIniFile, sValue);
                    if (sPSorPDFName.length() <= 0) continue;
                    String sEntry = FileHelper.appendPath(_sPath, sPSorPDFName);
                    aList.add(sEntry);
                }
                aIniFile.close();
                int nOkStatus = 0;
                String sStatusRunThrough = "";
                String sStatusInfo = "";
                for (int i = 0; i < aList.size(); ++i) {
                    String sEntry = (String)aList.get(i);
                    this.callEntry(sEntry, _aParam);
                    int nCurrentOkStatus = _aParam.getTestParameters().getInt("current_ok_status");
                    if (nCurrentOkStatus <= nOkStatus) continue;
                    sStatusRunThrough = (String)_aParam.getTestParameters().get("current_state");
                    sStatusInfo = (String)_aParam.getTestParameters().get("current_info");
                    nOkStatus = nCurrentOkStatus;
                }
                if (nOkStatus > 0) {
                    _aParam.getTestParameters().put("last_state", sStatusRunThrough);
                    _aParam.getTestParameters().put("last_info", sStatusInfo);
                }
            } else {
                String sPSorPDFName = this.getPSorPDFNameFromIniFile(aIniFile, _sBasename);
                aIniFile.close();
                if (sPSorPDFName.length() > 0) {
                    String sEntry = FileHelper.appendPath(_sPath, sPSorPDFName);
                    this.callEntry(sEntry, _aParam);
                }
            }
        }
    }

    private String getPSorPDFNameFromIniFile(IniFile _aIniFile, String _sName) {
        boolean bHasPostscriptOrPDF = false;
        String sPSBasename = _sName + ".ps";
        if (_aIniFile.hasSection(sPSBasename)) {
            bHasPostscriptOrPDF = true;
        } else {
            sPSBasename = _sName + ".pdf";
            if (_aIniFile.hasSection(sPSBasename)) {
                bHasPostscriptOrPDF = true;
            }
        }
        if (bHasPostscriptOrPDF) {
            return sPSBasename;
        }
        return "";
    }

    public void runThroughOneFileInIndex(String _sPath, String _sBasename, ParameterHelper _aParam) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void foreachJPEGcompareWithJPEG(ParameterHelper _aParam) {
        String sInputPath = _aParam.getInputPath();
        File aInputPath = new File(sInputPath);
        if (aInputPath.isDirectory()) {
            FileFilter aFileFilter = FileHelper.getFileFilterJPEG();
            this.traverseDirectory(aFileFilter, _aParam);
            return;
        } else if (sInputPath.toLowerCase().endsWith(".ini")) {
            IniFile aIniFile = new IniFile(_aParam.getInputPath());
            while (aIniFile.hasMoreElements()) {
                String sSection = (String)aIniFile.nextElement();
            }
            return;
        } else {
            try {
                String sOutputFilename = _aParam.getOutputPath();
                if (sInputPath.toLowerCase().endsWith(".jpg") || sInputPath.toLowerCase().endsWith(".jpeg")) {
                    this.checkOneFile(sInputPath, sOutputFilename, _aParam);
                    return;
                }
                String sPath = FileHelper.getPath(sInputPath);
                String sBasename = FileHelper.getBasename(sInputPath);
                this.runThroughEveryReportInIndex(sPath, sBasename, _aParam);
                String sStatusRunThrough = (String)_aParam.getTestParameters().get("last_state");
                String sStatusInfo = (String)_aParam.getTestParameters().get("last_info");
                if (sStatusRunThrough == null || sStatusInfo == null) return;
                String sOutputPath = _aParam.getOutputPath();
                String sBasenameIni = FileHelper.appendPath(sOutputPath, sBasename + ".ps.ini");
                IniFile aBasenameIni = new IniFile(sBasenameIni);
                aBasenameIni.insertValue("global", "state", sStatusRunThrough);
                aBasenameIni.insertValue("global", "info", sStatusInfo);
                aBasenameIni.close();
                return;
            }
            catch (OfficeException e) {
                GlobalLogWriter.println("Warning: caught OfficeException " + e.getMessage());
            }
        }
    }

    public void foreachResultCreateHTML(ParameterHelper _aParam) {
        String sInputPath = _aParam.getInputPath();
        File aInputPath = new File(sInputPath);
        if (sInputPath.toLowerCase().endsWith(".ini")) {
            this.callEntry(sInputPath, _aParam);
        } else {
            String sIndexFile;
            File aIndexFile;
            String sPath = FileHelper.getPath(sInputPath);
            String sBasename = FileHelper.getBasename(sInputPath);
            this.runThroughEveryReportInIndex(sPath, sBasename, _aParam);
            if (sInputPath.toLowerCase().endsWith(".odb") && (aIndexFile = new File(sIndexFile = FileHelper.appendPath(sPath, "index.ini"))).exists()) {
                IniFile aIniFile = new IniFile(sIndexFile);
                if (aIniFile.hasSection(sBasename)) {
                    int nFileCount = aIniFile.getIntValue(sBasename, "reportcount", 0);
                    ArrayList<String> aList = new ArrayList<String>();
                    for (int i = 0; i < nFileCount; ++i) {
                        String sValue = aIniFile.getValue(sBasename, "report" + i);
                        String sPSorPDFName = this.getPSorPDFNameFromIniFile(aIniFile, sValue);
                        if (sPSorPDFName.length() <= 0) continue;
                        aList.add(sPSorPDFName);
                    }
                    if (aList.size() > 0) {
                        HTMLResult aOutputter = new HTMLResult(sPath, sBasename + ".ps.html");
                        aOutputter.header("content of DB file: " + sBasename);
                        aOutputter.indexSection(sBasename);
                        for (int i = 0; i < aList.size(); ++i) {
                            String sPSFile = (String)aList.get(i);
                            String sStatusRunThrough = "";
                            String sStatusMessage = "";
                            String sHTMLFile = sPSFile + ".html";
                            aOutputter.indexLine(sHTMLFile, sPSFile, sStatusRunThrough, sStatusMessage);
                        }
                        aOutputter.close();
                    }
                }
                aIniFile.close();
            }
        }
    }
}

