/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.GlobalLogWriter;
import helper.OSHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class SimpleFileSemaphore {
    String m_sInternSemaphoreFile;
    File m_aInternSemaphoreFile;
    GlobalLogWriter m_aLog;
    private static boolean SEMAPHORE_SHOULD_EXIST = true;
    private static boolean SEMAPHORE_SHOULD_NOT_EXIST = false;

    public static void sleep(int _nSeconds) {
        try {
            Thread.sleep(_nSeconds * 1000);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public SimpleFileSemaphore() throws IllegalArgumentException {
        String sInternFileName;
        if (OSHelper.isWindows()) {
            sInternFileName = "C:/Temp/ConvwatchOOoSemaphore.txt";
        } else if (OSHelper.isUnix()) {
            sInternFileName = "/tmp/ConvwatchOOoSemaphore.txt";
        } else {
            this.m_sInternSemaphoreFile = null;
            throw new IllegalArgumentException("Unknown System, can't initialise SimpleFileSemaphore");
        }
        this.m_sInternSemaphoreFile = sInternFileName;
        this.m_aInternSemaphoreFile = new File(sInternFileName);
    }

    public File getSemaphoreFile() {
        return this.m_aInternSemaphoreFile;
    }

    public void P(File _aSemaphore) {
        int nCount = 0;
        boolean nCheckLoop = true;
        while (nCheckLoop) {
            if (_aSemaphore.exists()) {
                SimpleFileSemaphore simpleFileSemaphore = this;
                simpleFileSemaphore.m_aLog.get().println("Active wait since " + nCount + "sec..");
                ++nCount;
                SimpleFileSemaphore.sleep(1);
                continue;
            }
            SimpleFileSemaphore.sleep(1);
            if (_aSemaphore.exists()) {
                SimpleFileSemaphore simpleFileSemaphore = this;
                simpleFileSemaphore.m_aLog.get().println("ups...");
                continue;
            }
            nCheckLoop = false;
        }
        try {
            RandomAccessFile aWriter = new RandomAccessFile(_aSemaphore, "rw");
            aWriter.writeByte(1);
            aWriter.close();
        }
        catch (FileNotFoundException fne) {
            SimpleFileSemaphore simpleFileSemaphore = this;
            simpleFileSemaphore.m_aLog.get().println("caught: FileNotFoundException");
        }
        catch (IOException ie) {
            SimpleFileSemaphore simpleFileSemaphore = this;
            simpleFileSemaphore.m_aLog.get().println("caught: IOException");
        }
    }

    public void V(File _aSemaphore) {
        if (_aSemaphore.exists()) {
            _aSemaphore.delete();
        } else {
            SimpleFileSemaphore simpleFileSemaphore = this;
            simpleFileSemaphore.m_aLog.get().println("Could be a problem here? No resource block found.");
        }
    }

    private static void assure(boolean _b, String _sText) {
        System.out.print(_sText);
        System.out.print("  ");
        if (_b) {
            System.out.println("ok");
        } else {
            System.out.println("FAILED");
        }
    }

    private static void testSemaphoreFile(SimpleFileSemaphore a, boolean _bShouldFileExists) {
        System.out.println("Check if semaphore file exists.");
        File aSemaphoreFile = a.getSemaphoreFile();
        if (aSemaphoreFile.exists()) {
            System.out.println("Name is: " + aSemaphoreFile.getAbsolutePath());
            SimpleFileSemaphore.assure(_bShouldFileExists == SEMAPHORE_SHOULD_EXIST, "Semaphore should exist!");
        } else {
            SimpleFileSemaphore.assure(_bShouldFileExists == SEMAPHORE_SHOULD_NOT_EXIST, "Semaphore should not exist!");
        }
    }

    public static void main(String[] argv) {
        SimpleFileSemaphore a = new SimpleFileSemaphore();
        SimpleFileSemaphore.testSemaphoreFile(a, SEMAPHORE_SHOULD_NOT_EXIST);
        a.P(a.getSemaphoreFile());
        SimpleFileSemaphore.testSemaphoreFile(a, SEMAPHORE_SHOULD_EXIST);
        a.V(a.getSemaphoreFile());
        SimpleFileSemaphore.testSemaphoreFile(a, SEMAPHORE_SHOULD_NOT_EXIST);
    }
}

