/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.beans.PropertyValue;
import com.sun.star.container.XNameAccess;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XController;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.sdb.XDocumentDataSource;
import com.sun.star.sdb.XOfficeDatabaseDocument;
import com.sun.star.sdb.XReportDocumentsSupplier;
import com.sun.star.sdb.application.XDatabaseDocumentUI;
import com.sun.star.sdbc.XConnection;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XCloseable;
import complexlib.Assurance;
import complexlib.ComplexTestCase;
import convwatch.DB;
import convwatch.DateHelper;
import convwatch.GlobalLogWriter;
import convwatch.PropertyHelper;
import convwatch.TimeHelper;
import helper.OfficeProvider;
import helper.OfficeWatcher;
import helper.StringHelper;
import helper.URLHelper;
import java.io.File;
import java.util.ArrayList;

public class ReportDesignerTest
extends ComplexTestCase {
    String mTestDocumentPath;
    private static XDesktop m_xDesktop = null;
    private OfficeProvider m_aProvider = null;
    private static XMultiServiceFactory m_xXMultiServiceFactory = null;
    private String m_sMailAddress = null;
    private String m_sParentDistinct = null;
    private static String m_sSourceVersion;
    private static String m_sDestinationVersion;
    private static String m_sSourceName;
    private static String m_sDestinationName;
    private static final int WRITER = 1;
    private static final int CALC = 2;
    private String m_sOutputPath = null;

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"ReportDesignTest"};
    }

    private void checkIfOfficeExists(String _sOfficePathWithTrash) {
        String sOfficePath = "";
        int nIndex = _sOfficePathWithTrash.indexOf("soffice.exe");
        if (nIndex > 0) {
            sOfficePath = _sOfficePathWithTrash.substring(0, nIndex + 11);
        } else {
            nIndex = _sOfficePathWithTrash.indexOf("soffice");
            if (nIndex > 0) {
                sOfficePath = _sOfficePathWithTrash.substring(0, nIndex + 7);
            }
        }
        sOfficePath = StringHelper.removeQuoteIfExists(sOfficePath);
        log.println(sOfficePath);
        File sOffice = new File(sOfficePath);
        if (!sOffice.exists()) {
            log.println("ERROR: There exists no office installation at given path: '" + sOfficePath + "'");
            System.exit(0);
        }
    }

    public static XDesktop getXDesktop() {
        if (m_xDesktop == null) {
            try {
                XInterface xInterface = (XInterface)m_xXMultiServiceFactory.createInstance("com.sun.star.frame.Desktop");
                m_xDesktop = UnoRuntime.queryInterface(XDesktop.class, (Object)xInterface);
            }
            catch (Exception e) {
                log.println("ERROR: uno.Exception caught");
                log.println("Message: " + e.getMessage());
            }
        }
        return m_xDesktop;
    }

    private void showElements(XNameAccess _xNameAccess) {
        if (_xNameAccess != null) {
            String[] sElementNames = _xNameAccess.getElementNames();
            for (int i = 0; i < sElementNames.length; ++i) {
                System.out.println("Value: [" + i + "] := " + sElementNames[i]);
            }
        } else {
            System.out.println("Warning: Given object is null.");
        }
    }

    private void startOffice() {
        param.put("TimeOut", new Integer(300000));
        System.out.println("TimeOut: " + param.getInt("TimeOut"));
        System.out.println("ThreadTimeOut: " + param.getInt("ThreadTimeOut"));
        this.m_aProvider = new OfficeProvider();
        m_xXMultiServiceFactory = (XMultiServiceFactory)this.m_aProvider.getManager(param);
        param.put("ServiceFactory", m_xXMultiServiceFactory);
    }

    private void stopOffice() {
        if (this.m_aProvider != null) {
            this.m_aProvider.closeExistingOffice(param, true);
            this.m_aProvider = null;
        }
        TimeHelper.waitInSeconds(2, "Give close Office some time.");
    }

    public void ReportDesignTest() {
        GlobalLogWriter.set(log);
        GlobalLogWriter.get().println("Set office watcher");
        OfficeWatcher aWatcher = (OfficeWatcher)param.get("Watcher");
        GlobalLogWriter.get().setWatcher(aWatcher);
        try {
            String sAppExecutionCommand = (String)param.get("AppExecutionCommand");
            log.println("sAppExecutionCommand='" + sAppExecutionCommand + "'");
            String sUser = System.getProperty("user.name");
            log.println("user.name='" + sUser + "'");
            this.m_sMailAddress = System.getProperty("MailAddress");
            log.println("Assumed mail address: " + this.m_sMailAddress);
            this.m_sParentDistinct = System.getProperty("ParentDistinct");
            m_sSourceVersion = System.getProperty("SourceVersion");
            m_sSourceName = System.getProperty("SourceName");
            m_sDestinationVersion = System.getProperty("DestinationVersion");
            m_sDestinationName = System.getProperty("DestinationName");
            if (m_sSourceVersion == null) {
                System.out.println("Error, Sourceversion is null.");
                System.exit(1);
            }
            sAppExecutionCommand = sAppExecutionCommand.replaceAll("\\$\\{USERNAME\\}", sUser);
            log.println("sAppExecutionCommand='" + sAppExecutionCommand + "'");
            this.checkIfOfficeExists(sAppExecutionCommand);
            param.put("AppExecutionCommand", new String(sAppExecutionCommand));
            this.startOffice();
            String sDocument = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
            sDocument = StringHelper.removeQuoteIfExists(sDocument);
            this.startTestForFile(sDocument);
        }
        catch (Assurance.AssureException e) {
            this.stopOffice();
            throw new Assurance.AssureException(e.getMessage());
        }
        this.stopOffice();
    }

    private void startTestForFile(String _sDocument) {
        File aFile = new File(_sDocument);
        this.assure("Test File '" + _sDocument + "' doesn't exist.", aFile.exists());
        String sFileURL = URLHelper.getFileURLFromSystemPath(_sDocument);
        log.println("File URL: " + sFileURL);
        XComponent xDocComponent = this.loadComponent(sFileURL, ReportDesignerTest.getXDesktop(), null);
        log.println("Load done");
        try {
            XInterface x = (XInterface)m_xXMultiServiceFactory.createInstance("com.sun.star.sdb.DatabaseContext");
            this.assure("can't create instance of com.sun.star.sdb.DatabaseContext", x != null);
            log.println("createInstance com.sun.star.sdb.DatabaseContext done");
            XNameAccess xNameAccess = UnoRuntime.queryInterface(XNameAccess.class, (Object)x);
            this.showElements(xNameAccess);
            Object aObj = xNameAccess.getByName(sFileURL);
            XDocumentDataSource xDataSource = UnoRuntime.queryInterface(XDocumentDataSource.class, aObj);
            XOfficeDatabaseDocument xOfficeDBDoc = xDataSource.getDatabaseDocument();
            this.assure("can't access DatabaseDocument", xOfficeDBDoc != null);
            XModel xDBSource = UnoRuntime.queryInterface(XModel.class, (Object)xOfficeDBDoc);
            XController aController = xDBSource.getCurrentController();
            this.assure("Controller of xOfficeDatabaseDocument is empty!", aController != null);
            XDatabaseDocumentUI aDBDocUI = UnoRuntime.queryInterface(XDatabaseDocumentUI.class, (Object)aController);
            aDBDocUI.connect();
            XConnection aActiveConnectionObj = aDBDocUI.getActiveConnection();
            this.assure("ActiveConnection is empty", aActiveConnectionObj != null);
            XReportDocumentsSupplier xSupplier = UnoRuntime.queryInterface(XReportDocumentsSupplier.class, (Object)xOfficeDBDoc);
            xNameAccess = xSupplier.getReportDocuments();
            this.assure("xOfficeDatabaseDocument returns no Report Document", xNameAccess != null);
            this.showElements(xNameAccess);
            ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
            PropertyValue aActiveConnection = new PropertyValue();
            aActiveConnection.Name = "ActiveConnection";
            aActiveConnection.Value = aActiveConnectionObj;
            aPropertyList.add(aActiveConnection);
            this.loadAndStoreReports(xNameAccess, aPropertyList);
            this.createDBEntry();
        }
        catch (Exception e) {
            log.println("ERROR: Exception caught");
            log.println("Message: " + e.getMessage());
        }
        this.closeComponent(xDocComponent);
    }

    private String getDocumentPoolName() {
        return "AutogenReportDesignTest";
    }

    private void createDBEntry() {
        String sDBConnection = (String)param.get("DB_CONNECTION_STRING");
        log.println("DBConnection: " + sDBConnection);
        DB.init(sDBConnection);
        String sFixRefSubDirectory = "ReportDesignFixRef";
        String sSourceVersion = m_sSourceVersion;
        String sSourceName = m_sSourceName;
        String sSourceCreatorType = "";
        String sDestinationVersion = m_sDestinationVersion;
        String sDestinationName = m_sDestinationName;
        String sDestinationCreatorType = "";
        String sDocumentPoolDir = this.getOutputPath();
        String sDocumentPoolName = this.getDocumentPoolName();
        String sSpecial = "";
        DB.insertinto_documentcompare(sSourceVersion, sSourceName, sSourceCreatorType, m_sDestinationVersion, sDestinationName, sDestinationCreatorType, sDocumentPoolDir, sDocumentPoolName, this.m_sMailAddress, sSpecial, this.m_sParentDistinct);
        TimeHelper.waitInSeconds(1, "wait for DB.");
    }

    private void loadAndStoreReports(XNameAccess _xNameAccess, ArrayList _aPropertyList) {
        if (_xNameAccess != null) {
            String[] sElementNames = _xNameAccess.getElementNames();
            for (int i = 0; i < sElementNames.length; ++i) {
                String sReportName = sElementNames[i];
                XComponent xDoc = this.loadComponent(sReportName, _xNameAccess, _aPropertyList);
                this.storeComponent(sReportName, xDoc);
                this.closeComponent(xDoc);
            }
        }
    }

    private String getFormatExtension(Object _xComponent) {
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, _xComponent);
        String sExtension = xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument") ? ".ods" : (xServiceInfo.supportsService("com.sun.star.text.TextDocument") ? ".odt" : ".UNKNOWN");
        return sExtension;
    }

    private String getOutputPath() {
        if (this.m_sOutputPath == null) {
            String sOutputPath = (String)param.get("DOC_COMPARATOR_OUTPUT_PATH");
            if (!(sOutputPath = StringHelper.removeQuoteIfExists(sOutputPath)).endsWith("/") || !sOutputPath.endsWith("\\")) {
                sOutputPath = sOutputPath + System.getProperty("file.separator");
            }
            sOutputPath = sOutputPath + DateHelper.getDateTimeForFilename();
            sOutputPath = sOutputPath + System.getProperty("file.separator");
            File aOutputFile = new File(sOutputPath);
            aOutputFile.mkdirs();
            this.m_sOutputPath = sOutputPath;
        }
        return this.m_sOutputPath;
    }

    private void storeComponent(String _sName, Object _xComponent) {
        String sOutputPath = this.getOutputPath();
        sOutputPath = sOutputPath + this.getDocumentPoolName();
        sOutputPath = sOutputPath + System.getProperty("file.separator");
        File aOutputFile = new File(sOutputPath);
        aOutputFile.mkdirs();
        sOutputPath = sOutputPath + _sName;
        sOutputPath = sOutputPath + this.getFormatExtension(_xComponent);
        String sOutputURL = URLHelper.getFileURLFromSystemPath(sOutputPath);
        ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
        PropertyValue aOverwrite = new PropertyValue();
        aOverwrite.Name = "Overwrite";
        aOverwrite.Value = Boolean.TRUE;
        aPropertyList.add(aOverwrite);
        XStorable aStorable = UnoRuntime.queryInterface(XStorable.class, _xComponent);
        if (aStorable != null) {
            log.println("store document as URL: '" + sOutputURL + "'");
            try {
                aStorable.storeAsURL(sOutputURL, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
            }
            catch (IOException e) {
                log.println("ERROR: Exception caught");
                log.println("Can't write document URL: '" + sOutputURL + "'");
                log.println("Message: " + e.getMessage());
            }
        }
    }

    private XComponent loadComponent(String _sName, Object _xComponent, ArrayList _aPropertyList) {
        XComponent xDocComponent = null;
        XComponentLoader xComponentLoader = UnoRuntime.queryInterface(XComponentLoader.class, _xComponent);
        try {
            PropertyValue[] aLoadProperties = PropertyHelper.createPropertyValueArrayFormArrayList(_aPropertyList);
            log.println("Load component: '" + _sName + "'");
            xDocComponent = xComponentLoader.loadComponentFromURL(_sName, "_blank", 0, aLoadProperties);
            log.println("Load component: '" + _sName + "' done");
        }
        catch (IOException e) {
            log.println("ERROR: Exception caught");
            log.println("Can't load document '" + _sName + "'");
            log.println("Message: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            log.println("ERROR: Exception caught");
            log.println("Illegal Arguments given to loadComponentFromURL.");
            log.println("Message: " + e.getMessage());
        }
        return xDocComponent;
    }

    private void closeComponent(XComponent _xDoc) {
        XCloseable xCloseable = UnoRuntime.queryInterface(XCloseable.class, (Object)_xDoc);
        try {
            xCloseable.close(true);
        }
        catch (CloseVetoException e) {
            log.println("ERROR: CloseVetoException caught");
            log.println("CloseVetoException occured Can't close document.");
            log.println("Message: " + e.getMessage());
        }
    }
}

