/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XNameAccess;
import com.sun.star.document.XTypeDetection;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XModel;
import com.sun.star.frame.XStorable;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.view.XPrintable;
import convwatch.ConvWatchCancelException;
import convwatch.DB;
import convwatch.DateHelper;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.MSOfficePrint;
import convwatch.TimeHelper;
import helper.OSHelper;
import helper.PropertyHelper;
import helper.URLHelper;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;

public class OfficePrint {
    private static void showProperty(PropertyValue _aValue) {
        String sName = _aValue.Name;
        try {
            String sValue = AnyConverter.toString((Object)_aValue.Value);
            GlobalLogWriter.get().println("Property " + sName + ":=" + sValue);
        }
        catch (IllegalArgumentException e) {
            GlobalLogWriter.get().println("showProperty: can't convert a object to string.");
        }
    }

    static String getDocumentType(XComponent _aDoc) {
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)_aDoc);
        PropertyValue[] aArgs = xModel.getArgs();
        for (int i = 0; i < aArgs.length; ++i) {
            PropertyValue aValue = aArgs[i];
            if (!aValue.Name.equals("FilterName") && !aValue.Name.equals("MediaType")) continue;
            String sNameValue = "'" + aValue.Name + "' := '" + aValue.Value + "'";
            return sNameValue;
        }
        return "";
    }

    static void showDocumentType(XComponent _aDoc) {
        String sNameValue = OfficePrint.getDocumentType(_aDoc);
        GlobalLogWriter.get().println("  Property: '" + sNameValue);
    }

    public static XComponent loadFromURL(GraphicalTestArguments _aGTA, String _sInputURL) {
        XComponent aDoc = null;
        try {
            if (_aGTA.getMultiServiceFactory() == null) {
                GlobalLogWriter.get().println("MultiServiceFactory in GraphicalTestArgument not set.");
                return null;
            }
            Object oDsk = _aGTA.getMultiServiceFactory().createInstance("com.sun.star.frame.Desktop");
            XDesktop aDesktop = UnoRuntime.queryInterface(XDesktop.class, oDsk);
            if (aDesktop != null) {
                PropertyValue Arg;
                GlobalLogWriter.get().println("com.sun.star.frame.Desktop created.");
                ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
                if (_aGTA.isHidden()) {
                    Arg = new PropertyValue();
                    Arg.Name = "Hidden";
                    Arg.Value = Boolean.TRUE;
                    aPropertyList.add(Arg);
                    OfficePrint.showProperty(Arg);
                }
                if (_aGTA.getImportFilterName() != null && _aGTA.getImportFilterName().length() > 0) {
                    Arg = new PropertyValue();
                    Arg.Name = "FilterName";
                    Arg.Value = _aGTA.getImportFilterName();
                    aPropertyList.add(Arg);
                    OfficePrint.showProperty(Arg);
                }
                GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Load document");
                XComponentLoader aCompLoader = UnoRuntime.queryInterface(XComponentLoader.class, (Object)aDesktop);
                _aGTA.getPerformance().startTime(0);
                aDoc = aCompLoader.loadComponentFromURL(_sInputURL, "_blank", 0, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
                _aGTA.getPerformance().stopTime(0);
                if (aDoc != null) {
                    GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Load document done.");
                    OfficePrint.showDocumentType(aDoc);
                    _aGTA.setDocumentType(OfficePrint.getDocumentType(aDoc));
                } else {
                    GlobalLogWriter.get().println(" Load document failed.");
                    if (_aGTA.getImportFilterName() != null && _aGTA.getImportFilterName().length() > 0) {
                        GlobalLogWriter.get().println(" Please check FilterName := '" + _aGTA.getImportFilterName() + "'");
                    }
                    GlobalLogWriter.get().println("");
                }
            } else {
                GlobalLogWriter.get().println("com.sun.star.frame.Desktop failed.");
            }
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("UNO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            e.printStackTrace();
            aDoc = null;
        }
        return aDoc;
    }

    static boolean exportToPDF(XComponent _xComponent, String _sDestinationName) {
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)_xComponent);
        ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
        PropertyValue aFiltername = new PropertyValue();
        aFiltername.Name = "FilterName";
        aFiltername.Value = OfficePrint.getFilterName_forPDF(xServiceInfo);
        aPropertyList.add(aFiltername);
        OfficePrint.showProperty(aFiltername);
        boolean bWorked = true;
        try {
            XStorable store = UnoRuntime.queryInterface(XStorable.class, (Object)_xComponent);
            store.storeToURL(_sDestinationName, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
        }
        catch (com.sun.star.io.IOException e) {
            GlobalLogWriter.get().println("IO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            bWorked = false;
        }
        return bWorked;
    }

    static String getFilterName_forPDF(XServiceInfo xServiceInfo) {
        String filterName = "";
        if (xServiceInfo.supportsService("com.sun.star.text.TextDocument")) {
            filterName = "writer_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            filterName = "calc_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.drawing.DrawingDocument")) {
            filterName = "draw_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.presentation.PresentationDocument")) {
            filterName = "impress_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.text.WebDocument")) {
            filterName = "writer_web_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.text.GlobalDocument")) {
            filterName = "writer_globaldocument_pdf_Export";
        } else if (xServiceInfo.supportsService("com.sun.star.formulaFormulaProperties")) {
            filterName = "math_pdf_Export";
        }
        return filterName;
    }

    public static boolean storeAsPDF(GraphicalTestArguments _aGTA, String _sInputURL, String _sOutputURL) {
        boolean bBack = false;
        XComponent aDoc = OfficePrint.loadFromURL(_aGTA, _sInputURL);
        if (aDoc == null) {
            GlobalLogWriter.get().println("Can't load document.");
            return bBack;
        }
        bBack = OfficePrint.storeAsPDF(_aGTA, aDoc, _sOutputURL);
        OfficePrint.createInfoFile(_sOutputURL, _aGTA, "as pdf");
        GlobalLogWriter.get().println("Close document.");
        aDoc.dispose();
        return bBack;
    }

    public static boolean storeAsPDF(GraphicalTestArguments _aGTA, XComponent _aDoc, String _sOutputURL) {
        boolean bBack = true;
        _aGTA.getPerformance().startTime(4);
        bBack = OfficePrint.exportToPDF(_aDoc, _sOutputURL);
        _aGTA.getPerformance().stopTime(4);
        if (!bBack) {
            GlobalLogWriter.get().println("Can't store document as PDF.");
            bBack = false;
        }
        return bBack;
    }

    public static boolean printToFileWithOOo(GraphicalTestArguments _aGTA, String _sInputURL, String _sOutputURL, String _sPrintFileURL) {
        boolean bBack = false;
        XComponent aDoc = OfficePrint.loadFromURL(_aGTA, _sInputURL);
        if (aDoc != null) {
            if (_sInputURL.equals(_sOutputURL)) {
                GlobalLogWriter.get().println("Warning: Inputpath and Outputpath are equal. Document will not stored again.");
                _aGTA.disallowStore();
            }
            bBack = OfficePrint.impl_printToFileWithOOo(_aGTA, aDoc, _sOutputURL, _sPrintFileURL);
            GlobalLogWriter.get().println("Close document.");
            aDoc.dispose();
        } else {
            GlobalLogWriter.get().println("loadDocumentFromURL() failed with document: " + _sInputURL);
        }
        return bBack;
    }

    public static void createInfoFile(String _sFile, GraphicalTestArguments _aGTA) {
        OfficePrint.createInfoFile(_sFile, _aGTA, "");
    }

    public static void createInfoFile(String _sFile, GraphicalTestArguments _aGTA, String _sSpecial) {
        String sFilename;
        if (_sFile.startsWith("file://")) {
            sFilename = FileHelper.getSystemPathFromFileURL(_sFile);
            GlobalLogWriter.get().println("CreateInfoFile: '" + sFilename + "'");
        } else {
            sFilename = _sFile;
        }
        String sFileDir = FileHelper.getPath(sFilename);
        String sBasename = FileHelper.getBasename(sFilename);
        String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String fs = System.getProperty("file.separator");
        String ls = System.getProperty("line.separator");
        String sInfoFilename = sFileDir + fs + sNameNoSuffix + ".info";
        File aInfoFile = new File(sInfoFilename);
        String sBuildID = "";
        try {
            FileWriter out = new FileWriter(aInfoFile.toString());
            out.write("# automatically created file by graphical compare" + ls);
            if (_aGTA != null) {
                if (_sSpecial != null && _sSpecial.equals("msoffice")) {
                    out.write("# buildid from wordloadfile" + ls);
                    sBuildID = _aGTA.getPerformance().getMSOfficeVersion();
                    out.write("buildid=" + sBuildID + ls);
                } else {
                    out.write("# buildid is read out of the bootstrap file" + ls);
                    sBuildID = _aGTA.getBuildID();
                    out.write("buildid=" + sBuildID + ls);
                }
                out.write(ls);
                out.write("# resolution given in DPI" + ls);
                out.write("resolution=" + _aGTA.getResolutionInDPI() + ls);
            } else {
                out.write("buildid=" + _sSpecial + ls);
            }
            out.write(ls);
            out.write("# Values out of System.getProperty(...)" + ls);
            out.write("os.name=" + System.getProperty("os.name") + ls);
            out.write("os.arch=" + System.getProperty("os.arch") + ls);
            out.write("os.version=" + System.getProperty("os.version") + ls);
            if (_aGTA != null) {
                out.write(ls);
                out.write("# Performance output, values are given in milli sec." + ls);
                _aGTA.getPerformance().print(out);
            }
            out.flush();
            out.close();
        }
        catch (IOException e) {
            GlobalLogWriter.get().println("can't create Info file.");
            e.printStackTrace();
        }
        String sExtension = FileHelper.getSuffix(_aGTA.getInputFile());
        if (sExtension.startsWith(".")) {
            sExtension = sExtension.substring(1);
        }
        DB.writeToDB(_aGTA.getInputFile(), sNameNoSuffix, sExtension, sBuildID, _aGTA.getReferenceType(), _aGTA.getResolutionInDPI());
    }

    private static boolean impl_printToFileWithOOo(GraphicalTestArguments _aGTA, XComponent _aDoc, String _sOutputURL, String _sPrintFileURL) {
        boolean bBack = false;
        boolean bFailed = true;
        if (_aDoc == null) {
            GlobalLogWriter.get().println("No document is given.");
            return bBack;
        }
        try {
            XStorable aStorable;
            if (_sOutputURL != null && _aGTA.isStoreAllowed() && (aStorable = UnoRuntime.queryInterface(XStorable.class, (Object)_aDoc)) != null) {
                PropertyValue[] szEmptyArgs = new PropertyValue[]{};
                GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Store document.");
                _aGTA.getPerformance().startTime(1);
                aStorable.storeAsURL(_sOutputURL, szEmptyArgs);
                _aGTA.getPerformance().stopTime(1);
                GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Store document done.");
                TimeHelper.waitInSeconds(2, "After store as URL to:" + _sOutputURL);
                GlobalLogWriter.get().println("Reload stored file test.");
                XComponent aDoc = OfficePrint.loadFromURL(_aGTA, _sOutputURL);
                if (aDoc == null) {
                    GlobalLogWriter.get().println("Reload stored file test failed, can't reload file: " + _sOutputURL);
                }
            }
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("UNO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            e.printStackTrace();
            bBack = false;
        }
        try {
            GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Print document.");
            XPrintable aPrintable = UnoRuntime.queryInterface(XPrintable.class, (Object)_aDoc);
            if (aPrintable != null) {
                XMultiServiceFactory xMSF;
                Object aSettings;
                XServiceInfo xServiceInfo;
                if (OSHelper.isWindows() && _aGTA.getPrinterName() != null) {
                    ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
                    PropertyValue Arg = new PropertyValue();
                    Arg.Name = "Name";
                    Arg.Value = _aGTA.getPrinterName();
                    aPropertyList.add(Arg);
                    OfficePrint.showProperty(Arg);
                    aPrintable.setPrinter(PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
                }
                if ((xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)_aDoc)).supportsService("com.sun.star.sheet.SpreadsheetDocument") && (aSettings = (xMSF = _aGTA.getMultiServiceFactory()).createInstance("com.sun.star.sheet.GlobalSheetSettings")) != null) {
                    XPropertySet xPropSet = UnoRuntime.queryInterface(XPropertySet.class, aSettings);
                    xPropSet.setPropertyValue("PrintAllSheets", new Boolean(true));
                }
                ArrayList<PropertyValue> aPrintProps = new ArrayList<PropertyValue>();
                GlobalLogWriter.get().println("Property FileName:=" + _sPrintFileURL);
                PropertyValue Arg = new PropertyValue();
                Arg.Name = "FileName";
                Arg.Value = _sPrintFileURL;
                aPrintProps.add(Arg);
                if (!_aGTA.printAllPages()) {
                    String sPages = "";
                    if (_aGTA.getMaxPages() > 0) {
                        sPages = "1-" + String.valueOf(_aGTA.getMaxPages());
                    }
                    if (_aGTA.getOnlyPages().length() != 0) {
                        if (sPages.length() != 0) {
                            sPages = sPages + ";";
                        }
                        sPages = sPages + String.valueOf(_aGTA.getOnlyPages());
                    }
                    Arg = new PropertyValue();
                    Arg.Name = "Pages";
                    Arg.Value = sPages;
                    aPrintProps.add(Arg);
                }
                OfficePrint.showProperty(Arg);
                _aGTA.getPerformance().startTime(2);
                aPrintable.print(PropertyHelper.createPropertyValueArrayFormArrayList(aPrintProps));
                TimeHelper.waitInSeconds(1, "Start waiting for print ready.");
                GlobalLogWriter.get().println("Wait until document is printed.");
                boolean isBusy = true;
                int nPrintCount = 0;
                while (isBusy) {
                    PropertyValue[] aPrinterProps = aPrintable.getPrinter();
                    int nPropIndex = 0;
                    while (!"IsBusy".equals(aPrinterProps[nPropIndex].Name)) {
                        ++nPropIndex;
                    }
                    isBusy = aPrinterProps[nPropIndex].Value == Boolean.TRUE;
                    TimeHelper.waitInSeconds(1, "is print ready?");
                    if (++nPrintCount <= 3600) continue;
                    GlobalLogWriter.get().println("ERROR: Cancel print due to too long wait.");
                    throw new Exception("Convwatch exception, wait too long for printing.");
                }
                _aGTA.getPerformance().stopTime(2);
                GlobalLogWriter.get().println(DateHelper.getDateTimeForHumanreadableLog() + " Print document done.");
                OfficePrint.createInfoFile(_sPrintFileURL, _aGTA);
            } else {
                GlobalLogWriter.get().println("Can't get XPrintable interface.");
            }
            bFailed = false;
            bBack = true;
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("UNO Exception caught.");
            GlobalLogWriter.get().println("Message: " + e.getMessage());
            e.printStackTrace();
            bBack = false;
        }
        if (bFailed) {
            GlobalLogWriter.get().println("convwatch.OfficePrint: FAILED");
        } else {
            GlobalLogWriter.get().println("convwatch.OfficePrint: OK");
        }
        return bBack;
    }

    public static boolean isReferenceExists(GraphicalTestArguments _aGTA, String _sAbsoluteOutputPath, String _sAbsoluteInputFile) {
        String sInputPath;
        if (!FileHelper.exists(_sAbsoluteInputFile)) {
            return false;
        }
        String fs = System.getProperty("file.separator");
        String sInputFileBasename = FileHelper.getBasename(_sAbsoluteInputFile);
        String sOutputPath = _sAbsoluteOutputPath != null ? _sAbsoluteOutputPath : (sInputPath = FileHelper.getPath(_sAbsoluteInputFile));
        String sPrintFilename = FileHelper.getNameNoSuffix(sInputFileBasename);
        String sAbsolutePrintFilename = sOutputPath + fs + sPrintFilename + ".prn";
        if (FileHelper.exists(sAbsolutePrintFilename) && !_aGTA.getOverwrite()) {
            GlobalLogWriter.get().println("Reference already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
            return true;
        }
        return false;
    }

    public static boolean buildReference(GraphicalTestArguments _aGTA, String _sAbsoluteOutputPath, String _sAbsoluteInputFile) throws ConvWatchCancelException {
        String sPrintFileURL;
        String sOutputPath;
        if (!FileHelper.exists(_sAbsoluteInputFile)) {
            throw new ConvWatchCancelException("buildReference(): Input file: " + _sAbsoluteInputFile + " does not exist.");
        }
        String fs = System.getProperty("file.separator");
        String sInputFileURL = URLHelper.getFileURLFromSystemPath(_sAbsoluteInputFile);
        String sInputFileBasename = FileHelper.getBasename(_sAbsoluteInputFile);
        String sOutputFileURL = null;
        if (_sAbsoluteOutputPath != null) {
            sOutputPath = _sAbsoluteOutputPath;
            FileHelper.makeDirectories("", sOutputPath);
        } else {
            String sInputPath;
            sOutputPath = sInputPath = FileHelper.getPath(_sAbsoluteInputFile);
        }
        sOutputFileURL = null;
        String sPrintFilename = FileHelper.getNameNoSuffix(sInputFileBasename);
        String sAbsolutePrintFilename = sOutputPath + fs + sPrintFilename + ".prn";
        if (FileHelper.exists(sAbsolutePrintFilename) && !_aGTA.getOverwrite()) {
            GlobalLogWriter.get().println("Reference already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
            return true;
        }
        if (_aGTA.getReferenceType().toLowerCase().equals("msoffice")) {
            sPrintFileURL = URLHelper.getFileURLFromSystemPath(sAbsolutePrintFilename);
        } else if (_aGTA.getReferenceType().toLowerCase().equals("pdf")) {
            sPrintFileURL = URLHelper.getFileURLFromSystemPath(sAbsolutePrintFilename);
        } else if (_aGTA.getReferenceType().toLowerCase().equals("ooo")) {
            sPrintFileURL = URLHelper.getFileURLFromSystemPath(sAbsolutePrintFilename);
        } else {
            GlobalLogWriter.get().println("OfficePrint.buildreference(): Unknown print type.");
            return false;
        }
        return OfficePrint.printToFile(_aGTA, sInputFileURL, sOutputFileURL, sPrintFileURL);
    }

    public static boolean printToFile(GraphicalTestArguments _aGTA, String _sInputFileURL, String _sOutputFileURL, String _sPrintFileURL) throws ConvWatchCancelException {
        boolean bBack = false;
        Object sPrintFileURL = null;
        String sDocumentSuffix = FileHelper.getSuffix(_sInputFileURL);
        if (sDocumentSuffix.toLowerCase().endsWith(".png") || sDocumentSuffix.toLowerCase().endsWith(".gif") || sDocumentSuffix.toLowerCase().endsWith(".jpg") || sDocumentSuffix.toLowerCase().endsWith(".bmp")) {
            return false;
        }
        if (_aGTA.getReferenceType().toLowerCase().equals("ooo")) {
            bBack = OfficePrint.printToFileWithOOo(_aGTA, _sInputFileURL, _sOutputFileURL, _sPrintFileURL);
        } else if (_aGTA.getReferenceType().toLowerCase().equals("pdf")) {
            GlobalLogWriter.get().println("USE PDF AS EXPORT FORMAT.");
            bBack = OfficePrint.storeAsPDF(_aGTA, _sInputFileURL, _sPrintFileURL);
        } else if (_aGTA.getReferenceType().toLowerCase().equals("msoffice")) {
            if (MSOfficePrint.isMSOfficeDocumentFormat(_sInputFileURL)) {
                GlobalLogWriter.get().println("USE MSOFFICE AS EXPORT FORMAT.");
                MSOfficePrint a = new MSOfficePrint();
                try {
                    a.printToFileWithMSOffice(_aGTA, FileHelper.getSystemPathFromFileURL(_sInputFileURL), FileHelper.getSystemPathFromFileURL(_sPrintFileURL));
                }
                catch (ConvWatchCancelException e) {
                    e.printStackTrace();
                    GlobalLogWriter.get().println(e.getMessage());
                    throw new ConvWatchCancelException("Exception caught. Problem with MSOffice printer methods.");
                }
                catch (IOException e) {
                    GlobalLogWriter.get().println(e.getMessage());
                    throw new ConvWatchCancelException("IOException caught. Problem with MSOffice printer methods.");
                }
                bBack = true;
            } else {
                GlobalLogWriter.get().println("This document type is not recognized as MSOffice format, as default fallback StarOffice/OpenOffice.org instead is used.");
                bBack = OfficePrint.printToFileWithOOo(_aGTA, _sInputFileURL, _sOutputFileURL, _sPrintFileURL);
            }
        } else {
            throw new ConvWatchCancelException("OfficePrint.printToFile(): Unknown print type.");
        }
        return bBack;
    }

    static void showType(String _sInputURL, XMultiServiceFactory _xMSF) {
        if (_sInputURL.length() == 0) {
            return;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return;
        }
        XTypeDetection aTypeDetection = null;
        try {
            Object oObj = _xMSF.createInstance("com.sun.star.document.TypeDetection");
            aTypeDetection = UnoRuntime.queryInterface(XTypeDetection.class, oObj);
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.TypeDetection.");
            return;
        }
        if (aTypeDetection != null) {
            String sType = aTypeDetection.queryTypeByURL(_sInputURL);
            GlobalLogWriter.get().println("Type is: " + sType);
        }
    }

    public static String getInternalFilterName(String _sFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sFilterName.length() == 0) {
            return null;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        Object aObj = null;
        try {
            aObj = _xMSF.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return null;
        }
        if (aObj != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, aObj)) != null) {
            if (!aNameAccess.hasByName(_sFilterName)) {
                GlobalLogWriter.get().println("FilterFactory.hasByName() says there exist no '" + _sFilterName + "'");
                return null;
            }
            Object[] aElements = null;
            try {
                aElements = (Object[])aNameAccess.getByName(_sFilterName);
                if (aElements != null) {
                    String sInternalFilterName = null;
                    for (int i = 0; i < aElements.length; ++i) {
                        String sValue;
                        PropertyValue aPropertyValue = (PropertyValue)aElements[i];
                        if (!aPropertyValue.Name.equals("Type")) continue;
                        sInternalFilterName = sValue = (String)aPropertyValue.Value;
                    }
                    return sInternalFilterName;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + _sFilterName + "'");
                return null;
            }
            catch (NoSuchElementException e) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + e.getMessage());
            }
            catch (WrappedTargetException e) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + e.getMessage());
            }
        }
        return null;
    }

    static String getServiceNameFromFilterName(String _sFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sFilterName.length() == 0) {
            return null;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        Object aObj = null;
        try {
            aObj = _xMSF.createInstance("com.sun.star.document.FilterFactory");
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.FilterFactory.");
            return null;
        }
        if (aObj != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, aObj)) != null) {
            if (!aNameAccess.hasByName(_sFilterName)) {
                GlobalLogWriter.get().println("FilterFactory.hasByName() says there exist no '" + _sFilterName + "'");
                return null;
            }
            Object[] aElements = null;
            try {
                aElements = (Object[])aNameAccess.getByName(_sFilterName);
                if (aElements != null) {
                    String sServiceName = null;
                    for (int i = 0; i < aElements.length; ++i) {
                        String sValue;
                        PropertyValue aPropertyValue = (PropertyValue)aElements[i];
                        if (!aPropertyValue.Name.equals("DocumentService")) continue;
                        sServiceName = sValue = (String)aPropertyValue.Value;
                        break;
                    }
                    return sServiceName;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + _sFilterName + "'");
                return null;
            }
            catch (NoSuchElementException e) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + e.getMessage());
            }
            catch (WrappedTargetException e) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + e.getMessage());
            }
        }
        return null;
    }

    public static String getFileExtension(String _sInternalFilterName, XMultiServiceFactory _xMSF) {
        XNameAccess aNameAccess;
        if (_sInternalFilterName.length() == 0) {
            return null;
        }
        if (_xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory not set.");
            return null;
        }
        XTypeDetection aTypeDetection = null;
        try {
            Object oObj = _xMSF.createInstance("com.sun.star.document.TypeDetection");
            aTypeDetection = UnoRuntime.queryInterface(XTypeDetection.class, oObj);
        }
        catch (Exception e) {
            GlobalLogWriter.get().println("Can't get com.sun.star.document.TypeDetection.");
            return null;
        }
        if (aTypeDetection != null && (aNameAccess = UnoRuntime.queryInterface(XNameAccess.class, (Object)aTypeDetection)) != null) {
            if (!aNameAccess.hasByName(_sInternalFilterName)) {
                GlobalLogWriter.get().println("TypeDetection.hasByName() says there exist no '" + _sInternalFilterName + "'");
                return null;
            }
            Object[] aElements = null;
            try {
                aElements = (Object[])aNameAccess.getByName(_sInternalFilterName);
                if (aElements != null) {
                    String sExtension = null;
                    for (int i = 0; i < aElements.length; ++i) {
                        PropertyValue aPropertyValue = (PropertyValue)aElements[i];
                        if (!aPropertyValue.Name.equals("Extensions")) continue;
                        String[] aExtensions = (String[])aPropertyValue.Value;
                        GlobalLogWriter.get().println("   Possible extensions are: " + String.valueOf(aExtensions.length));
                        if (aExtensions.length <= 0) continue;
                        for (int j = 0; j < aExtensions.length; ++j) {
                            GlobalLogWriter.get().println(" " + aExtensions[j]);
                        }
                        sExtension = aExtensions[0];
                        GlobalLogWriter.get().println("");
                    }
                    return sExtension;
                }
                GlobalLogWriter.get().println("There are no elements for FilterName '" + _sInternalFilterName + "'");
                return null;
            }
            catch (NoSuchElementException e) {
                GlobalLogWriter.get().println("NoSuchElementException caught. " + e.getMessage());
            }
            catch (WrappedTargetException e) {
                GlobalLogWriter.get().println("WrappedTargetException caught. " + e.getMessage());
            }
        }
        return null;
    }

    public static void convertDocument(String _sInputFile, String _sOutputPath, GraphicalTestArguments _aGTA) throws ConvWatchCancelException {
        XMultiServiceFactory xMSF = _aGTA.getMultiServiceFactory();
        if (xMSF == null) {
            GlobalLogWriter.get().println("MultiServiceFactory in GraphicalTestArgument not set.");
            return;
        }
        String sInputURL = URLHelper.getFileURLFromSystemPath(_sInputFile);
        XComponent aDoc = OfficePrint.loadFromURL(_aGTA, sInputURL);
        if (aDoc == null) {
            GlobalLogWriter.get().println("Can't load document '" + sInputURL + "'");
            return;
        }
        if (_sOutputPath == null) {
            GlobalLogWriter.get().println("Outputpath not set.");
            return;
        }
        if (!_aGTA.isStoreAllowed()) {
            GlobalLogWriter.get().println("It's not allowed to store, check Input/Output path.");
            return;
        }
        TimeHelper.waitInSeconds(1, "wait after loadFromURL.");
        XServiceInfo xServiceInfo = UnoRuntime.queryInterface(XServiceInfo.class, (Object)aDoc);
        XStorable xStorable = UnoRuntime.queryInterface(XStorable.class, (Object)aDoc);
        if (xStorable == null) {
            GlobalLogWriter.get().println("com.sun.star.frame.XStorable is null");
            return;
        }
        String sFilterName = _aGTA.getExportFilterName();
        boolean nPropertyCount = false;
        ArrayList<PropertyValue> aPropertyList = new ArrayList<PropertyValue>();
        String sExtension = "";
        if (sFilterName != null && sFilterName.length() > 0) {
            String sInternalFilterName = OfficePrint.getInternalFilterName(sFilterName, xMSF);
            String sServiceName = OfficePrint.getServiceNameFromFilterName(sFilterName, xMSF);
            GlobalLogWriter.get().println("Filter detection:");
            boolean bServiceFailed = false;
            if (sServiceName == null || sInternalFilterName == null) {
                GlobalLogWriter.get().println("Given FilterName '" + sFilterName + "' seems to be unknown.");
                bServiceFailed = true;
            }
            if (!xServiceInfo.supportsService(sServiceName)) {
                GlobalLogWriter.get().println("Service from FilterName '" + sServiceName + "' is not supported by loaded document.");
                bServiceFailed = true;
            }
            if (bServiceFailed) {
                GlobalLogWriter.get().println("Please check 'DOC_CONVERTER_EXPORT_FILTER_NAME' in the property file.");
                return;
            }
            if (sInternalFilterName != null && sInternalFilterName.length() > 0 && (sExtension = OfficePrint.getFileExtension(sInternalFilterName, xMSF)) == null) {
                GlobalLogWriter.get().println("Can't found an extension for filtername, take it from the source.");
            }
            PropertyValue Arg = new PropertyValue();
            Arg.Name = "FilterName";
            Arg.Value = sFilterName;
            aPropertyList.add(Arg);
            OfficePrint.showProperty(Arg);
            GlobalLogWriter.get().println("FilterName is set to: " + sFilterName);
        }
        String sOutputURL = "";
        try {
            String sInputFileBasename = FileHelper.getBasename(_sInputFile);
            String sInputFileNameNoSuffix = FileHelper.getNameNoSuffix(sInputFileBasename);
            String fs = System.getProperty("file.separator");
            String sOutputFile = _sOutputPath;
            if (!sOutputFile.endsWith(fs)) {
                sOutputFile = sOutputFile + fs;
            }
            if (FileHelper.exists(sOutputFile = sExtension != null && sExtension.length() > 0 ? sOutputFile + sInputFileNameNoSuffix + "." + sExtension : sOutputFile + sInputFileBasename) && !_aGTA.getOverwrite()) {
                GlobalLogWriter.get().println("File already exist, don't overwrite. Set DOC_COMPARATOR_OVERWRITE_REFERENCE=true to force overwrite.");
                return;
            }
            sOutputURL = URLHelper.getFileURLFromSystemPath(sOutputFile);
            GlobalLogWriter.get().println("Store document as '" + sOutputURL + "'");
            xStorable.storeAsURL(sOutputURL, PropertyHelper.createPropertyValueArrayFormArrayList(aPropertyList));
            GlobalLogWriter.get().println("Document stored.");
        }
        catch (com.sun.star.io.IOException e) {
            GlobalLogWriter.get().println("Can't store document '" + sOutputURL + "'. Message is :'" + e.getMessage() + "'");
        }
        TimeHelper.waitInSeconds(1, "unknown in OfficePrint.convertDocument()");
    }
}

