/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.frame.XStorable;
import com.sun.star.io.IOException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.uno.UnoRuntime;
import convwatch.ConvWatch;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DirectoryHelper;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.OfficePrint;
import helper.URLHelper;
import java.io.File;

public class GraphicalDifferenceCheck {
    private static void showVersion() {
        if (FileHelper.isDebugEnabled()) {
            GlobalLogWriter.get().println("");
            GlobalLogWriter.get().println("+##############################+");
            GlobalLogWriter.get().println("##### THIS IS CONVWATCH    #####");
            GlobalLogWriter.get().println("##### Debug Version 1.0015 #####");
            GlobalLogWriter.get().println("+##############################+");
            GlobalLogWriter.get().println("");
        }
    }

    public static void createReferences(String _sInputPath, String _sReferencePath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        File aInputPath = new File(_sInputPath);
        if (aInputPath.isDirectory()) {
            String fs = System.getProperty("file.separator");
            String sRemovePath = aInputPath.getAbsolutePath();
            Object[] aList = DirectoryHelper.traverse(_sInputPath, FileHelper.getFileFilter(), _aGTA.includeSubDirectories());
            for (int i = 0; i < aList.length; ++i) {
                String sEntry = (String)aList[i];
                String sNewReferencePath = _sReferencePath + fs + FileHelper.removeFirstDirectorysAndBasenameFrom(sEntry, _sInputPath);
                GraphicalDifferenceCheck.createOneReferenceFile(sEntry, sNewReferencePath, _aGTA);
            }
        } else {
            GraphicalDifferenceCheck.createOneReferenceFile(_sInputPath, _sReferencePath, _aGTA);
        }
    }

    public static boolean createOneReferenceFile(String _sInputFile, String _sReferencePath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        if (_aGTA != null) {
            _aGTA.setInputFile(_sInputFile);
        }
        return OfficePrint.buildReference(_aGTA, _sReferencePath, _sInputFile);
    }

    public static boolean isReferenceExists(String _sInputFile, String _sReferencePath, GraphicalTestArguments _aGTA) {
        return OfficePrint.isReferenceExists(_aGTA, _sReferencePath, _sInputFile);
    }

    public static boolean check(String _sInputPath, String _sOutputPath, String _sReferencePath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        return GraphicalDifferenceCheck.check(_sInputPath, _sOutputPath, _sReferencePath, null, _aGTA);
    }

    public static boolean check(String _sInputPath, String _sOutputPath, String _sReferencePath, String _sDiffPath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        boolean bOk = true;
        File aInputPath = new File(_sInputPath);
        if (aInputPath.isDirectory()) {
            String fs = System.getProperty("file.separator");
            Object[] aList = DirectoryHelper.traverse(_sInputPath, FileHelper.getFileFilter(), _aGTA.includeSubDirectories());
            if (aList.length != 0) {
                for (int i = 0; i < aList.length; ++i) {
                    String sEntry = (String)aList[i];
                    String sNewSubDir = FileHelper.removeFirstDirectorysAndBasenameFrom(sEntry, _sInputPath);
                    String sNewReferencePath = _sReferencePath;
                    String sNewOutputPath = _sOutputPath;
                    String sNewDiffPath = _sDiffPath;
                    if (sNewSubDir.length() > 0) {
                        if (sNewReferencePath != null) {
                            sNewReferencePath = sNewReferencePath + fs + sNewSubDir;
                        }
                        sNewOutputPath = sNewOutputPath + fs + sNewSubDir;
                        if (sNewDiffPath != null) {
                            sNewDiffPath = sNewDiffPath + fs + sNewSubDir;
                        }
                    }
                    bOk &= GraphicalDifferenceCheck.checkOneFile(sEntry, sNewOutputPath, sNewReferencePath, sNewDiffPath, _aGTA);
                }
            }
        } else {
            bOk = GraphicalDifferenceCheck.checkOneFile(_sInputPath, _sOutputPath, _sReferencePath, _sDiffPath, _aGTA);
        }
        return bOk;
    }

    public static boolean checkOneFile(String _sInputFile, String _sOutputPath, String _sReferencePath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        return GraphicalDifferenceCheck.checkOneFile(_sInputFile, _sOutputPath, _sReferencePath, null, _aGTA);
    }

    public static boolean checkOneFile(String _sInputFile, String _sOutputPath, String _sReferencePath, String _sDiffPath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        if (_aGTA != null) {
            _aGTA.setInputFile(_sInputFile);
        }
        boolean bOk = false;
        bOk = _sDiffPath != null ? ConvWatch.checkDiffDiff(_aGTA, _sOutputPath, _sInputFile, _sReferencePath, _sDiffPath) : ConvWatch.check(_aGTA, _sOutputPath, _sInputFile, _sReferencePath);
        return bOk;
    }

    public static boolean checkOneFile(XComponent xComponent, String _sOutputPath, String _resultDocName, String _sReferencePath, GraphicalTestArguments _aGTA) throws ConvWatchException {
        GraphicalDifferenceCheck.showVersion();
        String sInputFile = GraphicalDifferenceCheck.createInputFile(xComponent, _sOutputPath, _resultDocName);
        sInputFile = FileHelper.getSystemPathFromFileURL(sInputFile);
        return ConvWatch.check(_aGTA, _sOutputPath, sInputFile, _sReferencePath);
    }

    private static String createInputFile(XComponent xComponent, String _sOutputPath, String resultDocName) throws ConvWatchCancelException {
        StringBuffer suffix = new StringBuffer();
        String exportFilter = GraphicalDifferenceCheck.getXMLOutputFilterforXComponent(xComponent, suffix);
        if (resultDocName == null) {
            resultDocName = "OOoTestDocument";
        }
        if (resultDocName.indexOf(46) == -1) {
            resultDocName = suffix.insert(0, resultDocName).toString();
        }
        String resultURL = URLHelper.getFileURLFromSystemPath(GraphicalDifferenceCheck.ensureEndingFileSep(_sOutputPath) + resultDocName);
        XStorable xStorable = null;
        xStorable = UnoRuntime.queryInterface(XStorable.class, (Object)xComponent);
        if (xStorable == null) {
            throw new ConvWatchCancelException("com.sun.star.frame.XStorable could not be instantiated from the office.");
        }
        PropertyValue pvFilterName = new PropertyValue("FilterName", -1, exportFilter, PropertyState.getDefault());
        PropertyValue pvOverwrite = new PropertyValue("Overwrite", -1, new Boolean(true), PropertyState.getDefault());
        try {
            xStorable.storeAsURL(resultURL, new PropertyValue[]{pvFilterName, pvOverwrite});
        }
        catch (IOException e) {
            throw new ConvWatchCancelException("Wrap IOException caught, " + e.getMessage());
        }
        GlobalLogWriter.get().println("Saving XComponent as " + resultURL);
        return resultURL;
    }

    private static String getXMLOutputFilterforXComponent(XComponent xComponent, StringBuffer suffix) {
        XServiceInfo xSI = UnoRuntime.queryInterface(XServiceInfo.class, (Object)xComponent);
        if (xSI.supportsService("com.sun.star.text.TextDocument")) {
            GraphicalDifferenceCheck.resetBuffer(suffix, ".sxw");
            return "swriter: StarOffice XML (Writer)";
        }
        if (xSI.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
            GraphicalDifferenceCheck.resetBuffer(suffix, ".sxc");
            return "scalc: StarOffice XML (Calc)";
        }
        if (xSI.supportsService("com.sun.star.presentation.PresentationDocument")) {
            GraphicalDifferenceCheck.resetBuffer(suffix, ".sxi");
            return "simpress: StarOffice XML (Impress)";
        }
        if (xSI.supportsService("com.sun.star.drawing.DrawingDocument")) {
            GraphicalDifferenceCheck.resetBuffer(suffix, ".sxd");
            return "sdraw: StarOffice XML (Draw)";
        }
        if (xSI.supportsService("com.sun.star.formula.FormulaProperties")) {
            GraphicalDifferenceCheck.resetBuffer(suffix, ".sxm");
            return "smath: StarOffice XML (Math)";
        }
        return null;
    }

    private static StringBuffer resetBuffer(StringBuffer sb, String suffix) {
        if (sb != null) {
            sb.replace(0, sb.length(), suffix);
        }
        return sb;
    }

    private static String ensureEndingFileSep(String s) {
        if (s != null && !s.equals("") && !s.endsWith(File.separator)) {
            s = s.trim() + File.separator;
        } else if (s == null) {
            s = "";
        }
        return s;
    }
}

