/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.FileHelper;
import convwatch.Filenamer;
import helper.StringHelper;
import helper.URLHelper;
import util.utils;

abstract class FilenameHelper_impl
implements Filenamer {
    String fs;
    String m_sPath;
    String m_sFilename;
    String m_sSuffix;
    int m_nNumber = 0;

    public String getNumber() {
        return StringHelper.createValueString(this.m_nNumber, 4);
    }

    public void setNumber(int _n) {
        this.m_nNumber = _n;
    }

    void initMember() {
        this.fs = System.getProperty("file.separator");
    }

    public FilenameHelper_impl() {
        this.initMember();
    }

    public void setCompleteFilename(String _sFilename) {
        if (_sFilename.startsWith("file:///")) {
            _sFilename = FileHelper.getSystemPathFromFileURL(_sFilename);
        }
        _sFilename = utils.replaceAll13(_sFilename, "\\\\", "/");
        String sPath = this.checkPath(FileHelper.getPath(_sFilename));
        String sFilenameWithSuffix = this.checkFilename(FileHelper.getBasename(_sFilename));
        String sSuffix = this.splitSuffix(sFilenameWithSuffix);
        this.m_sPath = sPath;
        this.m_sFilename = FileHelper.getNameNoSuffix(sFilenameWithSuffix);
        this.m_sSuffix = sSuffix;
    }

    public FilenameHelper_impl(String _sPath, String _sName, String _sSuffix) {
        this.initMember();
        _sPath = utils.replaceAll13(_sPath, "\\\\", "/");
        String sPath = this.checkPath(_sPath);
        String sFilename = this.checkFilename(_sName);
        String sSuffix = this.checkSuffix(_sSuffix);
        this.m_sPath = sPath;
        this.m_sFilename = sFilename;
        this.m_sSuffix = sSuffix;
    }

    @Override
    public String getFileURL() {
        String sSystemPath = this.createAbsoluteFilename();
        String sFileURL = URLHelper.getFileURLFromSystemPath(sSystemPath);
        return sFileURL;
    }

    @Override
    public String getAbsoluteSystemFilename() {
        String sSystemFilename = this.createAbsoluteFilename();
        sSystemFilename = utils.replaceAll13(sSystemFilename, "/", this.fs);
        return sSystemFilename;
    }

    public String getName() {
        return this.m_sFilename;
    }

    public void setName(String _sName) {
        this.m_sFilename = _sName;
    }

    public void setPath(String _sName) {
        this.m_sPath = _sName;
    }

    public abstract String buildName();

    @Override
    public String getFilename() {
        return this.buildName() + "." + this.getSuffix();
    }

    @Override
    public String getSystemPath() {
        String sSystemPath = this.m_sPath;
        sSystemPath = utils.replaceAll13(sSystemPath, "/", this.fs);
        return sSystemPath;
    }

    public boolean isDirectory() {
        return FileHelper.isDir(this.getSystemPath());
    }

    public boolean exists() {
        return FileHelper.exists(this.createAbsoluteFilename());
    }

    @Override
    public String getSuffix() {
        return this.m_sSuffix;
    }

    String createAbsoluteFilename() {
        return this.m_sPath + this.fs + this.getFilename();
    }

    String checkPath(String _sPath) {
        String sPath = _sPath.endsWith("/") || _sPath.endsWith("\\") ? _sPath.substring(0, _sPath.length() - 1) : _sPath;
        return sPath;
    }

    String checkFilename(String _sFilename) {
        String sFilename = _sFilename.startsWith("/") || _sFilename.startsWith("\\") ? _sFilename.substring(1) : _sFilename;
        return sFilename;
    }

    String checkSuffix(String _sSuffix) {
        String sSuffix = _sSuffix.startsWith(".") ? _sSuffix.substring(1) : _sSuffix;
        return sSuffix;
    }

    String splitSuffix(String _sName) {
        String sSuffix = FileHelper.getSuffix(_sName);
        return this.checkSuffix(sSuffix);
    }

    public boolean equals(FilenameHelper_impl _aOtherFN) {
        String sPathOther;
        String sPath = this.createAbsoluteFilename();
        return sPath.equals(sPathOther = _aOtherFN.createAbsoluteFilename());
    }
}

