/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import com.sun.star.lang.XMultiServiceFactory;
import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DirectoryHelper;
import convwatch.EnhancedComplexTestCase;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.MSOfficePrint;
import convwatch.OfficePrint;
import helper.OfficeProvider;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;

public class DocumentConverter
extends EnhancedComplexTestCase {
    private String m_sInputPath = "";
    private String m_sReferencePath = "";
    private boolean m_bIncludeSubdirectories = true;

    @Override
    public String getTestObjectName() {
        return "DocumentConverter runner";
    }

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"convert"};
    }

    public void before() {
    }

    public void after() {
    }

    void initMember() {
        String sINPATH = (String)param.get("DOC_COMPARATOR_INPUT_PATH");
        boolean bQuit = false;
        String sError = "";
        if (sINPATH == null || sINPATH.length() == 0) {
            log.println("Please set input path (path to documents) DOC_COMPARATOR_INPUT_PATH=path.");
            bQuit = true;
        } else {
            log.println("found DOC_COMPARATOR_INPUT_PATH " + sINPATH);
            this.m_sInputPath = sINPATH;
        }
        String sREF = (String)param.get("DOC_COMPARATOR_REFERENCE_PATH");
        if (sREF == null || sREF.length() == 0) {
            log.println("Please set output path (path to a directory, where the references should stay) DOC_COMPARATOR_REFERENCE_PATH=path.");
            bQuit = true;
        } else {
            log.println("found DOC_COMPARATOR_REFERENCE_PATH " + sREF);
            this.m_sReferencePath = sREF;
        }
        if (bQuit) {
            this.assure("Must quit, Parameter problems.", false);
        }
        if (this.m_sInputPath.startsWith("file:") || this.m_sReferencePath.startsWith("file:")) {
            this.assure("We can't handle file: URL right, use system path instead.", false);
        }
    }

    @Override
    protected Object[] mustInstalledSoftware() {
        ArrayList aList = new ArrayList();
        return aList.toArray();
    }

    public void convert() {
        GlobalLogWriter.set(log);
        this.checkEnvironment(this.mustInstalledSoftware());
        GraphicalTestArguments aGTA = this.getGraphicalTestArguments();
        if (aGTA == null) {
            this.assure("Must quit", false);
        }
        this.initMember();
        File aInputPath = new File(this.m_sInputPath);
        if (aInputPath.isDirectory()) {
            String fs = System.getProperty("file.separator");
            String sRemovePath = aInputPath.getAbsolutePath();
            FileFilter aFileFilter = FileHelper.getFileFilter();
            Object[] aList = DirectoryHelper.traverse(this.m_sInputPath, aFileFilter, aGTA.includeSubDirectories());
            for (int i = 0; i < aList.length; ++i) {
                String sEntry = (String)aList[i];
                String sNewReferencePath = this.m_sReferencePath + fs + FileHelper.removeFirstDirectorysAndBasenameFrom(sEntry, this.m_sInputPath);
                log.println("- next file is: ------------------------------");
                log.println(sEntry);
                if (aGTA.checkIfUsableDocumentType(sEntry)) {
                    this.runGDC(sEntry, sNewReferencePath);
                }
                if (!aGTA.cancelRequest()) {
                    continue;
                }
                break;
            }
        } else if (aGTA.checkIfUsableDocumentType(this.m_sInputPath)) {
            this.runGDC(this.m_sInputPath, this.m_sReferencePath);
        }
    }

    void runGDC(String _sInputFile, String _sReferencePath) {
        GraphicalTestArguments aGTA;
        GraphicalTestArguments aGTA_local = this.getGraphicalTestArguments();
        OfficeProvider aProvider = null;
        if (aGTA_local.restartOffice()) {
            aProvider = new OfficeProvider();
            XMultiServiceFactory xMSF = (XMultiServiceFactory)aProvider.getManager(param);
            param.put("ServiceFactory", xMSF);
        }
        if ((aGTA = this.getGraphicalTestArguments()).getOfficeProgram().toLowerCase().equals("msoffice")) {
            GlobalLogWriter.get().println("USE MSOFFICE AS EXPORT FORMAT.");
            MSOfficePrint a = new MSOfficePrint();
            try {
                String sInputFileBasename = FileHelper.getBasename(_sInputFile);
                String fs = System.getProperty("file.separator");
                FileHelper.makeDirectories("", _sReferencePath);
                String sOutputFile = _sReferencePath;
                sOutputFile = sOutputFile.endsWith(fs) ? sOutputFile + sInputFileBasename : sOutputFile + fs + sInputFileBasename;
                a.storeToFileWithMSOffice(aGTA, _sInputFile, sOutputFile);
            }
            catch (ConvWatchCancelException e) {
                GlobalLogWriter.get().println(e.getMessage());
            }
            catch (IOException e) {
                GlobalLogWriter.get().println(e.getMessage());
            }
        } else {
            try {
                OfficePrint.convertDocument(_sInputFile, _sReferencePath, aGTA);
            }
            catch (ConvWatchCancelException e) {
                this.assure(e.getMessage(), false);
            }
            catch (ConvWatchException e) {
                this.assure(e.getMessage(), false);
            }
        }
        if (aGTA.restartOffice()) {
            aProvider.closeExistingOffice(param, true);
        }
    }
}

