/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.DBHelper;
import convwatch.GlobalLogWriter;
import convwatch.ShareConnection;
import helper.OSHelper;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DB
extends DBHelper {
    private static DB m_aDB = null;
    private String m_sSourceVersion;
    private String m_sDestinationVersion;
    private String m_sDocumentPool;
    private String m_sEnvironment;
    private String m_sDocID;
    private String m_sDBDistinct;

    private DB() {
    }

    private static synchronized DB getDB() {
        if (m_aDB == null) {
            m_aDB = new DB();
        }
        return m_aDB;
    }

    public static void init(String _sDBInfoString) {
        if (_sDBInfoString == null) {
            return;
        }
        DB.getDB().fillVariables(_sDBInfoString);
        DB.getDB().updatestate_status("source started");
    }

    public static void test() {
        DB.getDB().sql_test();
    }

    public static void source_start() {
        DB.getDB().updatestate_status("source started");
    }

    public static void source_finished() {
        DB.getDB().updatestate_status("source finished");
    }

    public static void source_failed(String _sMessage) {
        DB.getDB().updatestate_status("source failed");
        DB.getDB().updateinfo_status(_sMessage);
    }

    public static void destination_start() {
        DB.getDB().updatestate_status("destination started");
    }

    public static void destination_finished() {
        DB.getDB().updatestate_status("PASSED-OK");
    }

    public static void destination_failed(String _sStatus, String _sMessage) {
        DB.getDB().updatestate_status(_sStatus);
        DB.getDB().updateinfo_status(_sMessage);
    }

    public static void writeNumberOfPages(int _nPages) {
        DB.getDB().updatepagecount_documents(_nPages);
    }

    public static void writeErrorFile(String _sErrorFile) {
        DB.getDB().updateerrorfile_status(_sErrorFile);
    }

    public static void writeHTMLFile(String _sHTMLFile) {
        DB.getDB().updatehtmlfile_status(_sHTMLFile);
    }

    public static void writeToDB(String _sFilename, String _sBasename, String _sFileFormat, String _sBuildID, String _sSourceType, int _nResolution) {
        GlobalLogWriter.get().println("DB:   Filename:" + _sFilename);
        GlobalLogWriter.get().println("DB:   Basename:" + _sBasename);
        GlobalLogWriter.get().println("DB: FileFormat:" + _sFileFormat);
        GlobalLogWriter.get().println("DB:    BuildID:" + _sBuildID);
        GlobalLogWriter.get().println("DB: SourceType:" + _sSourceType);
        GlobalLogWriter.get().println("DB: Resolution:" + _nResolution);
    }

    private String getEnvironment() {
        if (OSHelper.isWindows()) {
            return "wntmsci";
        }
        if (OSHelper.isSolarisIntel()) {
            return "unxsoli";
        }
        if (OSHelper.isSolarisSparc()) {
            return "unxsols";
        }
        if (OSHelper.isLinuxIntel()) {
            return "unxlngi";
        }
        GlobalLogWriter.get().println("DB: Unknown environment.");
        GlobalLogWriter.get().println("DB: os.name := " + System.getProperty("os.name").toLowerCase());
        GlobalLogWriter.get().println("DB: os.arch := " + System.getProperty("os.arch"));
        return "";
    }

    private void fillVariables(String _sInfo) {
        this.fillDBConnection(_sInfo);
        this.m_sEnvironment = this.getEnvironment();
        StringTokenizer aTokenizer = new StringTokenizer(_sInfo, ",", false);
        while (aTokenizer.hasMoreTokens()) {
            String sPart = aTokenizer.nextToken();
            if (sPart.startsWith("p:")) {
                this.m_sSourceVersion = sPart.substring(2);
                GlobalLogWriter.get().println("DB: source version: " + this.m_sSourceVersion);
                continue;
            }
            if (sPart.startsWith("src:")) {
                this.m_sSourceVersion = sPart.substring(4);
                GlobalLogWriter.get().println("DB: source version: " + this.m_sSourceVersion);
                continue;
            }
            if (sPart.startsWith("c:")) {
                this.m_sDestinationVersion = sPart.substring(2);
                GlobalLogWriter.get().println("DB: destination version: " + this.m_sDestinationVersion);
                continue;
            }
            if (sPart.startsWith("dest:")) {
                this.m_sDestinationVersion = sPart.substring(5);
                GlobalLogWriter.get().println("DB: destination version: " + this.m_sDestinationVersion);
                continue;
            }
            if (sPart.startsWith("d:")) {
                this.m_sDocumentPool = sPart.substring(2);
                GlobalLogWriter.get().println("DB: documentpool version: " + this.m_sDocumentPool);
                continue;
            }
            if (sPart.startsWith("doc:")) {
                this.m_sDocumentPool = sPart.substring(4);
                GlobalLogWriter.get().println("DB: documentpool version: " + this.m_sDocumentPool);
                continue;
            }
            if (sPart.startsWith("id:")) {
                this.m_sDocID = sPart.substring(3);
                GlobalLogWriter.get().println("DB: docid: " + this.m_sDocID);
                continue;
            }
            if (!sPart.startsWith("distinct:")) continue;
            this.m_sDBDistinct = sPart.substring(9);
            GlobalLogWriter.get().println("DB: distinct: " + this.m_sDBDistinct);
        }
    }

    private void sql_test() {
        String sUUID = this.getDBDistinct();
        System.out.println("UUID: " + sUUID);
    }

    public ArrayList QuerySQL(Connection _aCon, String _sSQL) {
        Statement oStmt = null;
        Object oCon = null;
        ArrayList<String> aResultList = new ArrayList<String>();
        try {
            oStmt = _aCon.createStatement();
            ResultSet aResultSet = oStmt.executeQuery(_sSQL);
            ResultSetMetaData aResultSetMetaData = aResultSet.getMetaData();
            int nColumnCount = aResultSetMetaData.getColumnCount();
            while (aResultSet.next()) {
                StringBuffer aResult = new StringBuffer();
                try {
                    Object aObj = null;
                    aResult.append("sqlresult: ");
                    for (int i = 1; i <= nColumnCount; ++i) {
                        String sValue;
                        String sColumnName = aResultSetMetaData.getColumnName(i);
                        aResult.append(sColumnName).append("=");
                        int nSQLType = aResultSetMetaData.getColumnType(i);
                        switch (nSQLType) {
                            case 12: {
                                sValue = "'" + aResultSet.getString(i) + "'";
                                break;
                            }
                            case 4: {
                                int nValue = aResultSet.getInt(i);
                                sValue = String.valueOf(nValue);
                                break;
                            }
                            default: {
                                sValue = "UNSUPPORTED TYPE";
                            }
                        }
                        aResult.append(sValue).append(", ");
                    }
                    String sResult = aResult.toString();
                    aResultList.add(sResult);
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            String sError = e.getMessage();
            GlobalLogWriter.get().println("DB: Original SQL error: " + sError);
        }
        return aResultList;
    }

    private void updatestate_status(String _sStatus) {
        Connection aCon = new ShareConnection().getConnection();
        String sSet = "state=" + this.Quote(_sStatus);
        String sWhere = this.getWhereClause();
        if (sWhere.length() > 0) {
            this.SQLupdateValue(aCon, "status", sSet, sWhere);
        }
    }

    private void updateinfo_status(String _sInfo) {
        Connection aCon = new ShareConnection().getConnection();
        String sSet = "info=" + this.Quote(_sInfo);
        String sWhere = this.getWhereClause();
        this.SQLupdateValue(aCon, "status", sSet, sWhere);
    }

    private void updateerrorfile_status(String _sErrorFile) {
        Connection aCon = new ShareConnection().getConnection();
        String sErrorFile = _sErrorFile.replace('\\', '/');
        String sSet = "errorfile=" + this.Quote(sErrorFile);
        String sWhere = this.getWhereClause();
        this.SQLupdateValue(aCon, "status", sSet, sWhere);
    }

    private void updatehtmlfile_status(String _sHtmlFile) {
        Connection aCon = new ShareConnection().getConnection();
        String sHtmlFile = _sHtmlFile.replace('\\', '/');
        String sSet = "htmlfile=" + this.Quote(sHtmlFile);
        String sWhere = this.getWhereClause();
        this.SQLupdateValue(aCon, "status", sSet, sWhere);
    }

    private void updatepagecount_documents(int _nPageCount) {
        Connection aCon = new ShareConnection().getConnection();
        String sSet = "pagecount=" + _nPageCount;
        String sWhere = this.getWhereClause();
        this.SQLupdateValue(aCon, "documents", sSet, sWhere);
    }

    private String getWhereClause() {
        StringBuffer aWhereClause = new StringBuffer();
        boolean bAND = false;
        if (this.m_sDocID != null) {
            aWhereClause.append("docid").append("=").append(this.m_sDocID);
            bAND = true;
        }
        if (bAND) {
            aWhereClause.append(" AND ");
        }
        if (this.m_sDBDistinct != null) {
            aWhereClause.append("dbdistinct2").append("=").append(this.Quote(this.m_sDBDistinct));
        }
        return aWhereClause.toString();
    }

    private String getDBDistinct() {
        Connection aCon = new ShareConnection().getConnection();
        String sSQL = "SELECT uuid()";
        ArrayList aResultList = this.QuerySQL(aCon, sSQL);
        for (int i = 0; i < aResultList.size(); ++i) {
            String sResult = (String)aResultList.get(i);
            StringTokenizer aTokenizer = new StringTokenizer(sResult, ",", false);
            if (!aTokenizer.hasMoreTokens()) continue;
            String sToken = aTokenizer.nextToken();
            int nIndex = sToken.indexOf("uuid()=");
            int nIndexTuettel = sToken.indexOf("'", nIndex);
            int nIndexTuettel2 = sToken.lastIndexOf("'");
            String sUuid = sToken.substring(nIndexTuettel + 1, nIndexTuettel2);
            return sUuid;
        }
        return "0";
    }

    public static void insertinto_documentcompare(String _sSourceVersion, String _sSourceName, String _sSourceCreatorType, String _sDestinationVersion, String _sDestinationName, String _sDestinationCreatorType, String _sDocumentPoolDir, String _sDocumentPoolName, String _sMailAddress, String _sSpecial, String _sParentDistinct) {
        DB.getDB().insertinto_documentcompare_impl(_sSourceVersion, _sSourceName, _sSourceCreatorType, _sDestinationVersion, _sDestinationName, _sDestinationCreatorType, _sDocumentPoolDir, _sDocumentPoolName, _sMailAddress, _sSpecial, _sParentDistinct);
    }

    private void insertinto_documentcompare_impl(String _sSourceVersion, String _sSourceName, String _sSourceCreatorType, String _sDestinationVersion, String _sDestinationName, String _sDestinationCreatorType, String _sDocumentPoolDir, String _sDocumentPoolName, String _sMailAddress, String _sSpecial, String _sParentDistinct) {
        if (_sParentDistinct == null) {
            _sParentDistinct = "";
        }
        Connection aCon = new ShareConnection().getConnection();
        String sValueLine = "dbdistinct2, environment, sourceversion, sourcename, sourcecreatortype, destinationversion, destinationname, destinationcreatortype, documentpoolpath, documentpool, mailfeedback, state, special, parentdistinct, startdate";
        String sDocumentPoolDir = _sDocumentPoolDir.replace('\\', '/');
        StringBuffer aDataLine = new StringBuffer();
        aDataLine.append(this.Quote(this.getDBDistinct())).append(",").append(this.Quote(this.getEnvironment())).append(",").append(this.Quote(_sSourceVersion)).append(",").append(this.Quote(_sSourceName)).append(",").append(this.Quote(_sSourceCreatorType)).append(",").append(this.Quote(_sDestinationVersion)).append(",").append(this.Quote(_sDestinationName)).append(",").append(this.Quote(_sDestinationCreatorType)).append(",").append(this.Quote(sDocumentPoolDir)).append(",").append(this.Quote(_sDocumentPoolName)).append(",").append(this.Quote(_sMailAddress)).append(",").append(this.Quote("new")).append(",").append(this.Quote(_sSpecial)).append(",").append(this.Quote(_sParentDistinct)).append(",").append(this.Quote(DB.today()));
        this.SQLinsertValues(aCon, "documentcompare", sValueLine, aDataLine.toString());
    }
}

