/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ConvWatchCancelException;
import convwatch.ConvWatchException;
import convwatch.DB;
import convwatch.FileHelper;
import convwatch.GlobalLogWriter;
import convwatch.GraphicalTestArguments;
import convwatch.INIOutputter;
import convwatch.IniFile;
import convwatch.OfficePrint;
import convwatch.PRNCompare;
import convwatch.StatusHelper;
import convwatch.TriState;
import helper.URLHelper;
import java.io.File;

public class ConvWatch {
    String getBuildID_FromFile(String _sInfoFile) {
        String sBuildID = "";
        IniFile aIniFile = new IniFile(_sInfoFile);
        if (aIniFile.is()) {
            sBuildID = aIniFile.getValue("", "buildid");
        }
        return sBuildID;
    }

    StatusHelper[] createPostscriptStartCheck(GraphicalTestArguments _aGTA, String _sOutputPath, String _sAbsoluteInputFile, String _sAbsoluteReferenceFile) throws ConvWatchCancelException {
        if (!FileHelper.exists(_sAbsoluteInputFile)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Input file: " + _sAbsoluteInputFile + " does not exist.");
        }
        if (_sAbsoluteReferenceFile == null) {
            String sAbsoluteInputFileNoSuffix = FileHelper.getNameNoSuffix(_sAbsoluteInputFile);
            _sAbsoluteReferenceFile = sAbsoluteInputFileNoSuffix + ".prn";
        }
        String fs = System.getProperty("file.separator");
        File aAbsoluteReferenceFile = new File(_sAbsoluteReferenceFile);
        if (aAbsoluteReferenceFile.isDirectory()) {
            String sBasename = FileHelper.getBasename(_sAbsoluteInputFile);
            String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
            String sAbsoluteReferenceFileInfo = _sAbsoluteReferenceFile + fs + sNameNoSuffix + ".info";
            _sAbsoluteReferenceFile = _sAbsoluteReferenceFile + fs + sNameNoSuffix + ".prn";
            String sRefBuildID = "";
            if (FileHelper.exists(sAbsoluteReferenceFileInfo)) {
                sRefBuildID = this.getBuildID_FromFile(sAbsoluteReferenceFileInfo);
            }
            _aGTA.setRefBuildID(sRefBuildID);
        } else {
            String sName = FileHelper.getBasename(_sAbsoluteReferenceFile);
            int nIdx = sName.indexOf(46);
            if (nIdx == -1) {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference directory: '" + _sAbsoluteReferenceFile + "' does not exist.");
            }
        }
        boolean bAbsoluteReferenceFile = true;
        if (!FileHelper.exists(_sAbsoluteReferenceFile)) {
            if (_aGTA.createDefaultReference()) {
                GlobalLogWriter.get().println("Reference File doesn't exist, will create a default");
                bAbsoluteReferenceFile = false;
            } else {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference file: " + _sAbsoluteReferenceFile + " does not exist.");
            }
        }
        FileHelper.makeDirectories("", _sOutputPath);
        String sAbsoluteInputFileURL = URLHelper.getFileURLFromSystemPath(_sAbsoluteInputFile);
        String sInputFile = FileHelper.getBasename(_sAbsoluteInputFile);
        String sInputFileNoSuffix = FileHelper.getNameNoSuffix(sInputFile);
        String sAbsoluteOutputFile = _sOutputPath + fs + sInputFile;
        String sAbsoluteOutputFileURL = URLHelper.getFileURLFromSystemPath(sAbsoluteOutputFile);
        String sReferenceFile = FileHelper.getBasename(_sAbsoluteReferenceFile);
        String sReferenceFileNoSuffix = FileHelper.getNameNoSuffix(sReferenceFile);
        String sPostScriptFile = sReferenceFileNoSuffix + ".ps";
        String sAbsolutePrintFile = _sOutputPath + fs + sPostScriptFile;
        String sAbsolutePrintFileURL = URLHelper.getFileURLFromSystemPath(sAbsolutePrintFile);
        OfficePrint.printToFile(_aGTA, sAbsoluteInputFileURL, sAbsoluteOutputFileURL, sAbsolutePrintFileURL);
        if (!FileHelper.exists(sAbsolutePrintFile)) {
            throw new ConvWatchCancelException("createPostscriptStartCheck: Printed file " + sAbsolutePrintFile + " does not exist.");
        }
        if (!bAbsoluteReferenceFile) {
            String sDestinationFile = sAbsolutePrintFile;
            String sSourceFile = _sAbsoluteReferenceFile;
            FileHelper.copy(sDestinationFile, sSourceFile);
            if (!FileHelper.exists(_sAbsoluteReferenceFile)) {
                throw new ConvWatchCancelException("createPostscriptStartCheck: Given reference file: " + _sAbsoluteReferenceFile + " does not exist, after try to copy.");
            }
        }
        PRNCompare a = new PRNCompare();
        String sInputPath = FileHelper.getPath(_sAbsoluteInputFile);
        String sReferencePath = FileHelper.getPath(_sAbsoluteReferenceFile);
        a.setInputPath(sInputPath);
        a.setReferencePath(sReferencePath);
        a.setOutputPath(_sOutputPath);
        a.setReferenceFile(sReferenceFile);
        a.setPostScriptFile(sPostScriptFile);
        if (_aGTA.printAllPages()) {
            a.setMaxPages(9999);
        } else {
            if (_aGTA.getMaxPages() > 0) {
                a.setMaxPages(_aGTA.getMaxPages());
            }
            if (_aGTA.getOnlyPages().length() != 0) {
                a.setMaxPages(9999);
            }
        }
        a.setResolutionInDPI(_aGTA.getResolutionInDPI());
        a.setBorderMove(_aGTA.getBorderMove());
        a.setDocumentType(_aGTA.getDocumentType());
        StatusHelper[] aList = a.compare();
        _aGTA.setBorderMove(a.getBorderMove());
        return aList;
    }

    static boolean createINIStatus(StatusHelper[] aList, String _sFilenamePrefix, String _sOutputPath, String _sAbsoluteInputFile, String _sBuildID, String _sRefBuildID) {
        String fs = System.getProperty("file.separator");
        String sBasename = FileHelper.getBasename(_sAbsoluteInputFile);
        String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String sINIFile = _sFilenamePrefix + sNameNoSuffix + ".ini";
        INIOutputter INIoutput = INIOutputter.create(_sOutputPath, sINIFile, "", "");
        INIoutput.createHeader();
        INIoutput.writeSection("global");
        INIoutput.writeValue("pages", String.valueOf(aList.length));
        INIoutput.writeValue("buildid", _sBuildID);
        INIoutput.writeValue("refbuildid", _sRefBuildID);
        INIoutput.writeValue("diffdiff", "no");
        INIoutput.writeValue("basename", sBasename);
        boolean bResultIsOk = true;
        for (int i = 0; i < aList.length; ++i) {
            INIoutput.writeSection("page" + String.valueOf(i + 1));
            aList[i].printStatus();
            boolean bCurrentResult = true;
            int nCurrentDiffStatus = aList[i].nDiffStatus;
            if (!(nCurrentDiffStatus == 2 || nCurrentDiffStatus == 3 && aList[i].nPercent < 5 || nCurrentDiffStatus == 4 || nCurrentDiffStatus == 5 && aList[i].nPercent2 < 5)) {
                bCurrentResult = false;
            }
            INIoutput.checkLine(aList[i], bCurrentResult);
            bResultIsOk &= bCurrentResult;
        }
        INIoutput.close();
        return bResultIsOk;
    }

    static void createINIStatus_DiffDiff(StatusHelper[] aDiffDiffList, String _sFilenamePrefix, String _sOutputPath, String _sAbsoluteInputFile, String _sBuildID) {
        String fs = System.getProperty("file.separator");
        String sBasename = FileHelper.getBasename(_sAbsoluteInputFile);
        String sNameNoSuffix = FileHelper.getNameNoSuffix(sBasename);
        String sINIFile = _sFilenamePrefix + sNameNoSuffix + ".ini";
        INIOutputter INIoutput = INIOutputter.create(_sOutputPath, sINIFile, _sFilenamePrefix, "");
        INIoutput.createHeader();
        INIoutput.writeSection("global");
        INIoutput.writeValue("pages", String.valueOf(aDiffDiffList.length));
        INIoutput.writeValue("buildid", _sBuildID);
        INIoutput.writeValue("diffdiff", "yes");
        INIoutput.writeValue("basename", sBasename);
        for (int i = 0; i < aDiffDiffList.length; ++i) {
            INIoutput.writeSection("page" + String.valueOf(i + 1));
            boolean bCurrentResult = aDiffDiffList[i].nDiffStatus == 2;
            INIoutput.checkDiffDiffLine(aDiffDiffList[i], bCurrentResult);
        }
        INIoutput.close();
    }

    public static boolean check(GraphicalTestArguments _aGTA, String _sOutputPath, String _sAbsoluteInputFile, String _sAbsoluteReferenceFile) throws ConvWatchCancelException, ConvWatchException {
        ConvWatch a = new ConvWatch();
        StatusHelper[] aList = a.createPostscriptStartCheck(_aGTA, _sOutputPath, _sAbsoluteInputFile, _sAbsoluteReferenceFile);
        DB.writeNumberOfPages(aList.length);
        boolean bResultIsOk = ConvWatch.createINIStatus(aList, "", _sOutputPath, _sAbsoluteInputFile, _aGTA.getBuildID(), _aGTA.getRefBuildID());
        if (!bResultIsOk) {
            String sErrorMessage = "Graphical compare failed with file ";
            String sErrorFile = _sAbsoluteInputFile.replace('\\', '/');
            sErrorMessage = sErrorMessage + "'" + sErrorFile + "'";
            DB.writeErrorFile(sErrorFile);
            throw new ConvWatchException(sErrorMessage);
        }
        return bResultIsOk;
    }

    public static boolean checkDiffDiff(GraphicalTestArguments _aGTA, String _sOutputPath, String _sAbsoluteInputFile, String _sAbsoluteReferenceFile, String _sAbsoluteDiffPath) throws ConvWatchCancelException, ConvWatchException {
        ConvWatch a = new ConvWatch();
        _aGTA.setBorderMove(TriState.FALSE);
        StatusHelper[] aList = a.createPostscriptStartCheck(_aGTA, _sOutputPath, _sAbsoluteInputFile, _sAbsoluteReferenceFile);
        boolean bResultIsOk = ConvWatch.createINIStatus(aList, "", _sOutputPath, _sAbsoluteInputFile, _aGTA.getBuildID(), _aGTA.getRefBuildID());
        StatusHelper[] aDiffDiffList = new StatusHelper[aList.length];
        String fs = System.getProperty("file.separator");
        boolean bDiffIsOk = true;
        boolean bFoundAOldDiff = false;
        PRNCompare aCompare = new PRNCompare();
        for (int i = 0; i < aList.length; ++i) {
            String sOrigDiffName = aList[i].m_sDiffGfx;
            String sDiffBasename = FileHelper.getBasename(sOrigDiffName);
            String sNewDiffName = _sAbsoluteDiffPath + fs + sDiffBasename;
            if (!FileHelper.exists(sNewDiffName)) {
                GlobalLogWriter.get().println("checkDiffDiff: Old diff file: '" + sNewDiffName + "' does not exist.");
                continue;
            }
            String sSourcePath1 = FileHelper.getPath(sOrigDiffName);
            String sSourceFile1 = sDiffBasename;
            String sSourcePath2 = _sAbsoluteDiffPath;
            String sSourceFile2 = sDiffBasename;
            StatusHelper aCurrentStatus = aCompare.checkDiffDiff(_sOutputPath, sSourcePath1, sSourceFile1, sSourcePath2, sSourceFile2);
            boolean bCurrentResult = aCurrentStatus.nDiffStatus == 2;
            bDiffIsOk &= bCurrentResult;
            bFoundAOldDiff = true;
            aDiffDiffList[i] = aCurrentStatus;
        }
        ConvWatch.createINIStatus_DiffDiff(aDiffDiffList, "DiffDiff_", _sOutputPath, _sAbsoluteInputFile, _aGTA.getBuildID());
        if (!bFoundAOldDiff) {
            throw new ConvWatchCancelException("No old difference file found.");
        }
        if (!bDiffIsOk) {
            throw new ConvWatchException("Graphical difference compare failed with file '" + _sAbsoluteInputFile + "'");
        }
        return bDiffIsOk;
    }
}

