/*
 * Decompiled with CFR 0.152.
 */
package convwatch;

import convwatch.ImageHelper;
import convwatch.Rect;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class BorderRemover {
    ImageHelper m_aImage;

    BorderRemover() {
    }

    boolean compareColorWithTolerance(int _nColor1, int _nColor2, int _nTolerance) {
        double nTolerable;
        int red1 = _nColor1 >> 16 & 0xFF;
        int green1 = _nColor1 >> 8 & 0xFF;
        int blue1 = _nColor1 & 0xFF;
        int red2 = _nColor2 >> 16 & 0xFF;
        int green2 = _nColor2 >> 8 & 0xFF;
        int blue2 = _nColor2 & 0xFF;
        if (_nTolerance > 100) {
            _nTolerance = 100;
        }
        if ((nTolerable = (double)(_nTolerance * 256 / 100)) < 0.0) {
            nTolerable = 0.0;
        }
        return (double)Math.abs(red1 - red2) < nTolerable && (double)Math.abs(green1 - green2) < nTolerable && (double)Math.abs(blue1 - blue2) < nTolerable;
    }

    public boolean createNewImageWithoutBorder(String _sFilenameFrom, String _sFilenameTo) throws IOException {
        this.m_aImage = ImageHelper.createImageHelper(_sFilenameFrom);
        int nBorderColor = this.m_aImage.getPixel(0, 0);
        Rect aInnerRect = this.findBorder(this.m_aImage, nBorderColor);
        RenderedImage aImage = this.createImage(this.m_aImage, aInnerRect);
        File aWriteFile = new File(_sFilenameTo);
        ReflectiveOperationException ex = null;
        try {
            Class<?> imageIOClass = Class.forName("javax.imageio.ImageIO");
            Method getWriterMIMETypesMethod = imageIOClass.getDeclaredMethod("getWriterMIMETypes", new Class[0]);
            Object aObj = getWriterMIMETypesMethod.invoke(imageIOClass, new Object[0]);
            String[] types = (String[])aObj;
            Method writeMethod = imageIOClass.getDeclaredMethod("write", RenderedImage.class, String.class, File.class);
            writeMethod.invoke(imageIOClass, aImage, "image/jpeg", aWriteFile);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            ex = e;
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            ex = e;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            ex = e;
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
            ex = e;
        }
        if (ex != null) {
            String javaVersion = System.getProperty("java.version");
            throw new IOException("Cannot construct object with current Java version " + javaVersion + ": " + ex.getMessage());
        }
        return true;
    }

    Rect findBorder(ImageHelper _aImage, int _nBorderColor) {
        Rect aRect;
        int y;
        int w;
        int h = _aImage.getHeight();
        int nXMin = w = _aImage.getWidth();
        int nXMax = 0;
        int nYMin = h;
        int nYMax = 0;
        for (y = 0; y < h; ++y) {
            for (int x = 0; x < nXMin; ++x) {
                int nCurrentColor = _aImage.getPixel(x, y);
                if (this.compareColorWithTolerance(nCurrentColor, _nBorderColor, 10)) continue;
                nXMin = Math.min(nXMin, x);
                nYMin = Math.min(nYMin, y);
            }
        }
        for (y = 0; y < h; ++y) {
            for (int nx = w - 1; nx >= nXMax; --nx) {
                int ny = h - y - 1;
                int nCurrentColor = _aImage.getPixel(nx, ny);
                if (this.compareColorWithTolerance(nCurrentColor, _nBorderColor, 10)) continue;
                nXMax = Math.max(nXMax, nx);
                nYMax = Math.max(nYMax, ny);
            }
        }
        if (nXMin < nXMax && nYMin < nYMax) {
            int nw = nXMax - nXMin + 1;
            int nh = nYMax - nYMin + 1;
            aRect = new Rect(nXMin, nYMin, nw, nh);
        } else {
            aRect = new Rect(0, 0, 1, 1);
        }
        return aRect;
    }

    RenderedImage createImage(ImageHelper _aImage, Rect _aRect) throws IllegalArgumentException {
        int w = _aRect.getWidth();
        int h = _aRect.getHeight();
        if (w <= 0 || h <= 0) {
            throw new IllegalArgumentException("width or height are too small or negative.");
        }
        BufferedImage aBI = new BufferedImage(w, h, 1);
        int nXOffset = _aRect.getX();
        int nYOffset = _aRect.getY();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                aBI.setRGB(x, y, _aImage.getPixel(x + nXOffset, y + nYOffset));
            }
        }
        return aBI;
    }
}

