/*
 * Decompiled with CFR 0.152.
 */
package complexlib;

import java.lang.reflect.Method;
import java.util.Vector;

public class ShowTargets {
    public static void main(String[] args) {
        int i;
        Vector<String> targets = new Vector<String>();
        Vector<String> descs = new Vector<String>();
        targets.add("run");
        descs.add("runs all complex tests in this module");
        int maxTargetLength = 3;
        block2: for (i = 0; i < args.length; ++i) {
            String completePotentialClassName = args[i].replace('/', '.');
            if (completePotentialClassName.endsWith(".TestCase") || completePotentialClassName.endsWith(".TestSkeleton")) continue;
            Class<?> potentialTestClass = null;
            try {
                potentialTestClass = Class.forName(completePotentialClassName);
            }
            catch (ClassNotFoundException e) {
                continue;
            }
            for (Class<?> superClass = potentialTestClass.getSuperclass(); superClass != null; superClass = superClass.getSuperclass()) {
                if (!superClass.getName().equals("complexlib.ComplexTestCase")) continue;
                String bareClassName = completePotentialClassName.substring(completePotentialClassName.lastIndexOf(46) + 1);
                String target = "run_" + bareClassName;
                targets.add(target);
                descs.add(ShowTargets.getShortTestDescription(potentialTestClass));
                if (maxTargetLength >= target.length()) continue block2;
                maxTargetLength = target.length();
                continue block2;
            }
        }
        System.out.println("possible targets:");
        for (i = 0; i < targets.size(); ++i) {
            String target = (String)targets.get(i);
            System.out.print("  " + target);
            for (int s = maxTargetLength - target.length(); s > 0; --s) {
                System.out.print(" ");
            }
            System.out.println(" (" + (String)descs.get(i) + ")");
        }
    }

    private static boolean isInteractiveTest(Class testClass) {
        Method interactiveTestMethod = null;
        try {
            interactiveTestMethod = testClass.getMethod("isInteractiveTest", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (interactiveTestMethod != null) {
            try {
                Boolean result = (Boolean)interactiveTestMethod.invoke(null, new Object[0]);
                return result;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static String getShortTestDescription(Class _testClass) {
        Method getShortDescriptionMethod = null;
        try {
            getShortDescriptionMethod = _testClass.getMethod("getShortTestDescription", new Class[0]);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (getShortDescriptionMethod != null) {
            try {
                return (String)getShortDescriptionMethod.invoke(null, new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "no description provided by the test";
    }
}

