/*
 * Decompiled with CFR 0.152.
 */
package complexlib;

import complexlib.Assurance;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class MethodThread
extends Thread {
    private Method mTestMethod = null;
    private Object mInvokeClass = null;
    private PrintWriter mLog = null;
    private String mErrMessage = null;
    private boolean mExceptionHappened = false;
    private Object[] mParameter = null;

    public MethodThread(Method testMethod, Object invokeClass, PrintWriter log) {
        this.mTestMethod = testMethod;
        this.mInvokeClass = invokeClass;
        this.mLog = log;
    }

    public MethodThread(Method testMethod, Object invokeClass, Object[] parameter, PrintWriter log) {
        this.mTestMethod = testMethod;
        this.mInvokeClass = invokeClass;
        this.mParameter = parameter;
        this.mLog = log;
    }

    @Override
    public void run() {
        block4: {
            try {
                this.mTestMethod.invoke(this.mInvokeClass, this.mParameter);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace(this.mLog);
                this.mErrMessage = e.getMessage();
                this.mExceptionHappened = true;
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Assurance.AssureException) break block4;
                t.printStackTrace(this.mLog);
                this.mErrMessage = t.getMessage();
                if (this.mErrMessage == null) {
                    this.mErrMessage = t.toString();
                }
                this.mExceptionHappened = true;
            }
        }
    }

    public String getErrorMessage() {
        return this.mErrMessage;
    }

    public boolean hasErrorMessage() {
        return this.mExceptionHappened;
    }

    public void destroy() {
        try {
            this.interrupt();
        }
        catch (SecurityException e) {
            e.printStackTrace(this.mLog);
            this.mErrMessage = e.getMessage();
            this.mExceptionHappened = true;
        }
    }
}

