/*
 * Decompiled with CFR 0.152.
 */
package complex.unoapi;

import base.java_complex;
import com.sun.star.lang.XMultiServiceFactory;
import complexlib.ComplexTestCase;
import helper.BuildEnvTools;
import helper.ComplexDescGetter;
import helper.CwsDataExchangeImpl;
import helper.OfficeProvider;
import helper.ParameterNotFoundException;
import helper.ProcessHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import share.DescEntry;
import util.utils;

public class CheckModuleAPI
extends ComplexTestCase {
    private static String mSRC_ROOT = null;
    private static boolean mIsInitialized = false;
    private static final boolean mContinue = true;
    private static boolean mDebug = false;
    private static BuildEnvTools bet = null;

    public void before() {
        if (!mIsInitialized) {
            mIsInitialized = true;
            try {
                bet = new BuildEnvTools(param, log);
            }
            catch (ParameterNotFoundException ex) {
                this.failed(ex.toString(), false);
            }
            mSRC_ROOT = bet.getSrcRoot();
            mDebug = param.getBool("DebugIsActive");
        }
    }

    public void checkModule(String module) {
        log.println(utils.getDateTime() + ": start testing module '" + module + "'");
        log.println(utils.getDateTime() + "start new Office instance...");
        OfficeProvider officeProvider = new OfficeProvider();
        log.println(utils.getDateTime() + "Receiving the ServiceManager of the Office ");
        XMultiServiceFactory msf = (XMultiServiceFactory)officeProvider.getManager(param);
        this.assure("couldnot get ServiceFarcotry", msf != null, true);
        param.put("ServiceFactory", msf);
        String sep = System.getProperty("file.separator");
        String sUnoapi = this.getModulePath(module);
        File fUnoapi = new File(sUnoapi);
        String sMakeFile = sUnoapi + sep + "makefile.mk";
        File fMakeFile = new File(sMakeFile);
        this.assure("ERROR: could not find makefile: '" + sMakeFile + "'", fMakeFile.exists(), true);
        String[] commands = this.getDmakeCommands(sUnoapi);
        ProcessHandler procHdl = bet.runCommandsInEnvironmentShell(commands, fUnoapi, 0);
        log.println("exit code of dmake: " + procHdl.getExitCode());
        String test = procHdl.getOutputText();
        test = test + procHdl.getErrorText();
        this.assure("module '" + module + "' failed", this.verifyOutput(test), true);
        log.println(utils.getDateTime() + " module '" + module + "': kill existing office...");
        boolean bNoOffice = param.getBool("NoOffice");
        if (!bNoOffice) {
            try {
                officeProvider.closeExistingOffice(param, true);
            }
            catch (UnsatisfiedLinkError exception) {
                log.println("Office seems not to be running");
            }
        }
    }

    private String getQaUnoApiPath(String srcRoot, String _sModul) {
        File aFile = new File(srcRoot);
        if (!aFile.exists()) {
            System.out.println("ERROR: srcRoot '" + srcRoot + "' does not exist.");
            return null;
        }
        String sModulePath = srcRoot;
        sModulePath = sModulePath + File.separator;
        File aModulePath = new File(sModulePath = sModulePath + _sModul);
        if (!(aModulePath.exists() || (aModulePath = new File(sModulePath + ".lnk")).exists() || (aModulePath = new File(sModulePath + ".link")).exists())) {
            return null;
        }
        sModulePath = aModulePath.getAbsolutePath();
        sModulePath = sModulePath + File.separator;
        sModulePath = sModulePath + "qa";
        sModulePath = sModulePath + File.separator;
        File aModulePathQaUnoApi = new File(sModulePath = sModulePath + "unoapi");
        if (aModulePathQaUnoApi.exists()) {
            return aModulePathQaUnoApi.getAbsolutePath();
        }
        return null;
    }

    private boolean doesQaUnoApiFolderExist(String srcRoot, String _sModul) {
        return this.getQaUnoApiPath(srcRoot, _sModul) != null;
    }

    private String[] getAllModuleCommand() {
        String[] names = this.getModulesFromSourceRoot();
        String[] checkModules = this.getCheckModuleCommand(names);
        return checkModules;
    }

    private String[] getCheckModuleCommand(String[] names) {
        String[] checkModules = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            checkModules[i] = names[i].indexOf(".") != -1 ? "checkModule(" + names[i].substring(0, names[i].indexOf(".")) + ")" : "checkModule(" + names[i] + ")";
        }
        return checkModules;
    }

    private String[] getDmakeCommands(String sUnoapi) {
        String[] cmdLines = null;
        String platform = (String)param.get("OperatingSystem");
        log.println("prepare command for platform " + platform);
        cmdLines = platform.equals("wntmsci") ? (param.getBool("Cygwin") ? new String[]{"cd `cygpath '" + sUnoapi.replaceAll("\\\\", "\\\\\\\\") + "'`", "dmake"} : new String[]{"cdd " + sUnoapi, "dmake"}) : new String[]{"cd " + sUnoapi, "dmake"};
        return cmdLines;
    }

    private String[] getCwsModuleCommand() {
        String version = (String)param.get("Version");
        String[] names = null;
        if (version.startsWith("cws_")) {
            try {
                String cws = version.substring(4, version.length());
                CwsDataExchangeImpl cde = new CwsDataExchangeImpl(cws, param, log);
                ArrayList addedModules = cde.getModules();
                ArrayList<String> moduleNames = new ArrayList<String>();
                for (String sModuleName : addedModules) {
                    if (!this.doesQaUnoApiFolderExist(mSRC_ROOT, sModuleName)) continue;
                    moduleNames.add(sModuleName);
                }
                names = moduleNames.toArray(new String[0]);
            }
            catch (ParameterNotFoundException ex) {
                this.failed(ex.toString(), false);
            }
        } else {
            names = this.getModulesFromSourceRoot();
        }
        String[] checkModules = this.getCheckModuleCommand(names);
        return checkModules;
    }

    private String[] getDefinedModuleCommand(String module) {
        String[] checkModules = null;
        if (module.indexOf(",") != -1) {
            String[] names = module.split(",");
            checkModules = new String[names.length];
            for (int i = 0; i < names.length; ++i) {
                String moduleName = names[i].trim();
                if (!this.doesQaUnoApiFolderExist(mSRC_ROOT, moduleName)) continue;
                checkModules[i] = "checkModule(" + moduleName + ")";
            }
        } else if (this.doesQaUnoApiFolderExist(mSRC_ROOT, module)) {
            checkModules = new String[]{"checkModule(" + module + ")"};
        }
        return checkModules;
    }

    private String getModulePath(String module) {
        String sUnoapi = this.getQaUnoApiPath(mSRC_ROOT, module);
        return sUnoapi;
    }

    private String getTranslatedNames(String module) {
        HashMap<String, String> aModuleHashMap = new HashMap<String, String>();
        aModuleHashMap.put("fwk", "framework");
        aModuleHashMap.put("fwl", "framework");
        aModuleHashMap.put("sch", "chart2");
        aModuleHashMap.put("sysmgr1", "configmgr");
        aModuleHashMap.put("cfgmag2", "configmgr");
        aModuleHashMap.put("lnn", "lingu");
        aModuleHashMap.put("lng", "linguistic");
        aModuleHashMap.put("sfx", "sfx2");
        aModuleHashMap.put("sm", "starmath");
        Set keys = aModuleHashMap.keySet();
        for (String key : keys) {
            String value;
            int count = (module = module.replaceAll(key, value = (String)aModuleHashMap.get(key))).split(value).length;
            if (count <= 2) continue;
            for (int i = 2; i < count; ++i) {
                module.replaceFirst("," + value, "");
            }
        }
        return module;
    }

    private boolean verifyOutput(String output) {
        log.println("verify output...");
        boolean ok = false;
        String[] outs = output.split("\n");
        for (int i = 0; i < outs.length; ++i) {
            String line = outs[i];
            if (!line.matches("[0-9]+? of [0-9]+? tests failed")) continue;
            log.println("mached line: " + line);
            if (line.matches("0 of [0-9]+? tests failed")) {
                ok = true;
                log.println("Module passed OK");
                continue;
            }
            log.println("Module passed FAILED");
        }
        if (!ok) {
            log.println("ERROR: could not find '0 of [0-9]+? tests failed' in output");
        }
        return ok;
    }

    private String[] getModulesFromSourceRoot() {
        log.println("**** run module tests over all modules ****");
        log.println("search for qa/unoapi foldres in all modules based in ");
        log.println("'" + mSRC_ROOT + "'");
        ArrayList<String> moduleNames = new ArrayList<String>();
        File sourceRoot = new File(mSRC_ROOT);
        File[] sourceTree = sourceRoot.listFiles();
        for (int i = 0; i < sourceTree.length; ++i) {
            File moduleName = sourceTree[i];
            String sModuleName = moduleName.getName();
            if (!this.doesQaUnoApiFolderExist(mSRC_ROOT, sModuleName)) continue;
            moduleNames.add(sModuleName);
        }
        String[] names = moduleNames.toArray(new String[0]);
        return names;
    }

    public void module(String module) {
        String[] checkModules;
        ComplexDescGetter desc = new ComplexDescGetter();
        DescEntry entry = null;
        if ((module = module.trim()).equals("all")) {
            checkModules = this.getAllModuleCommand();
        } else if (module.equals("auto")) {
            checkModules = this.getCwsModuleCommand();
        } else {
            module = this.getTranslatedNames(module);
            checkModules = this.getDefinedModuleCommand(module);
        }
        if (checkModules != null && checkModules.length > 0) {
            entry = desc.createTestDesc("complex.unoapi.CheckModuleAPI", "complex.unoapi.CheckModuleAPI", checkModules, log);
            java_complex complex = new java_complex();
            log.println("********** start test *************");
            boolean result = complex.executeTest(param, new DescEntry[]{entry});
            log.println("********** end test *************");
            this.assure("CheckModuleAPI.module(" + module + ") PASSED.FAILED", result);
        } else {
            log.println("No modules containing qa/unoapi folder found => OK");
            this.state = true;
        }
        this.setUnoApiCwsStatus(this.state);
    }

    private void setUnoApiCwsStatus(boolean status) {
        String version;
        if (!param.getBool("NoCwsAttach") && (version = (String)param.get("Version")).startsWith("cws_")) {
            try {
                String cws = version.substring(4, version.length());
                CwsDataExchangeImpl cde = new CwsDataExchangeImpl(cws, param, log);
                cde.setUnoApiCwsStatus(status);
            }
            catch (ParameterNotFoundException ex) {
                log.println("ERROR: could not wirte status to EIS database: " + ex.toString());
            }
        }
    }

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"module(all)"};
    }
}

