/*
 * Decompiled with CFR 0.152.
 */
package basicrunner;

import basicrunner.BasicException;
import basicrunner.BasicHandler;
import basicrunner.BasicHandlerProvider;
import com.sun.star.beans.PropertyValue;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import share.DescEntry;
import share.LogWriter;

public class BasicTestCase
extends TestCase {
    public PrintWriter oLog;
    protected String objName;
    protected String implName;
    static BasicHandler oBasicHandler = null;

    public BasicTestCase(DescEntry entry) {
        this.objName = entry.entryName;
        this.implName = entry.longName;
    }

    @Override
    protected void initialize(TestParameters tParam, PrintWriter pLog) {
        this.oLog = pLog;
        LogWriter log = (LogWriter)((Object)pLog);
        oBasicHandler = BasicHandlerProvider.getHandler(tParam, log);
        try {
            oBasicHandler.perform("setValue", "cBASPath = \"" + tParam.get("BASICRESPTH") + "/\"");
            oBasicHandler.perform("setValue", "cTestDocsDir = \"" + tParam.get("DOCPTH") + "/\"");
            oBasicHandler.perform("setValue", "CNCSTR = \"" + tParam.get("CNCSTR") + "\"");
            if (tParam.get("soapi.test.hidewindows") != null) {
                oBasicHandler.perform("setValue", "soapi_test_hidewindows = true");
            } else {
                oBasicHandler.perform("setValue", "soapi_test_hidewindows = false");
            }
            oBasicHandler.perform("setValue", "dbaseUrl = \"sdbc:dbase:" + tParam.get("dbase.url") + "\"");
            oBasicHandler.perform("setValue", "flatUrl = \"sdbc:flat:" + tParam.get("flat.url") + "\"");
            oBasicHandler.perform("setValue", "calcUrl = \"sdbc:calc:" + tParam.get("calc.url") + "\"");
            oBasicHandler.perform("setValue", "odbcUrl = \"sdbc:odbc:" + tParam.get("odbc.url") + "\"");
            oBasicHandler.perform("setValue", "jdbcUrl = \"jdbc:" + tParam.get("jdbc.url") + "\"");
            oBasicHandler.perform("setValue", "jdbcUser = \"" + tParam.get("jdbc.user") + "\"");
            oBasicHandler.perform("setValue", "jdbcPassword = \"" + tParam.get("jdbc.password") + "\"");
            oBasicHandler.perform("setValue", "adabasUrl = \"sdbc:adabas:" + tParam.get("adabas.url") + "\"");
            oBasicHandler.perform("setValue", "adabasUser = \"" + tParam.get("adabas.user") + "\"");
            oBasicHandler.perform("setValue", "adabasPassword = \"" + tParam.get("adabas.password") + "\"");
            oBasicHandler.perform("setValue", "adoUrl = \"sdbc:ado:" + tParam.get("ado.url") + "\"");
            oBasicHandler.perform("setValue", "mozabUrl = \"sdbc:address:" + tParam.get("mozab.url") + "\"");
        }
        catch (BasicException e) {
            log.println(e.info);
            throw new RuntimeException(e.info);
        }
    }

    @Override
    protected TestEnvironment createTestEnvironment(TestParameters tParam, PrintWriter log) {
        boolean bObjectWasCreated = false;
        try {
            oBasicHandler.perform("setValue", "cObjectImplementationName = \"" + this.implName + "\"");
            PropertyValue Res = oBasicHandler.perform("createObject", this.objName);
            bObjectWasCreated = (Boolean)Res.Value;
            if (!bObjectWasCreated) {
                log.println("Couldn't create object");
                throw new RuntimeException("Couldn't create object");
            }
        }
        catch (BasicException e) {
            log.println(e.info);
            bObjectWasCreated = false;
            throw new RuntimeException(e.info);
        }
        TestEnvironment tEnv = new TestEnvironment(new XInterface(){});
        tEnv.addObjRelation("objectCreated", new Boolean(bObjectWasCreated));
        tEnv.addObjRelation("BasicHandler", oBasicHandler);
        return tEnv;
    }

    protected void cleanupTestEnvironment(TestParameters tParam, TestEnvironment tEnv, LogWriter log) {
    }

    @Override
    public void cleanupTestCase(TestParameters tParam) {
        this.oLog.println("Cleaning up testcase");
        try {
            PropertyValue Res = oBasicHandler.perform("disposeObject", this.objName);
        }
        catch (BasicException e) {
            this.oLog.println(e.info);
            throw new RuntimeException(e.info);
        }
    }
}

