/*
 * Decompiled with CFR 0.152.
 */
package basicrunner;

import basicrunner.BasicException;
import basicrunner.BasicIfcTest;
import basicrunner.HandlerContainer;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.frame.XComponentLoader;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.DisposedException;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XChangesBatch;
import lib.TestParameters;
import share.LogWriter;
import util.DesktopTools;

public class BasicHandler
implements XServiceInfo,
XSingleServiceFactory {
    static final String serviceName = "com.sun.star.jsuite.basicrunner.BasicHandler";
    private static HandlerContainer container = null;
    private static LogWriter log;
    private static XComponent oHandlerDoc;
    private static XMultiServiceFactory xMSF;
    private static BasicIfcTest TestedInterface;
    private static boolean respFlag;
    private static int iBasicTimeout;

    public BasicHandler(TestParameters tParam) {
        if (tParam.get("soapi.test.basic.debugFile") != null) {
            iBasicTimeout = 0;
        }
        container = new HandlerContainer(this);
    }

    public void setTestedInterface(BasicIfcTest ifc, LogWriter log) {
        BasicHandler.log = log;
        TestedInterface = ifc;
    }

    synchronized void methodTested(String methodName, boolean bResult) {
        respFlag = true;
        TestedInterface.methodTested(methodName, bResult);
        this.notify();
    }

    public synchronized void Log(String info) {
        respFlag = true;
        log.println(info);
        this.notify();
    }

    public boolean isUptodate(XMultiServiceFactory xMSF) {
        return xMSF.equals(BasicHandler.xMSF);
    }

    public synchronized void Connect(String sBasicBridgeURL, TestParameters tParam, XMultiServiceFactory xMSF, LogWriter log) throws ConnectionSetupException {
        BasicHandler.log = log;
        try {
            BasicHandler.xMSF = xMSF;
            Object oInterface = xMSF.createInstance("com.sun.star.frame.Desktop");
            XDesktop oDesktop = UnoRuntime.queryInterface(XDesktop.class, oInterface);
            XComponentLoader oCLoader = UnoRuntime.queryInterface(XComponentLoader.class, (Object)oDesktop);
            PropertyValue[] DocArgs = new PropertyValue[1];
            PropertyValue DocArg = new PropertyValue();
            DocArg.Name = "MacroExecutionMode";
            DocArg.Value = new Short(4);
            DocArgs[0] = DocArg;
            Object[] ProvArgs = new PropertyValue[1];
            PropertyValue Arg = new PropertyValue();
            Arg.Name = "nodepath";
            Arg.Value = "/org.openoffice.Office.Common/Security";
            ProvArgs[0] = Arg;
            Object oProvider = xMSF.createInstance("com.sun.star.configuration.ConfigurationProvider");
            XMultiServiceFactory oProviderMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, oProvider);
            Object oSecure = oProviderMSF.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", ProvArgs);
            XPropertySet oSecureProps = UnoRuntime.queryInterface(XPropertySet.class, oSecure);
            Object oScripting = oSecureProps.getPropertyValue("Scripting");
            XPropertySet oScriptingSettings = UnoRuntime.queryInterface(XPropertySet.class, oScripting);
            oScriptingSettings.setPropertyValue("Warning", Boolean.FALSE);
            oScriptingSettings.setPropertyValue("OfficeBasic", new Integer(2));
            XChangesBatch oSecureChange = UnoRuntime.queryInterface(XChangesBatch.class, oSecure);
            oSecureChange.commitChanges();
            String sFrameName = (String)tParam.get("soapi.test.basic.debugFile");
            if (sFrameName == null) {
                sFrameName = "BasicRunner";
            }
            oHandlerDoc = oCLoader.loadComponentFromURL(sBasicBridgeURL, sFrameName, 40, DocArgs);
            do {
                respFlag = false;
                this.wait(10000L);
            } while (respFlag && !container.hasByName("BASIC_Done"));
            if (!container.hasByName("BASIC_Done")) {
                throw new ConnectionSetupException("Connection timed out.");
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.toString());
            throw new ConnectionSetupException();
        }
        log.println("Java-BASIC connection established!");
    }

    public synchronized PropertyValue perform(String fName, Object params) throws BasicException {
        try {
            container.callBasicFunction(fName, params);
            do {
                respFlag = false;
                this.wait(iBasicTimeout);
            } while (respFlag && !container.hasByName("BASIC_Done"));
        }
        catch (InterruptedException e) {
            System.out.println("The operation " + fName + " was interrupted.");
        }
        catch (DisposedException de) {
            System.out.println("## Office is disposed");
        }
        if (!container.hasByName("BASIC_Done")) {
            System.out.println("Operation timed out.");
            throw new BasicException("Operation timed out.");
        }
        Object res = container.getByName("BASIC_Done");
        container.removeByName("BASIC_Done");
        if (!(res instanceof PropertyValue)) {
            if (res == null) {
                System.out.println("BasicBridge returns null");
                throw new BasicException("BasicBridge returns null");
            }
            System.out.println("BasicBridge returns wrong type: " + res.getClass());
            throw new BasicException("BasicBridge returns wrong type: " + res.getClass());
        }
        PropertyValue result = (PropertyValue)res;
        if (result.Value instanceof String && ((String)result.Value).startsWith("Exception")) {
            throw new BasicException((String)result.Value);
        }
        return result;
    }

    @Override
    public boolean supportsService(String name) {
        return serviceName.equals(name);
    }

    @Override
    public String[] getSupportedServiceNames() {
        return new String[]{serviceName};
    }

    @Override
    public String getImplementationName() {
        return this.getClass().getName();
    }

    @Override
    public Object createInstanceWithArguments(Object[] args) {
        return container;
    }

    @Override
    public Object createInstance() {
        return this.createInstanceWithArguments(null);
    }

    public synchronized void dispose() {
        try {
            if (oHandlerDoc != null) {
                DesktopTools.closeDoc(oHandlerDoc);
                this.wait(1000L);
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + e.toString());
        }
    }

    static {
        oHandlerDoc = null;
        xMSF = null;
        TestedInterface = null;
        respFlag = false;
        iBasicTimeout = 10000;
    }
}

