/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.TestBase;
import complexlib.ComplexTestCase;
import helper.AppProvider;
import helper.CfgParser;
import helper.ComplexDescGetter;
import lib.TestParameters;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import stats.OutProducerFactory;
import stats.Summarizer;
import util.DynamicClassLoader;

public class java_complex
implements TestBase {
    @Override
    public boolean executeTest(TestParameters param) {
        String complexIniFileName = (String)param.get("ComplexIni");
        if (complexIniFileName != null) {
            CfgParser ini = new CfgParser(complexIniFileName);
            ini.getIniParameters(param);
        }
        String testJob = (String)param.get("TestJob");
        ComplexDescGetter descGetter = new ComplexDescGetter();
        DescEntry[] entries = ((DescGetter)descGetter).getDescriptionFor(testJob, null, true);
        return this.executeTest(param, entries);
    }

    public boolean executeTest(TestParameters param, DescEntry[] entries) {
        String complexIniFileName = (String)param.get("ComplexIni");
        if (complexIniFileName != null) {
            CfgParser ini = new CfgParser(complexIniFileName);
            ini.getIniParameters(param);
        }
        DynamicClassLoader dcl = new DynamicClassLoader();
        ComplexTestCase testClass = null;
        boolean returnVal = true;
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i] == null) continue;
            String iniName = entries[i].longName;
            iniName = iniName.replace('.', '/');
            CfgParser ini = new CfgParser(iniName + ".props");
            ini.getIniParameters(param);
            LogWriter log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
            AppProvider office = null;
            if (!param.getBool("NoOffice")) {
                try {
                    office = (AppProvider)dcl.getInstance("helper.OfficeProvider");
                    Object msf = office.getManager(param);
                    if (msf == null) {
                        returnVal = false;
                        continue;
                    }
                    param.put("ServiceFactory", msf);
                }
                catch (IllegalArgumentException e) {
                    office = null;
                }
            }
            log.initialize(entries[i], param.getBool("LoggingIsActive"));
            entries[i].Logger = log;
            try {
                testClass = (ComplexTestCase)dcl.getInstance(entries[i].longName);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
            testClass.executeMethods(entries[i], param);
            Summarizer sum = new Summarizer();
            sum.summarizeUp(entries[i]);
            if (office != null) {
                office.closeExistingOffice(param, false);
            }
            LogWriter out = OutProducerFactory.createOutProducer(param);
            out.initialize(entries[i], true);
            out.summary(entries[i]);
            returnVal &= entries[i].State.endsWith("OK");
        }
        return returnVal;
    }
}

