/*
 * Decompiled with CFR 0.152.
 */
package base;

import base.TestBase;
import basicrunner.BasicIfcTest;
import basicrunner.BasicTestCase;
import com.sun.star.lang.XMultiServiceFactory;
import helper.APIDescGetter;
import helper.AppProvider;
import helper.OfficeProvider;
import helper.OfficeWatcher;
import helper.ProcessHandler;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;
import lib.TestCase;
import lib.TestEnvironment;
import lib.TestParameters;
import lib.TestResult;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import stats.OutProducerFactory;
import stats.Summarizer;
import util.DynamicClassLoader;

public class basic_fat
implements TestBase {
    public static boolean debug = false;

    @Override
    public boolean executeTest(TestParameters param) {
        ProcessHandler ph;
        APIDescGetter dg = new APIDescGetter();
        String job = (String)param.get("TestJob");
        OfficeProvider office = null;
        debug = param.getBool("DebugIsActive");
        System.out.print("Getting Descriptions for Job: " + job + " from ");
        DescEntry[] entries = ((DescGetter)dg).getDescriptionFor(job, (String)param.get("DescriptionPath"), debug);
        if (entries == null) {
            System.out.println("Couldn't get Description for Job");
            return false;
        }
        String ExclusionFile = (String)param.get("ExclusionList");
        Vector exclusions = null;
        if (ExclusionFile != null) {
            exclusions = this.getExclusionList(ExclusionFile, debug);
        }
        String conStr = (String)param.get("ConnectionString");
        System.out.println("");
        System.out.print("> Connecting the Office ");
        System.out.println("With " + conStr);
        for (int l = 0; l < entries.length; ++l) {
            LogWriter sumObj;
            Summarizer sumIt;
            DescEntry entry;
            block21: {
                ProcessHandler ph2;
                if (entries[l].hasErrorMsg) {
                    System.out.println(entries[l].ErrorMsg);
                    continue;
                }
                office = new OfficeProvider();
                XMultiServiceFactory msf = (XMultiServiceFactory)office.getManager(param);
                if (msf == null) {
                    return false;
                }
                param.put("ServiceFactory", msf);
                entry = entries[l];
                sumIt = new Summarizer();
                DynamicClassLoader dcl = new DynamicClassLoader();
                BasicTestCase tCase = null;
                tCase = new BasicTestCase(entry);
                if (tCase == null) {
                    Summarizer.summarizeDown(entry, entry.ErrorMsg);
                    LogWriter sumObj2 = OutProducerFactory.createOutProducer(param);
                    sumObj2.initialize(entry, true);
                    sumObj2.summary(entry);
                    continue;
                }
                System.out.println("Creating: " + tCase.getObjectName());
                LogWriter log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
                log.initialize(entry, true);
                entry.UserDefinedParams = param;
                tCase.setLogWriter((PrintWriter)((Object)log));
                try {
                    tCase.initializeTestCase(param);
                }
                catch (RuntimeException e) {
                    ProcessHandler ph3 = (ProcessHandler)param.get("AppProvider");
                    if (ph3 == null) continue;
                    OfficeWatcher ow = (OfficeWatcher)param.get("Watcher");
                    if (ow != null && ow.isAlive()) {
                        ow.finish = true;
                    }
                    ph3.kill();
                    this.shortWait(5000);
                    continue;
                }
                TestEnvironment tEnv = tCase.getTestEnvironment(param);
                if (tEnv == null) {
                    Summarizer.summarizeDown(entry, "Unable to create testcase");
                    sumObj = OutProducerFactory.createOutProducer(param);
                    sumObj.initialize(entry, true);
                    sumObj.summary(entry);
                    ph2 = (ProcessHandler)param.get("AppProvider");
                    if (ph2 == null) continue;
                    OfficeWatcher ow = (OfficeWatcher)param.get("Watcher");
                    if (ow != null && ow.isAlive()) {
                        ow.finish = true;
                    }
                    ph2.kill();
                    this.shortWait(5000);
                    continue;
                }
                System.out.println("created " + tCase.getObjectName());
                for (int j = 0; j < entry.SubEntryCount; ++j) {
                    if (!entry.SubEntries[j].isToTest) {
                        Summarizer.summarizeDown(entry.SubEntries[j], "not part of the job");
                        continue;
                    }
                    if (exclusions != null && exclusions.contains(entry.SubEntries[j].longName)) {
                        Summarizer.summarizeDown(entry.SubEntries[j], "known issue");
                        continue;
                    }
                    System.out.println("running: " + entry.SubEntries[j].entryName);
                    LogWriter ifclog = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
                    ifclog.initialize(entry.SubEntries[j], true);
                    entry.SubEntries[j].UserDefinedParams = param;
                    entry.SubEntries[j].Logger = ifclog;
                    if (tEnv == null || tEnv.isDisposed()) {
                        ProcessHandler ph4 = (ProcessHandler)param.get("AppProvider");
                        if (ph4 != null) {
                            office.closeExistingOffice(param, true);
                            this.shortWait(5000);
                        }
                        tEnv = this.getEnv(entry, param);
                    }
                    BasicIfcTest ifc = null;
                    TestResult res = null;
                    ifc = new BasicIfcTest(entry.SubEntries[j].longName);
                    res = ifc.run(entry.SubEntries[j], tEnv, param);
                    sumIt.summarizeUp(entry.SubEntries[j]);
                    LogWriter sumIfc = OutProducerFactory.createOutProducer(param);
                    sumIfc.initialize(entry.SubEntries[j], true);
                    sumIfc.summary(entry.SubEntries[j]);
                }
                try {
                    ((TestCase)tCase).cleanupTestCase(param);
                }
                catch (Exception e) {
                    log.println("TestCase already gone");
                    ph2 = (ProcessHandler)param.get("AppProvider");
                    if (ph2 == null) break block21;
                    office.closeExistingOffice(param, true);
                    this.shortWait(5000);
                }
            }
            sumIt.summarizeUp(entry);
            sumObj = OutProducerFactory.createOutProducer(param);
            sumObj.initialize(entry, true);
            sumObj.summary(entry);
        }
        if (entries.length > 1) {
            System.out.println();
            int counter = 0;
            System.out.println("Failures that appeared during scenario execution:");
            for (int i = 0; i < entries.length; ++i) {
                if (entries[i].State.endsWith("OK")) continue;
                System.out.println("\t " + entries[i].longName);
                ++counter;
            }
            System.out.println(counter + " of " + entries.length + " tests failed");
        }
        if ((ph = (ProcessHandler)param.get("AppProvider")) != null) {
            office.closeExistingOffice(param, true);
        }
        return true;
    }

    protected TestEnvironment getEnv(DescEntry entry, TestParameters param) {
        XMultiServiceFactory msf;
        DynamicClassLoader dcl = new DynamicClassLoader();
        String officeProviderName = (String)param.get("OfficeProvider");
        AppProvider office = (AppProvider)dcl.getInstance(officeProviderName);
        if (office == null) {
            System.out.println("ERROR: Wrong parameter 'OfficeProvider',  it cannot be instantiated.");
            System.exit(-1);
        }
        if ((msf = (XMultiServiceFactory)office.getManager(param)) == null) {
            return null;
        }
        param.put("ServiceFactory", msf);
        BasicTestCase tCase = new BasicTestCase(entry);
        System.out.println("Creating: " + tCase.getObjectName());
        LogWriter log = (LogWriter)dcl.getInstance((String)param.get("LogWriter"));
        log.initialize(entry, true);
        entry.UserDefinedParams = param;
        tCase.setLogWriter((PrintWriter)((Object)log));
        TestEnvironment tEnv = null;
        try {
            tCase.initializeTestCase(param);
            tEnv = tCase.getTestEnvironment(param);
        }
        catch (RuntimeException e) {
            System.out.println(e.getMessage());
            ProcessHandler ph = (ProcessHandler)param.get("AppProvider");
            if (ph != null) {
                office.closeExistingOffice(param, true);
                this.shortWait(5000);
            }
            entry.ErrorMsg = e.getMessage();
            entry.hasErrorMsg = true;
        }
        return tEnv;
    }

    protected void shortWait(int millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected Vector getExclusionList(String url, boolean debug) {
        Vector<String> entryList = new Vector<String>();
        String line = "#";
        BufferedReader exclusion = null;
        try {
            exclusion = new BufferedReader(new FileReader(url));
        }
        catch (FileNotFoundException fnfe) {
            if (debug) {
                System.out.println("Couldn't find file " + url);
            }
            return entryList;
        }
        while (line != null) {
            try {
                if (!line.startsWith("#")) {
                    entryList.add(line);
                }
                line = exclusion.readLine();
            }
            catch (IOException ioe) {
                if (debug) {
                    System.out.println("Exception while reading exclusion list");
                }
                return entryList;
            }
        }
        try {
            exclusion.close();
        }
        catch (IOException ioe) {
            if (debug) {
                System.out.println("Couldn't close file " + url);
            }
            return entryList;
        }
        return entryList;
    }
}

