/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.Property;
import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.beans.XPropertySetInfo;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XTypeProvider;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import java.lang.reflect.Method;

public class dbg {
    public static void printInterfaces(XInterface xTarget) {
        dbg.printInterfaces(xTarget, false);
    }

    public static void printInterfaces(XInterface xTarget, boolean extendedInfo) {
        Type[] types = dbg.getInterfaceTypes(xTarget);
        if (null != types) {
            int nLen = types.length;
            for (int i = 0; i < nLen; ++i) {
                System.out.println(types[i].getTypeName());
                if (!extendedInfo) continue;
                dbg.printInterfaceInfo(types[i]);
                System.out.println();
            }
        }
    }

    public static Type[] getInterfaceTypes(XInterface xTarget) {
        Type[] types = null;
        XTypeProvider xTypeProvider = UnoRuntime.queryInterface(XTypeProvider.class, (Object)xTarget);
        if (xTypeProvider != null) {
            types = xTypeProvider.getTypes();
        }
        return types;
    }

    public static boolean implementsInterface(XInterface xTarget, String ifcName) {
        Type[] types = dbg.getInterfaceTypes(xTarget);
        if (null != types) {
            int nLen = types.length;
            for (int i = 0; i < nLen; ++i) {
                if (!types[i].getTypeName().toLowerCase().endsWith(ifcName.toLowerCase())) continue;
                return true;
            }
        }
        return false;
    }

    public static void printInterfaceInfo(Type aType) {
        try {
            Class zClass = aType.getZClass();
            Method[] methods = zClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                System.out.println("\t" + methods[i].getReturnType().getName() + " " + methods[i].getName() + "()");
            }
        }
        catch (Exception ex) {
            System.out.println("Exception occured while printing InterfaceInfo");
            ex.printStackTrace();
        }
    }

    public static void printArray(String[] entries) {
        for (int i = 0; i < entries.length; ++i) {
            System.out.println(entries[i]);
        }
    }

    public static void printPropertyInfo(XPropertySet PS, String name) {
        dbg.printPropertyInfo(PS, name, new PrintWriter(System.out));
    }

    public static void printPropertyInfo(XPropertySet PS, String name, PrintWriter out) {
        try {
            XPropertySetInfo PSI = PS.getPropertySetInfo();
            Property[] props = PSI.getProperties();
            Property prop = PSI.getPropertyByName(name);
            out.println("Property name is " + prop.Name);
            out.println("Property handle is " + prop.Handle);
            out.println("Property type is " + prop.Type.getTypeName());
            out.println("Property current value is " + PS.getPropertyValue(name));
            out.println("Attributes :");
            short attr = prop.Attributes;
            if ((attr & 2) != 0) {
                out.println("\t-BOUND");
            }
            if ((attr & 4) != 0) {
                out.println("\t-CONSTRAINED");
            }
            if ((attr & 0x20) != 0) {
                out.println("\t-MAYBEAMBIGUOUS");
            }
            if ((attr & 0x40) != 0) {
                out.println("\t-MAYBEDEFAULT");
            }
            if ((attr & 1) != 0) {
                out.println("\t-MAYBEVOID");
            }
            if ((attr & 0x10) != 0) {
                out.println("\t-READONLY");
            }
            if ((attr & 0x80) != 0) {
                out.println("\t-REMOVEABLE");
            }
            if ((attr & 8) != 0) {
                out.println("\t-TRANSIENT");
            }
        }
        catch (com.sun.star.uno.Exception e) {
            out.println("Exception!!!!");
            e.printStackTrace(out);
        }
    }

    public static void printProperyValueSequenzePairs(PropertyValue[] ps) {
        for (int i = 0; i < ps.length; ++i) {
            dbg.printProperyValuePairs(ps[i], new PrintWriter(System.out));
        }
    }

    public static void printProperyValueSequenzePairs(PropertyValue[] ps, PrintWriter out) {
        for (int i = 0; i < ps.length; ++i) {
            dbg.printProperyValuePairs(ps[i], out);
        }
    }

    public static void printProperyValuePairs(PropertyValue ps) {
        dbg.printProperyValuePairs(ps, new PrintWriter(System.out));
    }

    public static void printProperyValuePairs(PropertyValue ps, PrintWriter out) {
        if (ps.Value instanceof String[]) {
            String[] values = (String[])ps.Value;
            String oneValue = "value is an empty String[]";
            if (values.length > 0) {
                oneValue = "['";
                for (int i = 0; i < values.length; ++i) {
                    oneValue = oneValue + values[i];
                    if (i + 1 >= values.length) continue;
                    oneValue = oneValue + "';'";
                }
                oneValue = oneValue + "']";
            }
            out.println("--------");
            out.println("   Name: '" + ps.Name + "' contains String[]:");
            out.println(oneValue);
            out.println("--------");
        } else if (ps.Value instanceof PropertyValue) {
            out.println("--------");
            out.println("   Name: '" + ps.Name + "' contains PropertyValue:");
            dbg.printProperyValuePairs((PropertyValue)ps.Value, out);
            out.println("--------");
        } else if (ps.Value instanceof PropertyValue[]) {
            out.println("--------");
            out.println("   Name: '" + ps.Name + "' contains PropertyValue[]:");
            dbg.printProperyValueSequenzePairs((PropertyValue[])ps.Value, out);
            out.println("--------");
        } else {
            out.println("Name: '" + ps.Name + "' Value: '" + ps.Value.toString() + "'");
        }
    }

    public static void printPropertiesNames(XPropertySet ps) {
        XPropertySetInfo psi = ps.getPropertySetInfo();
        Property[] props = psi.getProperties();
        for (int i = 0; i < props.length; ++i) {
            System.out.println(i + ".  " + props[i].Name);
        }
    }

    public static void getSuppServices(Object aObject) {
        XServiceInfo xSI = UnoRuntime.queryInterface(XServiceInfo.class, aObject);
        dbg.printArray(xSI.getSupportedServiceNames());
        String str = "Therein not Supported Service";
        boolean notSupportedServices = false;
        for (int i = 0; i < xSI.getSupportedServiceNames().length; ++i) {
            if (xSI.supportsService(xSI.getSupportedServiceNames()[i])) continue;
            notSupportedServices = true;
            str = str + "\n" + xSI.getSupportedServiceNames()[i];
        }
        if (notSupportedServices) {
            System.out.println(str);
        }
    }

    public static String getImplID(XInterface xTarget) {
        String str = "";
        XTypeProvider xTypeProvider = UnoRuntime.queryInterface(XTypeProvider.class, (Object)xTarget);
        if (xTypeProvider != null) {
            byte[] id = xTypeProvider.getImplementationId();
            str = "ImplementationID: ";
            for (int i = 0; i < id.length; ++i) {
                Byte b = new Byte(id[i]);
                str = str + b.intValue();
            }
        } else {
            str = "No Implementation ID available";
        }
        return str;
    }
}

