/*
 * Decompiled with CFR 0.152.
 */
package util.compare;

import convwatch.ConvWatchException;
import convwatch.DirectoryHelper;
import convwatch.FileHelper;
import convwatch.GraphicalDifferenceCheck;
import convwatch.GraphicalTestArguments;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import lib.TestParameters;
import util.compare.DocComparator;

class GraphicalComparator
implements DocComparator {
    GraphicalTestArguments m_aArguments;

    protected GraphicalComparator(TestParameters aParams) {
        this.m_aArguments = new GraphicalTestArguments(aParams);
    }

    static DocComparator getInstance(TestParameters aParams) {
        GraphicalComparator a = new GraphicalComparator(aParams);
        return a;
    }

    FileFilter getTrueIfPRNFile_FileFilter() {
        FileFilter aFileFilter = new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return pathname.getName().endsWith(".prn");
            }
        };
        return aFileFilter;
    }

    protected String createSpecialFile(String _sEntry, String _sInputPath, String _sReferencePath, String _sNewSuffix) {
        String fs = System.getProperty("file.separator");
        String sNewSubDir = "";
        if (_sInputPath.length() > 0) {
            sNewSubDir = FileHelper.removeFirstDirectorysAndBasenameFrom(_sEntry, _sInputPath);
        }
        String sNameNoSuffix = FileHelper.getNameNoSuffix(FileHelper.getBasename(_sEntry));
        String sNewReferencePath = sNewSubDir.length() > 0 ? _sReferencePath + fs + sNewSubDir : _sReferencePath;
        sNewReferencePath = sNewReferencePath + fs + sNameNoSuffix + _sNewSuffix;
        return sNewReferencePath;
    }

    boolean isReferenceOrDiffExistent(String _sNewSuffix) {
        boolean isExistent = false;
        String sInputPath = this.m_aArguments.getInputPath();
        if (FileHelper.isDir(sInputPath)) {
            Object[] aList = DirectoryHelper.traverse(sInputPath, FileHelper.getFileFilter(), this.m_aArguments.includeSubDirectories());
            for (int i = 0; i < aList.length; ++i) {
                String sEntry = (String)aList[i];
                String sNewReferencePath = this.createSpecialFile(sEntry, sInputPath, this.m_aArguments.getReferencePath(), _sNewSuffix);
                if (!FileHelper.exists(sNewReferencePath)) continue;
                isExistent = true;
            }
        } else {
            String sNewReferencePath = this.createSpecialFile(sInputPath, "", this.m_aArguments.getReferencePath(), _sNewSuffix);
            if (FileHelper.exists(sNewReferencePath)) {
                isExistent = true;
            }
        }
        return isExistent;
    }

    @Override
    public boolean isReferenceExistent() {
        return this.isReferenceOrDiffExistent(".prn");
    }

    @Override
    public void createReference() throws IOException {
        try {
            String referenceInputPath = null;
            if (this.m_aArguments.getReferenceInputPath() == null) {
                GraphicalDifferenceCheck.createReferences(this.m_aArguments.getInputPath(), this.m_aArguments.getReferencePath(), this.m_aArguments);
            } else {
                referenceInputPath = this.m_aArguments.getReferenceInputPath();
                GraphicalDifferenceCheck.createReferences(referenceInputPath, this.m_aArguments.getReferencePath(), this.m_aArguments);
            }
        }
        catch (ConvWatchException e) {
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean compare() throws IOException {
        try {
            if (FileHelper.isDebugEnabled()) {
                System.err.println("    Inputpath: '" + this.m_aArguments.getInputPath() + "'");
                System.err.println("   Outputpath: '" + this.m_aArguments.getOutputPath() + "'");
                System.err.println("Referencepath: '" + this.m_aArguments.getReferencePath() + "'");
            }
            return GraphicalDifferenceCheck.check(this.m_aArguments.getInputPath(), this.m_aArguments.getOutputPath(), this.m_aArguments.getReferencePath(), this.m_aArguments);
        }
        catch (ConvWatchException e) {
            if (FileHelper.isDebugEnabled()) {
                System.err.println("Exception caught");
                System.err.println("    Inputpath: '" + this.m_aArguments.getInputPath() + "'");
                System.err.println("   Outputpath: '" + this.m_aArguments.getOutputPath() + "'");
                System.err.println("Referencepath: '" + this.m_aArguments.getReferencePath() + "'");
            }
            throw new IOException(e.getMessage());
        }
    }

    @Override
    public boolean isDiffReferenceExistent() throws IOException {
        return this.isReferenceOrDiffExistent(".prn.diff0001.jpg");
    }

    @Override
    public void createDiffReference() throws IOException {
        this.compareDiff();
    }

    @Override
    public boolean compareDiff() throws IOException {
        try {
            return GraphicalDifferenceCheck.check(this.m_aArguments.getInputPath(), this.m_aArguments.getOutputPath(), this.m_aArguments.getReferencePath(), this.m_aArguments.getDiffPath(), this.m_aArguments);
        }
        catch (ConvWatchException e) {
            throw new IOException(e.getMessage());
        }
    }
}

