/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.beans.PropertyValue;
import com.sun.star.document.XExporter;
import com.sun.star.document.XFilter;
import com.sun.star.document.XImporter;
import com.sun.star.io.XActiveDataSource;
import com.sun.star.io.XInputStream;
import com.sun.star.io.XOutputStream;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.ucb.XSimpleFileAccess;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import com.sun.star.xml.sax.InputSource;
import com.sun.star.xml.sax.XAttributeList;
import com.sun.star.xml.sax.XDocumentHandler;
import com.sun.star.xml.sax.XLocator;
import com.sun.star.xml.sax.XParser;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public class XMLTools {
    public static Object[] getDocumentHandler(XMultiServiceFactory xMSF) {
        Object[] ret = new Object[1];
        try {
            XInterface Writer2 = (XInterface)xMSF.createInstance("com.sun.star.xml.sax.Writer");
            XInterface oPipe = (XInterface)xMSF.createInstance("com.sun.star.io.Pipe");
            XOutputStream xPipeOutput = UnoRuntime.queryInterface(XOutputStream.class, (Object)oPipe);
            XActiveDataSource xADS = UnoRuntime.queryInterface(XActiveDataSource.class, (Object)Writer2);
            xADS.setOutputStream(xPipeOutput);
            XDocumentHandler handler = UnoRuntime.queryInterface(XDocumentHandler.class, (Object)Writer2);
            Any arg = new Any(new Type(XDocumentHandler.class), (Object)handler);
            ret[0] = arg;
        }
        catch (com.sun.star.uno.Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static PropertyValue[] createMediaDescriptor(String[] propNames, Object[] values) {
        PropertyValue[] props = new PropertyValue[propNames.length];
        for (int i = 0; i < props.length; ++i) {
            props[i] = new PropertyValue();
            props[i].Name = propNames[i];
            if (values == null || i >= values.length) continue;
            props[i].Value = values[i];
        }
        return props;
    }

    public static XDocumentHandler getFileXMLWriter(XMultiServiceFactory xMSF, String fileURL) throws com.sun.star.uno.Exception {
        XInterface oFacc = (XInterface)xMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        XSimpleFileAccess xFacc = UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)oFacc);
        XInterface oWriter = (XInterface)xMSF.createInstance("com.sun.star.xml.sax.Writer");
        XActiveDataSource xWriterDS = UnoRuntime.queryInterface(XActiveDataSource.class, (Object)oWriter);
        XDocumentHandler xDocHandWriter = UnoRuntime.queryInterface(XDocumentHandler.class, (Object)oWriter);
        if (xFacc.exists(fileURL)) {
            xFacc.kill(fileURL);
        }
        XOutputStream fOut = xFacc.openFileWrite(fileURL);
        xWriterDS.setOutputStream(fOut);
        return xDocHandWriter;
    }

    public static void parseXMLFile(XMultiServiceFactory xMSF, String fileURL, XDocumentHandler handler) throws com.sun.star.uno.Exception {
        XInterface oFacc = (XInterface)xMSF.createInstance("com.sun.star.comp.ucb.SimpleFileAccess");
        XSimpleFileAccess xFacc = UnoRuntime.queryInterface(XSimpleFileAccess.class, (Object)oFacc);
        XInputStream oIn = xFacc.openFileRead(fileURL);
        XInterface oParser = (XInterface)xMSF.createInstance("com.sun.star.xml.sax.Parser");
        XParser xParser = UnoRuntime.queryInterface(XParser.class, (Object)oParser);
        xParser.setDocumentHandler(handler);
        InputSource inSrc = new InputSource();
        inSrc.aInputStream = oIn;
        xParser.parseStream(inSrc);
        oIn.closeInput();
    }

    public static void exportDocument(XMultiServiceFactory xMSF, XComponent xDoc, String docType, String exportType, String fileURL) throws com.sun.star.uno.Exception {
        XDocumentHandler xDocHandWriter = XMLTools.getFileXMLWriter(xMSF, fileURL);
        Any arg = new Any(new Type(XDocumentHandler.class), (Object)xDocHandWriter);
        XInterface oExp = (XInterface)xMSF.createInstanceWithArguments("com.sun.star.comp." + docType + ".XML" + exportType + "Exporter", new Object[]{arg});
        XExporter xExp = UnoRuntime.queryInterface(XExporter.class, (Object)oExp);
        xExp.setSourceDocument(xDoc);
        XFilter filter = UnoRuntime.queryInterface(XFilter.class, (Object)oExp);
        filter.filter(XMLTools.createMediaDescriptor(new String[]{"FilterName"}, new Object[]{"Custom filter"}));
    }

    public static void importDocument(XMultiServiceFactory xMSF, XComponent xDoc, String docType, String importType, String fileURL) throws com.sun.star.uno.Exception {
        XInterface oImp = (XInterface)xMSF.createInstance("com.sun.star.comp." + docType + ".XML" + importType + "Importer");
        XImporter xImp = UnoRuntime.queryInterface(XImporter.class, (Object)oImp);
        XDocumentHandler xDocHandImp = UnoRuntime.queryInterface(XDocumentHandler.class, (Object)oImp);
        xImp.setTargetDocument(xDoc);
        XMLTools.parseXMLFile(xMSF, fileURL, xDocHandImp);
    }

    public static class XMLChecker
    extends XMLWellFormChecker {
        protected HashSet tagSet = new HashSet();
        protected Vector tags = new Vector();
        protected Vector chars = new Vector();
        protected Vector tagStack = new Vector();
        protected Vector attrStack = new Vector();

        public XMLChecker(PrintWriter log, boolean writeXML) {
            super(log, writeXML);
        }

        public void addTag(Tag tag) {
            this.tags.add(new Tag[]{tag, null});
            this.tagSet.add(tag.name);
        }

        public void addTagEnclosed(Tag tag, Tag outerTag) {
            this.tags.add(new Tag[]{tag, outerTag});
            this.tagSet.add(tag.name);
        }

        public void addCharacters(String ch) {
            this.chars.add(new Object[]{ch.trim(), null});
        }

        public void addCharactersEnclosed(String ch, Tag outerTag) {
            this.chars.add(new Object[]{ch.trim(), outerTag});
        }

        @Override
        public void startElement(String name, XAttributeList attr) {
            try {
                super.startElement(name, attr);
                if (this.tagSet.contains(name)) {
                    for (int i = 0; i < this.tags.size(); ++i) {
                        Tag[] tag = (Tag[])this.tags.elementAt(i);
                        if (!tag[0].isMatchTo(name, attr)) continue;
                        if (tag[1] == null) {
                            this.tags.remove(i--);
                            continue;
                        }
                        boolean isInStack = false;
                        for (int j = 0; j < this.tagStack.size(); ++j) {
                            if (!tag[1].isMatchTo((String)this.tagStack.elementAt(j), (XAttributeList)this.attrStack.elementAt(j))) continue;
                            isInStack = true;
                            break;
                        }
                        if (!isInStack) continue;
                        this.tags.remove(i--);
                    }
                }
                this.tagStack.add(0, name);
                this.attrStack.add(0, new AttributeList(attr));
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
            }
        }

        @Override
        public void characters(String ch) {
            super.characters(ch);
            for (int i = 0; i < this.chars.size(); ++i) {
                Object[] chr = (Object[])this.chars.elementAt(i);
                if (!((String)chr[0]).equals(ch)) continue;
                if (chr[1] == null) {
                    this.chars.remove(i--);
                    continue;
                }
                boolean isInStack = false;
                for (int j = 0; j < this.tagStack.size(); ++j) {
                    if (!((Tag)chr[1]).isMatchTo((String)this.tagStack.elementAt(j), (XAttributeList)this.attrStack.elementAt(j))) continue;
                    isInStack = true;
                    break;
                }
                if (!isInStack) continue;
                this.chars.remove(i--);
            }
        }

        @Override
        public void endElement(String name) {
            try {
                super.endElement(name);
                if (this.tagStack.size() > 0) {
                    this.tagStack.remove(0);
                    this.attrStack.remove(0);
                }
            }
            catch (Exception e) {
                e.printStackTrace(this.log);
            }
        }

        public boolean check() {
            int i;
            if (this.tags.size() > 0) {
                this.log.println("!!! Error: Some tags were not found :");
                for (i = 0; i < this.tags.size(); ++i) {
                    Tag[] tag = (Tag[])this.tags.elementAt(i);
                    this.log.println("   Tag " + tag[0] + " was not found");
                    if (tag[1] == null) continue;
                    this.log.println("      inside tag " + tag[1]);
                }
            }
            if (this.chars.size() > 0) {
                this.log.println("!!! Error: Some character data blocks were not found :");
                for (i = 0; i < this.chars.size(); ++i) {
                    Object[] ch = (Object[])this.chars.elementAt(i);
                    this.log.println("   Character data \"" + ch[0] + "\" was not found ");
                    if (ch[1] == null) continue;
                    this.log.println("      inside tag " + ch[1]);
                }
            }
            if (!this.isWellFormed()) {
                this.log.println("!!! Some errors were found in XML structure");
            }
            boolean result = this.tags.size() == 0 && this.chars.size() == 0 && this.isWellFormed();
            this.reset();
            return result;
        }
    }

    public static class Tag {
        private String name = null;
        private String[][] attrList = new String[0][3];

        public Tag(String tagName) {
            this.name = tagName;
        }

        public Tag(String tagName, String attrName) {
            this.name = tagName;
            this.attrList = new String[1][3];
            this.attrList[0][0] = attrName;
        }

        public Tag(String tagName, String attrName, String attrValue) {
            this.name = tagName;
            this.attrList = new String[1][3];
            this.attrList[0][0] = attrName;
            this.attrList[0][1] = "CDATA";
            this.attrList[0][2] = attrValue;
        }

        public Tag(String tagName, String[] attrNames) {
            this.name = tagName;
            this.attrList = new String[attrNames.length][3];
            for (int i = 0; i < attrNames.length; ++i) {
                this.attrList[i][0] = attrNames[i];
            }
        }

        public Tag(String tagName, String[][] attrValues) {
            this.name = tagName;
            this.attrList = new String[attrValues.length][3];
            for (int i = 0; i < attrValues.length; ++i) {
                this.attrList[i][0] = attrValues[i][0];
                this.attrList[i][1] = "CDATA";
                this.attrList[i][2] = attrValues[i][1];
            }
        }

        public String toString() {
            String ret = "<" + this.name;
            for (int i = 0; i < this.attrList.length; ++i) {
                ret = ret + " " + this.attrList[i][0] + "=";
                ret = this.attrList[i][2] == null ? ret + "(not specified)" : ret + "\"" + this.attrList[i][2] + "\"";
            }
            ret = ret + ">";
            return ret;
        }

        protected boolean checkAttr(int attrListIdx, XAttributeList list) {
            short listLen = list.getLength();
            for (short j = 0; j < listLen; j = (short)(j + 1)) {
                if (!this.attrList[attrListIdx][0].equals(list.getNameByIndex(j))) continue;
                if (this.attrList[attrListIdx][2] == null) {
                    return true;
                }
                return this.attrList[attrListIdx][2].equals(list.getValueByIndex(j));
            }
            return false;
        }

        public boolean isMatchTo(String tagName, XAttributeList list) {
            if (!this.name.equals(tagName)) {
                return false;
            }
            boolean result = true;
            for (int i = 0; i < this.attrList.length; ++i) {
                result &= this.checkAttr(i, list);
            }
            return result;
        }
    }

    public static class XMLTagsChecker
    extends XMLWellFormChecker {
        protected Hashtable tags = new Hashtable();
        protected Hashtable chars = new Hashtable();
        protected boolean allOK = true;

        public XMLTagsChecker(PrintWriter log) {
            super(log);
        }

        public void addTag(String tag) {
            this.tags.put(tag, "");
        }

        public void addTagEnclosed(String tag, String outerTag) {
            this.tags.put(tag, outerTag);
        }

        public void addCharacters(String ch) {
            this.chars.put(ch, "");
        }

        public void addCharactersEnclosed(String ch, String outerTag) {
            this.chars.put(ch, outerTag);
        }

        @Override
        public void startElement(String name, XAttributeList attrs) {
            super.startElement(name, attrs);
            if (this.tags.containsKey(name)) {
                String outerTag = (String)this.tags.get(name);
                if (!outerTag.equals("")) {
                    boolean isInTag = false;
                    for (int i = 0; i < this.tagStack.size(); ++i) {
                        if (!outerTag.equals((String)this.tagStack.elementAt(i))) continue;
                        isInTag = true;
                        break;
                    }
                    if (!isInTag) {
                        this.printError("Required tag <" + name + "> found, but is not enclosed in tag <" + outerTag + ">");
                        this.allOK = false;
                    }
                }
                this.tags.remove(name);
            }
        }

        @Override
        public void characters(String ch) {
            super.characters(ch);
            if (this.chars.containsKey(ch)) {
                String outerTag = (String)this.chars.get(ch);
                if (!outerTag.equals("")) {
                    boolean isInTag = false;
                    for (int i = 0; i < this.tagStack.size(); ++i) {
                        if (!outerTag.equals((String)this.tagStack.elementAt(i))) continue;
                        isInTag = true;
                        break;
                    }
                    if (!isInTag) {
                        this.printError("Required characters '" + ch + "' found, but are not enclosed in tag <" + outerTag + ">");
                        this.allOK = false;
                    }
                }
                this.chars.remove(ch);
            }
        }

        public boolean checkTags() {
            this.allOK &= this.isWellFormed();
            Enumeration badTags = this.tags.keys();
            Enumeration badChars = this.chars.keys();
            if (badTags.hasMoreElements()) {
                this.allOK = false;
                this.log.println("Required tags were not found in export :");
                while (badTags.hasMoreElements()) {
                    this.log.println("   <" + (String)badTags.nextElement() + ">");
                }
            }
            if (badChars.hasMoreElements()) {
                this.allOK = false;
                this.log.println("Required characters were not found in export :");
                while (badChars.hasMoreElements()) {
                    this.log.println("   <" + (String)badChars.nextElement() + ">");
                }
            }
            this.reset();
            return this.allOK;
        }
    }

    public static class XMLWellFormChecker
    extends XMLWriter {
        protected boolean docStarted = false;
        protected boolean docEnded = false;
        protected Vector tagStack = new Vector();
        protected boolean wellFormed = true;
        protected boolean noOtherErrors = true;
        protected PrintWriter log = null;
        protected boolean printXMLData = false;

        public XMLWellFormChecker(PrintWriter log) {
            this.log = log;
        }

        public XMLWellFormChecker(PrintWriter log_, boolean printXMLData) {
            super(printXMLData ? log_ : null);
            this.printXMLData = printXMLData;
            this.log = log_;
        }

        public void reset() {
            this.docStarted = false;
            this.docEnded = false;
            this.tagStack = new Vector();
            this.wellFormed = true;
            this.noOtherErrors = true;
            Object log = null;
            this.printXMLData = false;
        }

        @Override
        public void startDocument() {
            super.startDocument();
            if (this.docStarted) {
                this.printError("Document is started twice.");
                this.wellFormed = false;
            }
            this.docStarted = true;
        }

        @Override
        public void endDocument() {
            super.endDocument();
            if (!this.docStarted) {
                this.wellFormed = false;
                this.printError("Document ended but not started.");
            }
            this.docEnded = true;
        }

        @Override
        public void startElement(String name, XAttributeList attr) {
            super.startElement(name, attr);
            if (attr == null) {
                this.printError("attribute list passed as parameter to startElement() method has null value for tag <" + name + ">");
                this.noOtherErrors = false;
            }
            this.tagStack.add(0, name);
        }

        @Override
        public void endElement(String name) {
            super.endElement(name);
            if (this.wellFormed) {
                if (this.tagStack.size() == 0) {
                    this.wellFormed = false;
                    this.printError("No tags to close (bad closing tag </" + name + ">)");
                } else {
                    String startTag = (String)this.tagStack.elementAt(0);
                    this.tagStack.remove(0);
                    if (!startTag.equals(name)) {
                        this.wellFormed = false;
                        this.printError("Bad closing tag: </" + name + ">; tag expected: </" + startTag + ">");
                    }
                }
            }
        }

        public boolean isWellFormed() {
            if (!this.docEnded) {
                this.printError("Document was not ended.");
                this.wellFormed = false;
            }
            return this.wellFormed && this.noOtherErrors;
        }

        public void printError(String msg) {
            this.log.println("!!! Error: " + msg);
            if (this.printXMLData) {
                return;
            }
            this.log.println("   Tag trace :");
            for (int i = 0; i < this.tagStack.size(); ++i) {
                String tag = (String)this.tagStack.elementAt(i);
                this.log.println("      <" + tag + ">");
            }
        }
    }

    public static class XMLWriter
    implements XDocumentHandler {
        private PrintWriter _log = null;
        private String align = "";

        public XMLWriter(PrintWriter log) {
            this._log = log;
        }

        public XMLWriter() {
        }

        @Override
        public void processingInstruction(String appl, String data) {
            if (this._log == null) {
                return;
            }
            this._log.println(this.align + "<?" + appl + " " + data + "?>");
        }

        @Override
        public void startDocument() {
            if (this._log == null) {
                return;
            }
            this._log.println("START DOCUMENT:");
        }

        @Override
        public void endDocument() {
            if (this._log == null) {
                return;
            }
            this._log.println("END DOCUMENT:");
        }

        @Override
        public void setDocumentLocator(XLocator loc) {
            if (this._log == null) {
                return;
            }
            this._log.println("DOCUMENT LOCATOR: ('" + loc.getPublicId() + "','" + loc.getSystemId() + "')");
        }

        @Override
        public void startElement(String name, XAttributeList attr) {
            if (this._log == null) {
                return;
            }
            this._log.print(this.align + "<" + name + " ");
            if (attr != null) {
                short attrLen = attr.getLength();
                for (short i = 0; i < attrLen; i = (short)(i + 1)) {
                    if (i != 0) {
                        this._log.print(this.align + "       ");
                    }
                    this._log.print(attr.getNameByIndex(i) + "[" + attr.getTypeByIndex(i) + "]=\"" + attr.getValueByIndex(i) + "\"");
                    if (i + 1 == attrLen) continue;
                    this._log.println();
                }
            }
            this._log.println(">");
            this.align = this.align + "   ";
        }

        @Override
        public void endElement(String name) {
            if (this._log == null) {
                return;
            }
            this.align = this.align.substring(3);
            this._log.println(this.align + "</" + name + ">");
        }

        @Override
        public void characters(String chars) {
            if (this._log == null) {
                return;
            }
            this._log.println(this.align + chars);
        }

        @Override
        public void ignorableWhitespace(String sp) {
            if (this._log == null) {
                return;
            }
            this._log.println(sp);
        }
    }

    public static class AttributeList
    implements XAttributeList {
        private Hashtable attrByName = new Hashtable();
        private Vector attributes = new Vector();
        private PrintWriter log = null;

        public AttributeList() {
        }

        public AttributeList(PrintWriter log) {
            this.log = log;
        }

        public AttributeList(XAttributeList list) {
            if (list == null) {
                return;
            }
            for (short i = 0; i < list.getLength(); i = (short)(i + 1)) {
                this.add(list.getNameByIndex(i), list.getTypeByIndex(i), list.getValueByIndex(i));
            }
        }

        public void add(String name, String type, String value) {
            Attribute attr = new Attribute();
            attr.Name = name;
            attr.Type = type;
            attr.Value = value;
            this.attributes.add(attr);
            this.attrByName.put(attr.Name, attr);
        }

        public void add(String name, String value) {
            this.add(name, "CDATA", value);
        }

        public void clear() {
            this.attrByName.clear();
            this.attributes.clear();
        }

        @Override
        public short getLength() {
            if (this.log != null) {
                this.log.println("getLength() called -> " + this.attributes.size());
            }
            return (short)this.attributes.size();
        }

        @Override
        public String getNameByIndex(short idx) {
            String name = ((Attribute)this.attributes.get((int)idx)).Name;
            if (this.log != null) {
                this.log.println("getNameByIndex(" + idx + ") called -> '" + name + "'");
            }
            return name;
        }

        @Override
        public String getTypeByIndex(short idx) {
            String type = ((Attribute)this.attributes.get((int)idx)).Type;
            if (this.log != null) {
                this.log.println("getTypeByIndex(" + idx + ") called -> '" + type + "'");
            }
            return type;
        }

        @Override
        public String getTypeByName(String name) {
            String type = ((Attribute)this.attrByName.get((Object)name)).Type;
            if (this.log != null) {
                this.log.println("getTypeByName('" + name + "') called -> '" + type + "'");
            }
            return type;
        }

        @Override
        public String getValueByIndex(short idx) {
            String value = ((Attribute)this.attributes.get((int)idx)).Value;
            if (this.log != null) {
                this.log.println("getValueByIndex(" + idx + ") called -> '" + value + "'");
            }
            return value;
        }

        @Override
        public String getValueByName(String name) {
            String value = ((Attribute)this.attrByName.get((Object)name)).Value;
            if (this.log != null) {
                this.log.println("getValueByName('" + name + "') called -> '" + value + "'");
            }
            return value;
        }

        private static class Attribute {
            public String Name;
            public String Type;
            public String Value;

            private Attribute() {
            }
        }
    }
}

