/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleAction;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.accessibility.XAccessibleEditableText;
import com.sun.star.accessibility.XAccessibleSelection;
import com.sun.star.accessibility.XAccessibleText;
import com.sun.star.accessibility.XAccessibleValue;
import com.sun.star.awt.Point;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.awt.XTopWindow;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.awt.AWTException;
import java.awt.Robot;
import java.io.PrintWriter;
import java.util.Vector;
import util.AccessibilityTools;
import util.utils;

public class UITools {
    private static final AccessibilityTools mAT = new AccessibilityTools();
    private final XAccessible mXRoot;
    private final XMultiServiceFactory mMSF;

    public UITools(XMultiServiceFactory msf, XModel xModel) {
        this.mMSF = msf;
        this.mXRoot = UITools.makeRoot(this.mMSF, xModel);
    }

    public UITools(XMultiServiceFactory msf, XTextDocument xTextDoc) {
        this.mMSF = msf;
        XModel xModel = UnoRuntime.queryInterface(XModel.class, (Object)xTextDoc);
        this.mXRoot = UITools.makeRoot(this.mMSF, xModel);
    }

    public UITools(XMultiServiceFactory msf, XWindow xWindow) {
        this.mMSF = msf;
        this.mXRoot = UITools.makeRoot(xWindow);
    }

    private static XAccessible makeRoot(XMultiServiceFactory msf, XModel aModel) {
        XWindow xWindow = AccessibilityTools.getCurrentWindow(msf, aModel);
        return AccessibilityTools.getAccessibleObject(xWindow);
    }

    private static String getString(XInterface xInt) {
        XAccessibleText oText = UnoRuntime.queryInterface(XAccessibleText.class, (Object)xInt);
        return oText.getText();
    }

    private static void setString(XInterface xInt, String cText) {
        XAccessibleEditableText oText = UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)xInt);
        oText.setText(cText);
    }

    private static Object getValue(XInterface xInt) {
        XAccessibleValue oValue = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)xInt);
        return oValue.getCurrentValue();
    }

    private static XAccessible makeRoot(XWindow xWindow) {
        return AccessibilityTools.getAccessibleObject(xWindow);
    }

    public XAccessible getRoot() {
        return this.mXRoot;
    }

    public void setTextEditFiledText(String textfiledName, String stringToSet) throws Exception {
        XAccessibleContext oTextField = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)60, textfiledName);
        UITools.setString(oTextField, stringToSet);
    }

    public XAccessibleContext getButton(String buttonName) throws Exception {
        return AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)44, buttonName);
    }

    public void clickButton(String buttonName) throws Exception {
        XAccessibleContext oButton = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)44, buttonName);
        if (oButton == null) {
            throw new Exception("Could not get button '" + buttonName + "'");
        }
        XAccessibleAction oAction = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oButton);
        try {
            oAction.doAccessibleAction(0);
        }
        catch (IndexOutOfBoundsException e) {
            throw new Exception("Could not do accessible action with '" + buttonName + "'" + e.toString());
        }
    }

    private boolean clickToggleButton(String buttonName, boolean toBePressed) {
        XAccessibleContext oButton = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)62, buttonName);
        if (oButton != null) {
            boolean isChecked = oButton.getAccessibleStateSet().contains((short)4);
            if (isChecked && !toBePressed || !isChecked && toBePressed) {
                XAccessibleAction oAction = UnoRuntime.queryInterface(XAccessibleAction.class, (Object)oButton);
                try {
                    oAction.doAccessibleAction(0);
                    return true;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Could not do accessible action with '" + buttonName + "'" + e.toString());
                    return false;
                }
            }
            return true;
        }
        System.out.println("Could not get button '" + buttonName + "'");
        return false;
    }

    public boolean deactivateToggleButton(String buttonName) {
        return this.clickToggleButton(buttonName, false);
    }

    public boolean activateToggleButton(String buttonName) {
        return this.clickToggleButton(buttonName, true);
    }

    public Integer getRadioButtonValue(String buttonName) throws Exception {
        try {
            XAccessibleContext xRB = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)46, buttonName);
            return (Integer)UITools.getValue(xRB);
        }
        catch (Exception e) {
            throw new Exception("Could not get value from RadioButton '" + buttonName + "' : " + e.toString());
        }
    }

    public XInterface getGraphic(String GraphicName) throws Exception {
        return AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)23, GraphicName);
    }

    public void setRadioButtonValue(String buttonName, int iValue) throws Exception {
        try {
            XAccessibleValue oValue;
            XAccessibleContext xRB = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)46, buttonName);
            if (xRB == null) {
                System.out.println("AccessibleObjectForRole couldn't be found for " + buttonName);
            }
            if ((oValue = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)xRB)) == null) {
                System.out.println("XAccessibleValue couldn't be queried for " + buttonName);
            }
            oValue.setCurrentValue(new Integer(iValue));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Could not set value to RadioButton '" + buttonName + "' : " + e.toString());
        }
    }

    public void selectListboxItem(String ListBoxName, int nChildIndex) throws Exception {
        try {
            XAccessibleContext xListBox = null;
            xListBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)7, ListBoxName);
            if (xListBox == null) {
                xListBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)40, ListBoxName);
            }
            XAccessible xListBoxAccess = UnoRuntime.queryInterface(XAccessible.class, (Object)xListBox);
            XAccessibleContext xList = AccessibilityTools.getAccessibleObjectForRole(xListBoxAccess, (short)32, true);
            XAccessibleSelection xListSelect = UnoRuntime.queryInterface(XAccessibleSelection.class, (Object)xList);
            xListSelect.selectAccessibleChild(nChildIndex);
        }
        catch (Exception e) {
            throw new Exception("Could not select item '" + nChildIndex + "' in listbox '" + ListBoxName + "' : " + e.toString());
        }
    }

    public Object[] getListBoxObjects(String ListBoxName) throws Exception {
        Vector<XInterface> Items = new Vector<XInterface>();
        try {
            XAccessibleContext xListBox = null;
            XAccessibleContext xList = null;
            xListBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)7, ListBoxName);
            if (xListBox == null) {
                xListBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)40, ListBoxName);
            }
            if (xListBox == null) {
                xList = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)65, ListBoxName);
            } else {
                XAccessible xListBoxAccess = UnoRuntime.queryInterface(XAccessible.class, (Object)xListBox);
                xList = AccessibilityTools.getAccessibleObjectForRole(xListBoxAccess, (short)32, true);
            }
            for (int i = 0; i < xList.getAccessibleChildCount(); ++i) {
                try {
                    XAccessible xChild = xList.getAccessibleChild(i);
                    XAccessibleContext xChildCont = xChild.getAccessibleContext();
                    XInterface xChildInterface = UnoRuntime.queryInterface(XInterface.class, (Object)xChildCont);
                    Items.add(xChildInterface);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new Exception("Could not get child form list of '" + ListBoxName + "' : " + e.toString());
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Could not get list of items from '" + ListBoxName + "' : " + e.toString());
        }
        Object[] ret = new XInterface[Items.size()];
        for (int i = 0; i < Items.size(); ++i) {
            ret[i] = Items.get(i);
        }
        return ret;
    }

    public String[] getListBoxItems(String ListBoxName) throws Exception {
        Vector<String> Items = new Vector<String>();
        try {
            XAccessibleContext xListBox = null;
            XAccessibleContext xList = null;
            xListBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)7, ListBoxName);
            if (xListBox == null) {
                xListBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)40, ListBoxName);
            }
            if (xListBox == null) {
                xList = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)65, ListBoxName);
            } else {
                XAccessible xListBoxAccess = UnoRuntime.queryInterface(XAccessible.class, (Object)xListBox);
                xList = AccessibilityTools.getAccessibleObjectForRole(xListBoxAccess, (short)32, true);
            }
            for (int i = 0; i < xList.getAccessibleChildCount(); ++i) {
                try {
                    XAccessible xChild = xList.getAccessibleChild(i);
                    XAccessibleContext xChildCont = xChild.getAccessibleContext();
                    XInterface xChildInterface = UnoRuntime.queryInterface(XInterface.class, (Object)xChildCont);
                    Items.add(UITools.getString(xChildInterface));
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new Exception("Could not get child form list of '" + ListBoxName + "' : " + e.toString());
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Could not get list of items from '" + ListBoxName + "' : " + e.toString());
        }
        String[] ret = new String[Items.size()];
        return Items.toArray(ret);
    }

    public void setNumericFieldValue(String NumericFieldName, String cValue) throws Exception {
        try {
            XAccessibleContext xNumericField = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)60, NumericFieldName);
            XAccessibleEditableText oValue = UnoRuntime.queryInterface(XAccessibleEditableText.class, (Object)xNumericField);
            UITools.setString(xNumericField, cValue);
        }
        catch (Exception e) {
            throw new Exception("Could not set value '" + cValue + "' into NumericField '" + NumericFieldName + "' : " + e.toString());
        }
    }

    public String getNumericFieldValue(String NumericFieldName) throws Exception {
        try {
            XAccessibleContext xNumericField = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)60, NumericFieldName);
            return UITools.getString(xNumericField);
        }
        catch (Exception e) {
            throw new Exception("Could get value from NumericField '" + NumericFieldName + "' : " + e.toString());
        }
    }

    private String removeCharactersFromCurrencyString(String stringVal) throws Exception {
        try {
            int numVal;
            int i;
            int beginIndex = 0;
            int endIndex = 0;
            boolean startFound = false;
            for (i = 0; i < stringVal.length(); ++i) {
                numVal = Character.getNumericValue(stringVal.charAt(i));
                if (numVal == -1) continue;
                beginIndex = i;
                break;
            }
            for (i = stringVal.length() - 1; i > 0; --i) {
                numVal = Character.getNumericValue(stringVal.charAt(i));
                if (numVal == -1) continue;
                endIndex = i + 1;
                break;
            }
            String currencyVal = stringVal.substring(beginIndex, endIndex);
            currencyVal = currencyVal.substring(0, currencyVal.length() - 3) + "#" + currencyVal.substring(currencyVal.length() - 2);
            currencyVal = utils.replaceAll13(currencyVal, ",", "");
            currencyVal = utils.replaceAll13(currencyVal, "\\.", "");
            currencyVal = utils.replaceAll13(currencyVal, "#", ".");
            return currencyVal;
        }
        catch (Exception e) {
            throw new Exception("Could get remove characters from currency string '" + stringVal + "' : " + e.toString());
        }
    }

    public Double getNumericFieldNumericValue(String NumericFieldName) throws Exception {
        try {
            Double retValue = null;
            String sValue = this.getNumericFieldValue(NumericFieldName);
            String sAmount = this.removeCharactersFromCurrencyString(sValue);
            retValue = Double.valueOf(sAmount);
            return retValue;
        }
        catch (Exception e) {
            throw new Exception("Could get numeric value from NumericField '" + NumericFieldName + "' : " + e.toString());
        }
    }

    public String getTextBoxText(String TextFieldName) throws Exception {
        String TextFieldText = null;
        try {
            XAccessibleContext xTextField = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)51, TextFieldName);
            XAccessible xTextFieldAccess = UnoRuntime.queryInterface(XAccessible.class, (Object)xTextField);
            XAccessibleContext xFrame = AccessibilityTools.getAccessibleObjectForRole(xTextFieldAccess, (short)61);
            for (int i = 0; i < xFrame.getAccessibleChildCount(); ++i) {
                try {
                    XAccessible xChild = xFrame.getAccessibleChild(i);
                    XAccessibleContext xChildCont = xChild.getAccessibleContext();
                    XInterface xChildInterface = UnoRuntime.queryInterface(XInterface.class, (Object)xChildCont);
                    TextFieldText = TextFieldText + UITools.getString(xChildInterface);
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    throw new Exception("Could not get child fom TextFrame of '" + TextFieldName + "' : " + e.toString());
                }
            }
            return TextFieldText;
        }
        catch (Exception e) {
            throw new Exception("Could not get content fom Textbox '" + TextFieldName + "' : " + e.toString());
        }
    }

    public void setCheckBoxValue(String CheckBoxName, Integer Value) throws Exception {
        try {
            XAccessibleContext xCheckBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)4, CheckBoxName);
            XAccessibleValue xCheckBoxValue = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)xCheckBox);
            xCheckBoxValue.setCurrentValue(Value);
        }
        catch (Exception e) {
            throw new Exception("Could not set value to CheckBox '" + CheckBoxName + "' : " + e.toString());
        }
    }

    public Integer getCheckBoxValue(String CheckBoxName) throws Exception {
        try {
            XAccessibleContext xCheckBox = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)4, CheckBoxName);
            XAccessibleValue xCheckBoxValue = UnoRuntime.queryInterface(XAccessibleValue.class, (Object)xCheckBox);
            return (Integer)xCheckBoxValue.getCurrentValue();
        }
        catch (Exception e) {
            throw new Exception("Could not set value to CheckBox '" + CheckBoxName + "' : " + e.toString());
        }
    }

    public String getMsgBoxText() throws Exception {
        String cMessage = null;
        try {
            XAccessibleContext xMessage = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, (short)30);
            XInterface xMessageInterface = UnoRuntime.queryInterface(XInterface.class, (Object)xMessage);
            cMessage = cMessage + UITools.getString(xMessageInterface);
            return cMessage;
        }
        catch (Exception e) {
            throw new Exception("Could not get message from Basic-MessageBox: " + e.toString());
        }
    }

    public XWindow getActiveTopWindow() throws Exception {
        XInterface xToolKit = null;
        try {
            xToolKit = (XInterface)this.mMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception e) {
            throw new Exception("Could not toolkit: " + e.toString());
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xToolKit);
        XTopWindow atw = tk.getActiveTopWindow();
        return UnoRuntime.queryInterface(XWindow.class, (Object)atw);
    }

    public XWindow getTopWindow(String WindowName, boolean debug) throws Exception {
        XInterface xToolKit = null;
        try {
            xToolKit = (XInterface)this.mMSF.createInstance("com.sun.star.awt.Toolkit");
        }
        catch (com.sun.star.uno.Exception e) {
            throw new Exception("Could not toolkit: " + e.toString());
        }
        XExtendedToolkit tk = UnoRuntime.queryInterface(XExtendedToolkit.class, (Object)xToolKit);
        int count = tk.getTopWindowCount();
        XTopWindow retWindow = null;
        if (debug) {
            System.out.println("getTopWindow ->");
        }
        for (int i = 0; i < count; ++i) {
            XTopWindow xTopWindow = tk.getTopWindow(i);
            XAccessible xAcc = AccessibilityTools.getAccessibleObject(xTopWindow);
            String accName = xAcc.getAccessibleContext().getAccessibleName();
            if (debug) {
                System.out.println("AccessibleName: " + accName);
            }
            if (!WindowName.equals(accName)) continue;
            if (debug) {
                System.out.println("-> found window with name '" + WindowName + "'");
            }
            retWindow = xTopWindow;
        }
        if (debug) {
            if (retWindow == null) {
                System.out.println("could not found window with name '" + WindowName + "'");
            }
            System.out.println("<- getTopWindow ");
        }
        return UnoRuntime.queryInterface(XWindow.class, retWindow);
    }

    public void clickMiddleOfAccessibleObject(short role, String name) {
        XAccessibleContext xAcc = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, role, name);
        XAccessibleComponent aComp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAcc);
        System.out.println(xAcc.getAccessibleRole() + "," + xAcc.getAccessibleName() + "(" + xAcc.getAccessibleDescription() + "):" + utils.getImplName(xAcc));
        if (aComp != null) {
            Point location = aComp.getLocationOnScreen();
            String bounds = "(" + aComp.getBounds().X + "," + aComp.getBounds().Y + ")" + " (" + aComp.getBounds().Width + "," + aComp.getBounds().Height + ")";
            System.out.println("The boundary Rectangle is " + bounds);
            try {
                Robot rob = new Robot();
                int x = aComp.getLocationOnScreen().X + aComp.getBounds().Width / 2;
                int y = aComp.getLocationOnScreen().Y + aComp.getBounds().Height / 2;
                System.out.println("try to click mouse button on x/y " + x + "/" + y);
                rob.mouseMove(x, y);
                rob.mousePress(16);
                rob.mouseRelease(16);
            }
            catch (AWTException e) {
                System.out.println("couldn't press mouse button");
            }
        }
    }

    public void doubleClickMiddleOfAccessibleObject(short role, String name) {
        XAccessibleContext xAcc = AccessibilityTools.getAccessibleObjectForRole(this.mXRoot, role, name);
        XAccessibleComponent aComp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xAcc);
        System.out.println(xAcc.getAccessibleRole() + "," + xAcc.getAccessibleName() + "(" + xAcc.getAccessibleDescription() + "):" + utils.getImplName(xAcc));
        if (aComp != null) {
            Point location = aComp.getLocationOnScreen();
            String bounds = "(" + aComp.getBounds().X + "," + aComp.getBounds().Y + ")" + " (" + aComp.getBounds().Width + "," + aComp.getBounds().Height + ")";
            System.out.println("The boundary Rectangle is " + bounds);
            try {
                Robot rob = new Robot();
                int x = aComp.getLocationOnScreen().X + aComp.getBounds().Width / 2;
                int y = aComp.getLocationOnScreen().Y + aComp.getBounds().Height / 2;
                System.out.println("try to double click mouse button on x/y " + x + "/" + y);
                rob.mouseMove(x, y);
                rob.mousePress(16);
                rob.mouseRelease(16);
                utils.shortWait(100);
                rob.mousePress(16);
                rob.mouseRelease(16);
            }
            catch (AWTException e) {
                System.out.println("couldn't press mouse button");
            }
        }
    }

    public void printAccessibleTree(PrintWriter log) {
        AccessibilityTools.printAccessibleTree(log, this.mXRoot);
    }

    public void printAccessibleTree(PrintWriter log, boolean debugIsActive) {
        AccessibilityTools.printAccessibleTree(log, this.mXRoot, debugIsActive);
    }
}

