/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.datatransfer.DataFlavor;
import com.sun.star.datatransfer.XTransferable;
import com.sun.star.datatransfer.clipboard.XClipboard;
import com.sun.star.frame.XDesktop;
import com.sun.star.frame.XFrame;
import com.sun.star.lang.XComponent;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import java.io.File;
import java.io.FileFilter;
import java.util.ArrayList;

public class SysUtils {
    static ArrayList files = new ArrayList();

    public static String getJavaPath() {
        String cp = System.getProperty("java.class.path");
        String jh = System.getProperty("java.home");
        String fs = System.getProperty("file.separator");
        jh = jh + fs + "bin" + fs;
        jh = jh + "java -classpath " + cp;
        return jh;
    }

    public static Object[] traverse(String afileDirectory) {
        File fileDirectory = new File(afileDirectory);
        if (!fileDirectory.isDirectory()) {
            throw new IllegalArgumentException("not a directory: " + fileDirectory.getName());
        }
        File[] entries = fileDirectory.listFiles(new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        });
        for (int i = 0; i < entries.length; ++i) {
            if (entries[i].isDirectory()) {
                SysUtils.traverse(entries[i].getAbsolutePath());
                continue;
            }
            try {
                String stringUrl = "file:///" + entries[i].getAbsolutePath().replace('\\', '/');
                files.add(stringUrl);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return files.toArray();
    }

    public static XComponent getActiveComponent(XMultiServiceFactory msf) {
        XComponent ac = null;
        try {
            Object desk = msf.createInstance("com.sun.star.frame.Desktop");
            XDesktop xDesk = UnoRuntime.queryInterface(XDesktop.class, desk);
            ac = xDesk.getCurrentComponent();
        }
        catch (com.sun.star.uno.Exception e) {
            System.out.println("Couldn't get active Component");
        }
        return ac;
    }

    public static XFrame getActiveFrame(XMultiServiceFactory msf) {
        try {
            Object desk = msf.createInstance("com.sun.star.frame.Desktop");
            XDesktop xDesk = UnoRuntime.queryInterface(XDesktop.class, desk);
            return xDesk.getCurrentFrame();
        }
        catch (com.sun.star.uno.Exception e) {
            System.out.println("Couldn't get active Component");
            return null;
        }
    }

    public static String getSysClipboardText(XMultiServiceFactory msf) throws com.sun.star.uno.Exception {
        XClipboard xCB = UnoRuntime.queryInterface(XClipboard.class, msf.createInstance("com.sun.star.datatransfer.clipboard.SystemClipboard"));
        XTransferable xTrans = xCB.getContents();
        DataFlavor[] dfs = xTrans.getTransferDataFlavors();
        for (int i = 0; i < dfs.length; ++i) {
            Object data;
            if (!dfs[i].MimeType.startsWith("text/plain") || (data = xTrans.getTransferData(dfs[i])) == null || !(data instanceof String)) continue;
            return (String)data;
        }
        return null;
    }
}

