/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.container.XIndexAccess;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.lang.XComponent;
import com.sun.star.sheet.XCellRangeData;
import com.sun.star.sheet.XSpreadsheet;
import com.sun.star.sheet.XSpreadsheetDocument;
import com.sun.star.sheet.XSpreadsheets;
import com.sun.star.table.XCellRange;
import com.sun.star.uno.AnyConverter;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;

public class CalcTools {
    public static void fillCalcSheetWithContent(XComponent xSheetDoc, int sheetNumber, int startCellX, int startCellY, int rangeLengthX, int rangeLengthY) throws Exception {
        try {
            XSpreadsheet xSheet = CalcTools.getSpreadSheetFromSheetDoc(xSheetDoc, sheetNumber);
            CalcTools.fillCalcSheetWithContent(xSheet, startCellX, startCellY, rangeLengthX, rangeLengthY);
        }
        catch (com.sun.star.uno.Exception e) {
            throw new com.sun.star.uno.Exception("Couldn't fill CalcSheet with content: " + e.toString());
        }
    }

    public static void fillCalcSheetWithContent(XSpreadsheet xSheet, int startCellX, int startCellY, int rangeLengthX, int rangeLengthY) throws Exception {
        try {
            Object[][] newData = new Object[rangeLengthY][rangeLengthX];
            for (int i = 0; i < rangeLengthY; ++i) {
                for (int j = 0; j < rangeLengthX; ++j) {
                    newData[i][j] = new Double(10 * i + j);
                }
            }
            XCellRange xRange = null;
            try {
                xRange = xSheet.getCellRangeByPosition(startCellX, startCellY, startCellX + rangeLengthX - 1, startCellY + rangeLengthY - 1);
            }
            catch (IndexOutOfBoundsException e) {
                throw new com.sun.star.uno.Exception("Couldn't get CellRange from sheett: " + e.toString());
            }
            XCellRangeData xRangeData = UnoRuntime.queryInterface(XCellRangeData.class, (Object)xRange);
            xRangeData.setDataArray(newData);
        }
        catch (com.sun.star.uno.Exception e) {
            throw new com.sun.star.uno.Exception("Couldn't fill CalcSheet with content: " + e.toString());
        }
    }

    public static XSpreadsheet getSpreadSheetFromSheetDoc(XComponent xSheetDoc, int sheetNumber) throws Exception {
        XSpreadsheet xSheet = null;
        try {
            XSpreadsheetDocument xSpreadsheetDoc = UnoRuntime.queryInterface(XSpreadsheetDocument.class, (Object)xSheetDoc);
            XSpreadsheets xSpreadsheets = xSpreadsheetDoc.getSheets();
            XIndexAccess xSheetsIndexArray = UnoRuntime.queryInterface(XIndexAccess.class, (Object)xSpreadsheets);
            try {
                xSheet = (XSpreadsheet)AnyConverter.toObject((Type)new Type(XSpreadsheet.class), (Object)xSheetsIndexArray.getByIndex(sheetNumber));
            }
            catch (IllegalArgumentException e) {
                throw new com.sun.star.uno.Exception("Couldn't get sheet '" + sheetNumber + "' : " + e.toString());
            }
            catch (IndexOutOfBoundsException e) {
                throw new com.sun.star.uno.Exception("Couldn't get sheet '" + sheetNumber + "' : " + e.toString());
            }
            catch (WrappedTargetException e) {
                throw new com.sun.star.uno.Exception("Couldn't get sheet '" + sheetNumber + "' : " + e.toString());
            }
        }
        catch (com.sun.star.uno.Exception e) {
            throw new com.sun.star.uno.Exception("Couldn't get sheet '" + sheetNumber + "' : " + e.toString());
        }
        return xSheet;
    }
}

