/*
 * Decompiled with CFR 0.152.
 */
package util;

import com.sun.star.accessibility.XAccessible;
import com.sun.star.accessibility.XAccessibleComponent;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XWindow;
import com.sun.star.frame.XController;
import com.sun.star.frame.XFrame;
import com.sun.star.frame.XModel;
import com.sun.star.lang.IndexOutOfBoundsException;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XInterface;
import java.io.PrintWriter;
import util.utils;

public class AccessibilityTools {
    public static XAccessibleContext SearchedContext = null;
    public static XAccessible SearchedAccessible = null;
    private static boolean debug = false;

    public AccessibilityTools() {
        SearchedContext = null;
    }

    public static XAccessible getAccessibleObject(XInterface xObject) {
        XAccessible xAccessible = null;
        try {
            xAccessible = UnoRuntime.queryInterface(XAccessible.class, (Object)xObject);
        }
        catch (Exception e) {
            System.out.println("caught exception while getting accessible object" + e);
            e.printStackTrace();
        }
        return xAccessible;
    }

    public static XWindow getCurrentContainerWindow(XMultiServiceFactory msf, XModel xModel) {
        return AccessibilityTools.getWindow(msf, xModel, true);
    }

    public static XWindow getCurrentWindow(XMultiServiceFactory msf, XModel xModel) {
        return AccessibilityTools.getWindow(msf, xModel, false);
    }

    private static XWindow getWindow(XMultiServiceFactory msf, XModel xModel, boolean containerWindow) {
        XWindow xWindow = null;
        try {
            XFrame xFrame;
            XController xController;
            if (xModel == null) {
                System.out.println("invalid model (==null)");
            }
            if ((xController = xModel.getCurrentController()) == null) {
                System.out.println("can't get controller from model");
            }
            if ((xFrame = xController.getFrame()) == null) {
                System.out.println("can't get frame from controller");
            }
            if ((xWindow = containerWindow ? xFrame.getContainerWindow() : xFrame.getComponentWindow()) == null) {
                System.out.println("can't get window from frame");
            }
        }
        catch (Exception e) {
            System.out.println("caught exception while getting current window" + e);
        }
        return xWindow;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xacc, short role) {
        SearchedContext = null;
        SearchedAccessible = null;
        AccessibilityTools.getAccessibleObjectForRole_(xacc, role);
        return SearchedContext;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xacc, short role, boolean ignoreShowing) {
        SearchedContext = null;
        SearchedAccessible = null;
        if (ignoreShowing) {
            AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing_(xacc, role);
        } else {
            AccessibilityTools.getAccessibleObjectForRole_(xacc, role);
        }
        return SearchedContext;
    }

    public static void getAccessibleObjectForRoleIgnoreShowing_(XAccessible xacc, short role) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        if (ac.getAccessibleRole() == role) {
            SearchedContext = ac;
            SearchedAccessible = xacc;
        } else {
            int k = ac.getAccessibleChildCount();
            if (ac.getAccessibleChildCount() > 100) {
                k = 50;
            }
            for (int i = 0; i < k; ++i) {
                try {
                    AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing_(ac.getAccessibleChild(i), role);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    public static void getAccessibleObjectForRole_(XAccessible xacc, short role) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        boolean isShowing = ac.getAccessibleStateSet().contains((short)25);
        if (ac.getAccessibleRole() == role && isShowing) {
            SearchedContext = ac;
            SearchedAccessible = xacc;
        } else {
            int k = ac.getAccessibleChildCount();
            if (ac.getAccessibleChildCount() > 100) {
                k = 50;
            }
            for (int i = 0; i < k; ++i) {
                try {
                    AccessibilityTools.getAccessibleObjectForRole_(ac.getAccessibleChild(i), role);
                    if (SearchedContext == null) continue;
                    return;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xacc, short role, String name) {
        return AccessibilityTools.getAccessibleObjectForRole(xacc, role, name, "");
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xacc, short role, String name, boolean ignoreShowing) {
        if (ignoreShowing) {
            return AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(xacc, role, name, "");
        }
        return AccessibilityTools.getAccessibleObjectForRole(xacc, role, name, "");
    }

    public static XAccessibleContext getAccessibleObjectForRoleIgnoreShowing(XAccessible xacc, short role, String name, String implName) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        if (ac.getAccessibleRole() == role && ac.getAccessibleName().indexOf(name) > -1 && utils.getImplName(ac).indexOf(implName) > -1) {
            SearchedAccessible = xacc;
            return ac;
        }
        int k = ac.getAccessibleChildCount();
        if (ac.getAccessibleChildCount() > 100) {
            k = 50;
        }
        for (int i = 0; i < k; ++i) {
            try {
                XAccessibleContext ac1 = AccessibilityTools.getAccessibleObjectForRoleIgnoreShowing(ac.getAccessibleChild(i), role, name, implName);
                if (ac1 == null) continue;
                return ac1;
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Couldn't get Child");
            }
        }
        return null;
    }

    public static XAccessibleContext getAccessibleObjectForRole(XAccessible xacc, short role, String name, String implName) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        boolean isShowing = ac.getAccessibleStateSet().contains((short)25);
        if ((role == 0 || ac.getAccessibleRole() == role) && ac.getAccessibleName().indexOf(name) > -1 && utils.getImplName(ac).indexOf(implName) > -1 && isShowing) {
            SearchedAccessible = xacc;
            return ac;
        }
        int k = ac.getAccessibleChildCount();
        if (ac.getAccessibleChildCount() > 100) {
            k = 50;
        }
        for (int i = 0; i < k; ++i) {
            try {
                XAccessibleContext ac1 = AccessibilityTools.getAccessibleObjectForRole(ac.getAccessibleChild(i), role, name, implName);
                if (ac1 == null) continue;
                return ac1;
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Couldn't get Child");
            }
        }
        return null;
    }

    public static XAccessibleContext getSheetCell(XAccessibleContext xSheetAcc, String cellName) {
        int cellIndex = 0;
        int column = 0;
        int charMem = 0;
        for (int n = 0; n < cellName.length(); ++n) {
            String cha = cellName.substring(n, n + 1);
            System.out.println("char: " + cha + " ");
            byte[] bytes = cha.getBytes();
            if (bytes[0] >= 65 && bytes[0] <= 90) {
                charMem = bytes[0] - 64;
                if (++column == 2) {
                    cellIndex += charMem * 26;
                }
                cellIndex += bytes[0] - 65;
                continue;
            }
            String sNumb = cellName.substring(n, cellName.length());
            new Integer(0);
            int iNumb = Integer.valueOf(sNumb);
            cellIndex += (iNumb - 1) * 256;
            System.out.println("numb:" + (iNumb - 1) * 256);
        }
        try {
            XAccessibleContext ac = xSheetAcc.getAccessibleChild(cellIndex).getAccessibleContext();
            System.out.println(ac.getAccessibleRole() + "," + ac.getAccessibleName() + "(" + ac.getAccessibleDescription() + "):" + utils.getImplName(ac));
            return ac;
        }
        catch (IndexOutOfBoundsException ex) {
            System.out.println("ERROR: could not get child at index " + cellIndex + "': " + ex.toString());
            return null;
        }
    }

    public static void printAccessibleTree(PrintWriter log, XAccessible xacc, boolean debugIsActive) {
        debug = debugIsActive;
        if (debug) {
            AccessibilityTools.printAccessibleTree(log, xacc, "");
        }
    }

    public static void printAccessibleTree(PrintWriter log, XAccessible xacc) {
        AccessibilityTools.printAccessibleTree(log, xacc, "");
    }

    protected static void printAccessibleTree(PrintWriter log, XAccessible xacc, String indent) {
        XAccessibleContext ac = xacc.getAccessibleContext();
        AccessibilityTools.logging(log, indent + ac.getAccessibleRole() + "," + ac.getAccessibleName() + "(" + ac.getAccessibleDescription() + "):" + utils.getImplName(ac));
        XAccessibleComponent aComp = UnoRuntime.queryInterface(XAccessibleComponent.class, (Object)xacc);
        if (aComp != null) {
            String bounds = "(" + aComp.getBounds().X + "," + aComp.getBounds().Y + ")" + " (" + aComp.getBounds().Width + "," + aComp.getBounds().Height + ")";
            bounds = "The boundary Rectangle is " + bounds;
            AccessibilityTools.logging(log, indent + indent + bounds);
        }
        boolean isShowing = ac.getAccessibleStateSet().contains((short)25);
        AccessibilityTools.logging(log, indent + indent + "StateType contains SHOWING: " + isShowing);
        int k = ac.getAccessibleChildCount();
        if (ac.getAccessibleChildCount() > 100) {
            k = 50;
        }
        for (int i = 0; i < k; ++i) {
            try {
                AccessibilityTools.printAccessibleTree(log, ac.getAccessibleChild(i), indent + "  ");
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                System.out.println("Couldn't get Child");
            }
        }
        if (ac.getAccessibleChildCount() > 100) {
            k = ac.getAccessibleChildCount();
            int st = ac.getAccessibleChildCount() - 50;
            AccessibilityTools.logging(log, indent + "  " + " ...... [skipped] ......");
            for (int i = st; i < k; ++i) {
                try {
                    AccessibilityTools.printAccessibleTree(log, ac.getAccessibleChild(i), indent + "  ");
                    continue;
                }
                catch (IndexOutOfBoundsException e) {
                    System.out.println("Couldn't get Child");
                }
            }
        }
    }

    public static String accessibleToString(Object AC) {
        XAccessibleContext xAC = UnoRuntime.queryInterface(XAccessibleContext.class, AC);
        if (xAC != null) {
            return "" + xAC.getAccessibleRole() + "," + xAC.getAccessibleName() + "(" + xAC.getAccessibleDescription() + "):";
        }
        XAccessible xA = UnoRuntime.queryInterface(XAccessible.class, AC);
        if (xA == null) {
            return "(Not supported)";
        }
        xAC = xA.getAccessibleContext();
        return "" + xAC.getAccessibleRole() + "," + xAC.getAccessibleName() + "(" + xAC.getAccessibleDescription() + ")";
    }

    public static boolean equals(XAccessible c1, XAccessible c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        return AccessibilityTools.equals(c1.getAccessibleContext(), c2.getAccessibleContext());
    }

    public static boolean equals(XAccessibleContext c1, XAccessibleContext c2) {
        if (c1 == null || c2 == null) {
            return c1 == c2;
        }
        if (c1.getAccessibleRole() != c2.getAccessibleRole()) {
            return false;
        }
        if (!c1.getAccessibleName().equals(c2.getAccessibleName())) {
            return false;
        }
        if (!c1.getAccessibleDescription().equals(c2.getAccessibleDescription())) {
            return false;
        }
        if (c1.getAccessibleChildCount() != c2.getAccessibleChildCount()) {
            return false;
        }
        return AccessibilityTools.equals(c1.getAccessibleParent(), c2.getAccessibleParent());
    }

    private static void logging(PrintWriter log, String content) {
        if (debug) {
            log.println(content);
        }
    }
}

