/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import share.DescEntry;
import share.LogWriter;
import share.Watcher;

public class SimpleLogWriter
extends PrintWriter
implements LogWriter {
    boolean m_bLogging = false;
    DescEntry entry = null;
    Watcher ow = null;

    public SimpleLogWriter() {
        super(System.out);
        GregorianCalendar cal = new GregorianCalendar();
        DecimalFormat dfmt = new DecimalFormat("00");
        super.println("LOG> Log started " + dfmt.format(cal.get(5)) + "." + dfmt.format(cal.get(2)) + "." + dfmt.format(cal.get(1)) + " - " + dfmt.format(cal.get(11)) + ":" + dfmt.format(cal.get(12)) + ":" + dfmt.format(cal.get(13)));
        super.flush();
    }

    @Override
    public boolean initialize(DescEntry _entry, boolean _bLogging) {
        this.m_bLogging = _bLogging;
        this.entry = _entry;
        return true;
    }

    @Override
    public void println(String msg) {
        if (this.ow == null && this.entry != null) {
            this.ow = (Watcher)this.entry.UserDefinedParams.get("Watcher");
            if (this.ow != null) {
                this.ow.ping();
            }
        } else if (this.ow != null) {
            this.ow.ping();
        } else {
            System.out.println(msg);
        }
        if (this.m_bLogging) {
            super.println("LOG> " + msg);
            super.flush();
        }
    }

    @Override
    public boolean summary(DescEntry entry) {
        return true;
    }

    @Override
    public Object getWatcher() {
        return this.ow;
    }

    @Override
    public void setWatcher(Object watcher) {
        if (watcher != null) {
            this.entry.UserDefinedParams.put("Watcher", (Watcher)watcher);
        }
    }
}

