/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public class SQLExecution {
    protected Connection mConnection = null;
    protected Statement mStatement = null;
    protected String mJdbcClass = null;
    protected String mDbURL = null;
    protected String mUser = null;
    protected String mPassword = null;
    protected boolean m_bConnectionOpen = false;
    protected boolean m_bDebug = false;

    public SQLExecution(String jdbcClass, String dbUrl, String user, String password) {
        this.mJdbcClass = jdbcClass;
        this.mUser = user;
        this.mPassword = password;
        this.mDbURL = dbUrl;
    }

    public SQLExecution(String jdbcClass, String dbUrl, String user, String password, boolean debug) {
        this.mJdbcClass = jdbcClass;
        this.mUser = user;
        this.mPassword = password;
        this.mDbURL = dbUrl;
        this.m_bDebug = debug;
    }

    public boolean openConnection() {
        if (this.m_bConnectionOpen) {
            return true;
        }
        try {
            Class.forName(this.mJdbcClass);
        }
        catch (ClassNotFoundException e) {
            System.err.println("Couldn't find jdbc driver : " + e.getMessage());
            return false;
        }
        try {
            this.mConnection = DriverManager.getConnection(this.mDbURL, this.mUser, this.mPassword);
            this.mStatement = this.mConnection.createStatement();
        }
        catch (SQLException e) {
            System.err.println("Couldn't establish a connection: " + e.getMessage());
            return false;
        }
        this.m_bConnectionOpen = true;
        return true;
    }

    public boolean closeConnection() {
        if (!this.m_bConnectionOpen) {
            return true;
        }
        try {
            this.mStatement.close();
            this.mConnection.close();
        }
        catch (SQLException e) {
            System.err.println("Couldn't close the connection: " + e.getMessage());
            return false;
        }
        this.m_bConnectionOpen = false;
        return true;
    }

    public boolean executeSQLCommand(String command, Hashtable sqlInput, Hashtable sqlOutput) throws IllegalArgumentException {
        return this.executeSQLCommand(command, sqlInput, sqlOutput, false);
    }

    public boolean executeSQLCommand(String command, Hashtable sqlInput, Hashtable sqlOutput, boolean mergeOutputIntoInput) throws IllegalArgumentException {
        if (sqlOutput == null) {
            sqlOutput = new Hashtable();
            mergeOutputIntoInput = true;
            if (sqlInput == null) {
                System.out.println("sqlInput and sqlOutput are null: cannot return the results of the sql command.");
                return false;
            }
        }
        Vector<String> sqlCommand = new Vector<String>();
        sqlCommand.add("");
        boolean update = false;
        StringTokenizer token = new StringTokenizer(command, " ");
        while (token.hasMoreTokens()) {
            String originalKey = token.nextToken();
            int index = originalKey.indexOf(36);
            if (index != -1) {
                String pre = "";
                pre = originalKey.substring(0, index);
                String key = originalKey.substring(index + 1);
                String post = "";
                while (key.endsWith(",") || key.endsWith("'") || key.endsWith(";") || key.endsWith(")") || key.endsWith("\"")) {
                    post = key.substring(key.length() - 1) + post;
                    key = key.substring(0, key.length() - 1);
                }
                if (sqlInput.containsKey(key)) {
                    Object in = sqlInput.get(key);
                    if (in instanceof String[]) {
                        String[] vals = (String[])in;
                        if (vals.length != sqlCommand.size() && sqlCommand.size() > 1) {
                            throw new IllegalArgumentException("The key '" + key + "' in command \n'" + command + "'\n has not the same value count as the keys before.");
                        }
                        boolean addNewVals = sqlCommand.size() == 1;
                        for (int i = 0; i < vals.length; ++i) {
                            String value = this.checkForQuotationMarks(vals[i]);
                            if (addNewVals && i != 0) {
                                sqlCommand.add(i, (String)sqlCommand.get(0) + " " + pre + value + post);
                                continue;
                            }
                            sqlCommand.set(i, (String)sqlCommand.get(i) + " " + pre + value + post);
                        }
                        continue;
                    }
                    String value = this.checkForQuotationMarks((String)sqlInput.get(key));
                    for (int i = 0; i < sqlCommand.size(); ++i) {
                        sqlCommand.set(i, (String)sqlCommand.get(i) + " " + pre + value + post);
                    }
                    continue;
                }
                throw new IllegalArgumentException("The key '" + key + "' in command \n'" + command + "'\n does not exist in the input values.");
            }
            for (int i = 0; i < sqlCommand.size(); ++i) {
                sqlCommand.set(i, (String)sqlCommand.get(i) + " " + originalKey);
            }
            if (!originalKey.equalsIgnoreCase("update") && !originalKey.equalsIgnoreCase("delete") && !originalKey.equalsIgnoreCase("insert")) continue;
            update = true;
        }
        for (int i = 0; i < sqlCommand.size(); ++i) {
            this.execute((String)sqlCommand.get(i), sqlOutput, update);
            if (update || !mergeOutputIntoInput) continue;
            Enumeration keys = sqlOutput.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String[] val = (String[])sqlOutput.get(key);
                if (val == null || val.length == 0) continue;
                if (val.length == 1) {
                    sqlInput.put(key, val[0]);
                    continue;
                }
                sqlInput.put(key, val);
            }
        }
        return update || sqlOutput != null;
    }

    private void execute(String command, Hashtable output, boolean update) {
        if (this.m_bDebug) {
            System.out.println("Debug - SQLExecution - execute Command: " + command);
        }
        try {
            if (update) {
                this.mStatement.executeUpdate(command);
            } else {
                ResultSet sqlResult = this.mStatement.executeQuery(command);
                ResultSetMetaData sqlRSMeta = sqlResult.getMetaData();
                int columnCount = sqlRSMeta.getColumnCount();
                String[] columnNames = new String[columnCount];
                int countRows = 0;
                boolean goThroughRowsTheFirstTime = true;
                for (int i = 1; i <= columnCount; ++i) {
                    columnNames[i - 1] = sqlRSMeta.getColumnName(i);
                    Vector<String> v = new Vector<String>();
                    sqlResult.beforeFirst();
                    while (sqlResult.next()) {
                        String value = sqlResult.getString(i);
                        v.add(value);
                        if (!goThroughRowsTheFirstTime) continue;
                        ++countRows;
                    }
                    if (goThroughRowsTheFirstTime) {
                        goThroughRowsTheFirstTime = false;
                    }
                    String[] s = new String[countRows];
                    s = v.toArray(s);
                    output.put(columnNames[i - 1], s);
                    if (!this.m_bDebug) continue;
                    if (i == 1) {
                        System.out.print("Debug - SQLExecution - Command returns: ");
                        System.out.print("row: " + columnNames[i - 1] + "   vals: ");
                    }
                    for (int j = 0; j < s.length; ++j) {
                        System.out.print(s[j] + " ");
                    }
                    if (i != columnCount - 1) continue;
                    System.out.println();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String checkForQuotationMarks(String checkString) {
        String returnString = checkString;
        int quotIndex = 0;
        while ((quotIndex = returnString.indexOf(34)) != -1) {
            String firstHalf = returnString.substring(0, quotIndex);
            String secondHalf = returnString.substring(quotIndex + 1);
            returnString = firstHalf + "''" + secondHalf;
        }
        return returnString;
    }
}

