/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.util.Hashtable;
import share.LogWriter;
import stats.SimpleOutProducer;
import util.DynamicClassLoader;

public class OutProducerFactory {
    public static LogWriter createOutProducer(Hashtable param) {
        LogWriter dbOut = null;
        boolean getDatabase = OutProducerFactory.convertToBool(param.get("DataBaseOut"));
        if (getDatabase) {
            dbOut = OutProducerFactory.createDataBaseOutProducer(param);
        }
        if (dbOut == null) {
            DynamicClassLoader dcl = new DynamicClassLoader();
            String outProducerName = (String)param.get("OutProducer");
            if (outProducerName != null) {
                try {
                    dbOut = (LogWriter)dcl.getInstance(outProducerName);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        if (dbOut == null) {
            dbOut = OutProducerFactory.createSimpleOutProducer();
        }
        return dbOut;
    }

    public static LogWriter createDataBaseOutProducer(Hashtable param) {
        String dataProducerName = (String)param.get("DataBaseOutProducer");
        if (dataProducerName == null) {
            String testBaseName = (String)param.get("TestBase");
            dataProducerName = testBaseName.substring(testBaseName.indexOf("_") + 1);
            dataProducerName = "stats." + OutProducerFactory.makeFirstCharUpperCase(dataProducerName) + "DataBaseOutProducer";
        }
        DynamicClassLoader dcl = new DynamicClassLoader();
        LogWriter dbOut = null;
        try {
            dbOut = (LogWriter)dcl.getInstance(dataProducerName, new Class[]{new Hashtable().getClass()}, new Object[]{param});
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        return dbOut;
    }

    public static LogWriter createSimpleOutProducer() {
        return new SimpleOutProducer();
    }

    private static boolean convertToBool(Object val) {
        if (val != null) {
            if (val instanceof String) {
                String sVal = (String)val;
                if (sVal.equalsIgnoreCase("true") || sVal.equalsIgnoreCase("yes")) {
                    return true;
                }
            } else if (val instanceof Boolean) {
                return (Boolean)val;
            }
        }
        return false;
    }

    private static String makeFirstCharUpperCase(String name) {
        return name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

