/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import share.LogWriter;
import stats.DataBaseOutProducer;

public class FatDataBaseOutProducer
extends DataBaseOutProducer {
    public FatDataBaseOutProducer(Hashtable param) {
        super(param);
        String testBase = (String)this.mSqlInput.get("TestBase");
        int sep = testBase.indexOf(95);
        String testLanguage = testBase.substring(0, sep);
        testBase = testBase.substring(sep + 1);
        String apiVersion = (String)this.mSqlInput.get("Version");
        String descriptionString = testLanguage + ":" + (String)this.mSqlInput.get("OperatingSystem") + ":" + testBase + ":" + apiVersion;
        apiVersion = apiVersion.substring(0, 6);
        if (this.mSqlInput.get("Date") != null) {
            this.mSqlInput.put("date", this.mSqlInput.get("Date"));
        }
        if (this.mSqlInput.get("date") == null) {
            GregorianCalendar cal = new GregorianCalendar();
            DecimalFormat dfmt = new DecimalFormat("00");
            String year = Integer.toString(cal.get(1));
            String month = dfmt.format(cal.get(2) + 1);
            String day = dfmt.format(cal.get(5));
            String dateString = year + "-" + month + "-" + day;
            this.mSqlInput.put("date", dateString);
        }
        this.setWriteableEntryTypes(new String[]{"property", "method", "component", "interface", "service"});
        this.mSqlInput.put("test_run.description", descriptionString);
        this.mSqlInput.put("api_version_name", apiVersion);
    }

    @Override
    protected boolean prepareDataBase(LogWriter log) {
        this.executeSQLCommand("SHOW TABLES");
        this.executeSQLCommand("SELECT id AS \"test_run.id\", api_version_id, description, date FROM test_run WHERE date = \"$date\" AND description = \"$test_run.description\";", true);
        String id = (String)this.mSqlInput.get("test_run.id");
        if (id == null) {
            this.executeSQLCommand("SELECT id AS api_version_id FROM api_version WHERE version = \"$api_version_name\";", true);
            String api_version_id = (String)this.mSqlInput.get("api_version_id");
            if (api_version_id == null) {
                this.executeSQLCommand("INSERT api_version (api_name, version) VALUES (\"soapi\", \"$api_version_name\")");
                this.executeSQLCommand("SELECT id AS api_version_id FROM api_version WHERE version = \"$api_version_name\";", true);
            }
            this.executeSQLCommand("INSERT test_run (api_version_id, description, date) VALUES ($api_version_id, \"$test_run.description\", \"$date\");");
            this.executeSQLCommand("SELECT test_run.id AS \"test_run.id\", api_version_id, description, date FROM test_run WHERE date = \"$date\" AND description = \"$test_run.description\";", true);
        }
        return true;
    }

    protected boolean checkDataBase(LogWriter log) {
        return true;
    }

    @Override
    protected boolean insertEntry(LogWriter log) {
        this.executeSQLCommand("SELECT id AS \"entry.id\", name AS \"entry.name\" FROM entry WHERE name = \"$EntryLongName\";", true);
        if (this.mSqlInput.get("entry.id") == null) {
            this.executeSQLCommand("INSERT entry (name, type) VALUES (\"$EntryLongName\", \"$EntryType\");");
            this.executeSQLCommand("SELECT id AS \"entry.id\", name AS \"entry.name\" FROM entry WHERE name = \"$EntryLongName\";", true);
        }
        this.executeSQLCommand("SELECT id AS \"api_entry.id\", api_version_id AS \"api_entry.api_version_id\", entry_id AS \"api_entry.entry_id\" FROM api_entry WHERE entry_id = $entry.id;", true);
        if (this.mSqlInput.get("api_entry.id") == null) {
            this.executeSQLCommand("INSERT api_entry (entry_id, api_version_id) VALUES ($entry.id, $api_version_id);");
            this.executeSQLCommand("SELECT id AS \"api_entry.id\", api_version_id AS \"api_entry.api_version_id\", entry_id AS \"api_entry.entry_id\" FROM api_entry WHERE entry_id = $entry.id;", true);
        }
        this.executeSQLCommand("SELECT status AS \"test_state.status\" FROM test_state WHERE test_run_id = $test_run.id AND entry_id = $entry.id;", true);
        String status = (String)this.mSqlInput.get("test_state.status");
        if (status == null) {
            this.executeSQLCommand("INSERT test_state (test_run_id, entry_id, status) VALUES ($test_run.id, $entry.id, \"$EntryState\");");
        } else if (!status.endsWith("OK")) {
            this.executeSQLCommand("UPDATE test_state SET status = \"$EntryState\" WHERE test_run_id = $test_run.id AND entry_id = $entry.id;");
        }
        return true;
    }

    @Override
    public Object getWatcher() {
        return null;
    }

    @Override
    public void setWatcher(Object watcher) {
    }
}

