/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.util.Hashtable;
import share.DescEntry;
import share.LogWriter;
import stats.SQLExecution;

public abstract class DataBaseOutProducer
implements LogWriter {
    protected Hashtable mSqlInput = new Hashtable();
    protected Hashtable mSqlOutput = null;
    protected String[] mWriteableEntryTypes = null;
    protected SQLExecution mSqlExec;
    protected boolean m_bDebug = false;

    public DataBaseOutProducer(Hashtable param) {
        this.mSqlInput.putAll(param);
        Object o = param.get("DebugIsActive");
        String debug = null;
        debug = o instanceof String ? (String)o : o.toString();
        if (debug != null && (debug.equalsIgnoreCase("true") || debug.equalsIgnoreCase("yes"))) {
            this.m_bDebug = true;
        }
        this.setWriteableEntryTypes(new String[]{"method"});
    }

    @Override
    public boolean initialize(DescEntry entry, boolean active) {
        String jdbcClass;
        if (entry.UserDefinedParams != null) {
            this.mSqlInput.putAll(entry.UserDefinedParams);
        }
        if ((jdbcClass = (String)this.mSqlInput.get("JDBC")) == null) {
            jdbcClass = "org.gjt.mm.mysql.Driver";
        }
        String dbURL = (String)this.mSqlInput.get("DataBaseURL");
        String user = (String)this.mSqlInput.get("User");
        String password = (String)this.mSqlInput.get("Password");
        if (user == null) {
            user = (String)this.mSqlInput.get("OperatingSystem");
        }
        if (password == null) {
            password = user;
        }
        this.mSqlExec = new SQLExecution(jdbcClass, dbURL, user, password, this.m_bDebug);
        this.mSqlExec.openConnection();
        this.prepareDataBase(entry.Logger);
        return true;
    }

    @Override
    public boolean summary(DescEntry entry) {
        this.mSqlExec.openConnection();
        this.findTypeInEntryTree(entry, entry.Logger);
        this.mSqlExec.closeConnection();
        return true;
    }

    protected boolean findTypeInEntryTree(DescEntry entry, LogWriter log) {
        boolean returnVal = true;
        if (this.isWriteableEntryType(entry)) {
            returnVal &= this.insertEntry(entry, log);
        }
        if (entry.SubEntryCount > 0) {
            for (int i = 0; i < entry.SubEntryCount; ++i) {
                returnVal &= this.findTypeInEntryTree(entry.SubEntries[i], log);
            }
        }
        return returnVal;
    }

    protected boolean insertEntry(DescEntry entry, LogWriter log) {
        Hashtable copySqlInput = new Hashtable();
        copySqlInput.putAll(this.mSqlInput);
        this.mSqlInput.put("EntryLongName", entry.longName);
        this.mSqlInput.put("EntryName", entry.entryName);
        this.mSqlInput.put("EntryState", entry.State);
        this.mSqlInput.put("EntryType", entry.EntryType);
        boolean result = this.insertEntry(log);
        this.mSqlInput = copySqlInput;
        return result;
    }

    public void setWriteableEntryTypes(String[] types) {
        this.mWriteableEntryTypes = types;
    }

    protected boolean isWriteableEntryType(DescEntry entry) {
        boolean result = false;
        for (int i = 0; i < this.mWriteableEntryTypes.length; ++i) {
            if (!entry.EntryType.equals(this.mWriteableEntryTypes[i])) continue;
            result = true;
            break;
        }
        return result;
    }

    protected boolean executeSQLCommand(String command, boolean mergeOutput) {
        return this.mSqlExec.executeSQLCommand(command, this.mSqlInput, this.mSqlOutput, mergeOutput);
    }

    protected boolean executeSQLCommand(String command) {
        return this.mSqlExec.executeSQLCommand(command, this.mSqlInput, this.mSqlOutput);
    }

    @Override
    public void println(String msg) {
    }

    protected abstract boolean prepareDataBase(LogWriter var1);

    protected abstract boolean insertEntry(LogWriter var1);
}

