/*
 * Decompiled with CFR 0.152.
 */
package stats;

import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import share.LogWriter;
import stats.DataBaseOutProducer;

public class ComplexDataBaseOutProducer
extends DataBaseOutProducer {
    public ComplexDataBaseOutProducer(Hashtable param) {
        super(param);
        Object o = param.get("DebugIsActive");
        if (o != null && o instanceof String) {
            String debug = (String)o;
            this.m_bDebug = debug.equalsIgnoreCase("yes") || debug.equalsIgnoreCase("true");
        }
        String testBase = (String)this.mSqlInput.get("TestBase");
        String apiVersion = (String)this.mSqlInput.get("Version");
        String os = (String)this.mSqlInput.get("OperatingSystem");
        if (testBase == null || apiVersion == null || os == null) {
            System.err.println("The ComplexDataBaseOutProducer constructor needs this parameters to work correctly:");
            System.err.println("TestBase - " + testBase);
            System.err.println("Version - " + apiVersion);
            System.err.println("OperatingSystem - " + os);
            System.err.println("Add the missing parameter.");
        }
        int sep = testBase.indexOf(95);
        String testLanguage = testBase.substring(0, sep);
        testBase = testBase.substring(sep + 1);
        String descriptionString = testLanguage + ":" + os + ":" + testBase + ":" + apiVersion;
        if (apiVersion != null) {
            apiVersion = apiVersion.substring(0, 6);
        }
        if (this.mSqlInput.get("date") == null) {
            GregorianCalendar cal = new GregorianCalendar();
            DecimalFormat dfmt = new DecimalFormat("00");
            String year = Integer.toString(cal.get(1));
            String month = dfmt.format(cal.get(2) + 1);
            String day = dfmt.format(cal.get(5));
            String dateString = year + "-" + month + "-" + day;
            this.mSqlInput.put("date", dateString);
        }
        this.mSqlInput.put("test_run_description", descriptionString);
        this.mSqlInput.put("api_version_name", apiVersion);
        this.setWriteableEntryTypes(new String[]{"unit", "method"});
    }

    @Override
    protected boolean prepareDataBase(LogWriter log) {
        this.executeSQLCommand("SELECT id AS \"test_run.id\", api_version_id, description, date FROM test_run WHERE date = \"$date\" AND description = \"$test_run_description\";", true);
        String id = (String)this.mSqlInput.get("test_run.id");
        if (id == null) {
            this.executeSQLCommand("SELECT id as api_version_id FROM api_version WHERE version = \"$api_version_name\";", true);
            String api_version_id = (String)this.mSqlInput.get("api_version_id");
            if (api_version_id == null) {
                this.executeSQLCommand("INSERT api_version (api_name, version) VALUES (\"soapi\", \"$api_version_name\")");
                this.executeSQLCommand("SELECT id as api_version_id FROM api_version WHERE version = \"$api_version_name\";", true);
            }
            this.executeSQLCommand("INSERT test_run (api_version_id, description, date) VALUES ($api_version_id, \"$test_run_description\", \"$date\");");
            this.executeSQLCommand("SELECT id AS \"test_run.id\", api_version_id, description, date FROM test_run WHERE date = \"$date\" AND description = \"$test_run_description\";", true);
        }
        return true;
    }

    @Override
    protected boolean insertEntry(LogWriter log) {
        if (this.m_bDebug) {
            System.out.println("DEBUG - ComplexDataBaseOutProducer: entry.id has to be null: " + (this.mSqlInput.get("entry.id") == null));
            System.out.println("DEBUG - ComplexDataBaseOutProducer: EntryLongName: " + this.mSqlInput.get("EntryLongName"));
        }
        this.executeSQLCommand("SELECT id as \"entry.id\", name as \"entry.name\" FROM entry WHERE name = \"$EntryLongName\";", true);
        if (this.mSqlInput.get("entry.id") == null) {
            if (this.m_bDebug) {
                System.out.println("DEBUG - ComplexDataBaseOutProducer: No entry.id found, this is a new entry in the database.");
            }
            this.executeSQLCommand("INSERT entry (name, type) VALUES (\"$EntryLongName\", \"$EntryType\");");
            this.executeSQLCommand("SELECT id as \"entry.id\", name as \"entry.name\" FROM entry WHERE name = \"$EntryLongName\";", true);
        }
        this.executeSQLCommand("SELECT id as \"api_entry.id\", api_version_id as \"api_entry.api_version_id\", entry_id as \"api_entry.entry_id\" FROM api_entry WHERE entry_id = $entry.id;", true);
        if (this.mSqlInput.get("api_entry.id") == null) {
            System.out.println("No api_entry.id found");
            this.executeSQLCommand("INSERT api_entry (entry_id, api_version_id) VALUES ($entry.id, $api_version_id);");
            this.executeSQLCommand("SELECT id as \"api_entry.id\", api_version_id as \"api_entry.api_version_id\", entry_id as \"api_entry.entry_id\" FROM api_entry WHERE entry_id = $entry.id;", true);
        }
        this.executeSQLCommand("SELECT status as \"test_state.status\" FROM test_state WHERE test_run_id = $test_run.id AND entry_id = $entry.id;", true);
        String entryState = (String)this.mSqlInput.get("EntryState");
        String status = (String)this.mSqlInput.get("test_state.status");
        if (!entryState.equals("SKIPPED.FAILED")) {
            if (status == null) {
                this.executeSQLCommand("INSERT test_state (test_run_id, entry_id, status) VALUES ($test_run.id, $entry.id, \"$EntryState\");");
            } else {
                this.executeSQLCommand("UPDATE test_state SET status = \"$EntryState\" where test_run_id =$test_run.id AND entry_id = $entry.id;");
            }
        }
        return true;
    }

    @Override
    public Object getWatcher() {
        return null;
    }

    @Override
    public void setWatcher(Object watcher) {
    }
}

