/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice;

import base.TestBase;
import helper.CfgParser;
import helper.ClParser;
import helper.StringHelper;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import lib.TestParameters;
import util.DynamicClassLoader;

public class Runner {
    private static long m_nStartTime;

    public static long getRunnerStartTime() {
        return m_nStartTime;
    }

    private static long getTime() {
        return System.currentTimeMillis();
    }

    private static void setStartTime(long _nStartTime) {
        m_nStartTime = _nStartTime;
    }

    public static long meanTime(long _nCurrentTimer) {
        if (_nCurrentTimer == 0L) {
            System.out.println("Forgotten to initialise a start timer?");
            return 0L;
        }
        long nMeanTime = Runner.getTime();
        return nMeanTime - _nCurrentTimer;
    }

    private static String beautifyTime(long _nTime) {
        long sec = _nTime / 1000L % 60L;
        long min = _nTime / 60000L % 60L;
        long hour = _nTime / 3600000L;
        StringBuffer aTime = new StringBuffer();
        aTime.append(StringHelper.createValueString((int)hour, 2)).append(':').append(StringHelper.createValueString((int)min, 2)).append(':').append(StringHelper.createValueString((int)sec, 2));
        return aTime.toString();
    }

    private static boolean checkVariableForCygwin(String _sVariable) {
        if (_sVariable == null) {
            return false;
        }
        return _sVariable.startsWith("/cygdrive");
    }

    private static boolean checkPathVariable(String _sPath, String delim) {
        String sPath = System.getProperty(_sPath);
        if (sPath != null) {
            StringTokenizer aTokenEnum = new StringTokenizer(sPath, delim);
            while (aTokenEnum.hasMoreElements()) {
                String sToken = (String)aTokenEnum.nextElement();
                if (!Runner.checkVariableForCygwin(sToken)) continue;
                System.err.println("ERROR: OOoRunner detect cygwin path in '" + _sPath + "'");
                return true;
            }
        }
        return false;
    }

    private static void checkAllVariablesForCygwinPath(TestParameters _aParams) {
        String sOsName = System.getProperty("os.name");
        if (!sOsName.toLowerCase().startsWith("windows")) {
            return;
        }
        Properties aProps = System.getProperties();
        Enumeration<Object> aEnum = aProps.propertyNames();
        boolean bEmergencyStop = false;
        while (aEnum.hasMoreElements()) {
            String sKey = (String)aEnum.nextElement();
            String sValue = System.getProperty(sKey);
            if (!Runner.checkVariableForCygwin(sValue)) continue;
            System.err.println("ERROR: OOoRunner detect cygwin path in '" + sKey + ":=" + sValue + "'");
            bEmergencyStop = true;
        }
        String sDelim = System.getProperty("path.separator");
        bEmergencyStop |= Runner.checkPathVariable("java.library.path", sDelim);
        bEmergencyStop |= Runner.checkPathVariable("java.class.path", sDelim);
        bEmergencyStop |= Runner.checkPathVariable("sun.boot.class.path", sDelim);
        aEnum = _aParams.keys();
        while (aEnum.hasMoreElements()) {
            String sValue;
            String sKey = (String)aEnum.nextElement();
            if (!(_aParams.get(sKey) instanceof String) || !Runner.checkVariableForCygwin(sValue = (String)_aParams.get(sKey))) continue;
            System.err.println("ERROR: OOoRunner detect cygwin path in '" + sKey + ":=" + sValue + "'");
            bEmergencyStop = true;
        }
        if (bEmergencyStop) {
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        System.out.println("OOoRunner Main() version from 20090825 (yyyymmdd)");
        Runner.setStartTime(Runner.getTime());
        DynamicClassLoader dcl = new DynamicClassLoader();
        TestParameters param = new TestParameters();
        ClParser cli = new ClParser();
        String iniFile = cli.getIniPath(args);
        CfgParser ini = new CfgParser(iniFile);
        ini.getIniParameters(param);
        String runnerIniFile = cli.getRunnerIniPath(args);
        CfgParser runnerIni = new CfgParser(runnerIniFile);
        runnerIni.getIniParameters(param);
        cli.getCommandLineParameter(param, args);
        Object tj = param.get("TestJob");
        if (tj == null) {
            System.out.println("==========================================================================");
            System.out.println("No TestJob given, please make sure that you ");
            System.out.println("a.) called the OOoRunner with the paramter -o <job> or -sce <scenarioFile>");
            System.out.println("or");
            System.out.println("b.) have an entry called TestJob in your used properties file");
            System.out.println("==========================================================================");
            System.exit(-1);
        }
        System.out.println("TestJob: " + tj);
        String sName = "base." + (String)param.get("TestBase");
        TestBase toExecute = (TestBase)dcl.getInstance(sName);
        Runner.checkAllVariablesForCygwinPath(param);
        boolean worked = toExecute.executeTest(param);
        long nTime = Runner.meanTime(Runner.getRunnerStartTime());
        String sBeautifyTime = Runner.beautifyTime(nTime);
        System.out.println("Job run took: " + nTime + "ms " + " [" + sBeautifyTime + "]");
        if (!worked) {
            System.out.println("Job " + param.get("TestJob") + " failed");
            System.exit(-1);
        } else {
            System.out.println("Job " + param.get("TestJob") + " done");
            System.exit(0);
        }
    }
}

