/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import helper.AppProvider;
import java.util.Hashtable;
import lib.TestParameters;
import util.utils;

public class UnoProvider
implements AppProvider {
    @Override
    public boolean closeExistingOffice(TestParameters param, boolean closeIfPossible) {
        return this.disposeManager(param);
    }

    @Override
    public boolean disposeManager(TestParameters param) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)param.remove("ServiceManager");
        xMSF = null;
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return true;
    }

    @Override
    public Object getManager(TestParameters param) {
        XMultiServiceFactory xMSF = (XMultiServiceFactory)param.getMSF();
        if (xMSF == null) {
            String unorcName = this.getUnorcName(param);
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("SYSBINDIR", this.getSysBinDir(param));
            XComponentContext xContext = null;
            try {
                xContext = Bootstrap.defaultBootstrap_InitialComponentContext((String)unorcName, env);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("Could not get XComponentContext. Maybe you must add program folder to LD_LIBRARY_PATH");
                return null;
            }
            XMultiComponentFactory xMCF = xContext.getServiceManager();
            xMSF = UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)xMCF);
        }
        return xMSF;
    }

    private String getUnorcName(TestParameters param) {
        String unorcName = (String)param.get("UNORC");
        if (unorcName == null) {
            String office = (String)param.get("AppExecutionCommand");
            String opSystem = (String)param.get("OperatingSystem");
            unorcName = opSystem != null && opSystem.equalsIgnoreCase("wntmsci") ? "uno.ini" : "unorc";
            if (office == null) {
                return null;
            }
            unorcName = office.substring(0, office.indexOf("program") + 7) + "/" + unorcName;
        }
        unorcName = utils.getFullURL(unorcName);
        if (param.DebugIsActive) {
            System.out.println("UnoUcr: " + unorcName);
        }
        return unorcName;
    }

    private String getSysBinDir(TestParameters param) {
        String base = (String)param.get("AppExecutionCommand");
        if (base == null) {
            base = (String)param.get("UNORC");
        }
        if (base == null) {
            return null;
        }
        String sysbindir = base.substring(0, base.indexOf("program") + 7);
        sysbindir = utils.getFullURL(sysbindir);
        if (param.DebugIsActive) {
            System.out.println("SysBinDir: " + sysbindir);
        }
        return sysbindir;
    }
}

