/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.uno.RuntimeException;
import com.sun.star.util.URL;
import com.sun.star.util.XURLTransformer;
import java.io.File;
import java.net.MalformedURLException;
import java.util.Enumeration;
import java.util.Vector;

public class URLHelper {
    public static String getFileURLFromSystemPath(File aSystemPath) {
        String sFileURL = null;
        try {
            sFileURL = aSystemPath.toURL().toString();
        }
        catch (MalformedURLException exWrong) {
            sFileURL = null;
        }
        if (sFileURL != null && sFileURL.startsWith("file:/") && !sFileURL.startsWith("file://")) {
            StringBuffer sWorkBuffer = new StringBuffer(sFileURL);
            sWorkBuffer.insert(6, "//");
            sFileURL = sWorkBuffer.toString();
        }
        return sFileURL;
    }

    public static String getFileURLFromSystemPath(String sSystemPath) {
        return URLHelper.getFileURLFromSystemPath(new File(sSystemPath));
    }

    public static String getURLWithProtocolFromSystemPath(File aSystemPath, File aBasePath, String sServerURL) {
        String sFileURL = URLHelper.getFileURLFromSystemPath(aSystemPath);
        String sBaseURL = URLHelper.getFileURLFromSystemPath(aBasePath);
        if (sBaseURL.lastIndexOf(47) == sBaseURL.length() - 1) {
            sBaseURL = sBaseURL.substring(0, sBaseURL.length() - 1);
        }
        if (sServerURL.lastIndexOf(47) == sServerURL.length() - 1) {
            sServerURL = sServerURL.substring(0, sServerURL.length() - 1);
        }
        int index = sFileURL.indexOf(sBaseURL);
        String sURL = sFileURL.substring(0, index) + sServerURL + sFileURL.substring(index + sBaseURL.length());
        return sURL;
    }

    public static String getURLWithProtocolFromSystemPath(String sSystemPath, String sBasePath, String sServerPath) {
        return URLHelper.getURLWithProtocolFromSystemPath(new File(sSystemPath), new File(sBasePath), sServerPath);
    }

    public static URL parseURL(XURLTransformer xParser, String sURL) {
        URL aURL = null;
        if (sURL == null || sURL.equals("")) {
            return null;
        }
        try {
            URL[] aParseURL = new URL[]{new URL()};
            aParseURL[0].Complete = sURL;
            xParser.parseStrict(aParseURL);
            aURL = aParseURL[0];
        }
        catch (RuntimeException exRuntime) {
            aURL = null;
        }
        return aURL;
    }

    public static Vector getSystemFilesFromDir(String sStartDir) {
        File aRoot = new File(sStartDir);
        if (!aRoot.exists()) {
            return null;
        }
        if (!aRoot.isDirectory()) {
            return null;
        }
        File[] lAllFiles = aRoot.listFiles();
        if (lAllFiles == null) {
            return null;
        }
        Vector<File> lFilteredFiles = new Vector<File>(lAllFiles.length);
        for (int i = 0; i < lAllFiles.length; ++i) {
            Vector lSubFiles;
            if (lAllFiles[i].isFile()) {
                lFilteredFiles.add(lAllFiles[i]);
                continue;
            }
            if (!lAllFiles[i].isDirectory() || (lSubFiles = URLHelper.getSystemFilesFromDir(lAllFiles[i].getPath())) == null) continue;
            Enumeration aSnapshot = lSubFiles.elements();
            while (aSnapshot.hasMoreElements()) {
                lFilteredFiles.add((File)aSnapshot.nextElement());
            }
        }
        return lFilteredFiles;
    }
}

