/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.OfficeWatcher;
import helper.Pump;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import lib.TestParameters;
import util.utils;

public class ProcessHandler {
    private String cmdLine;
    private String[] cmdLineArray;
    private String[] envVars = null;
    private File workDir = null;
    private PrintWriter log;
    private int exitValue = -1;
    private boolean isFinished = false;
    private boolean isStarted = false;
    private boolean mbTimedOut = false;
    private long mTimeOut = 0L;
    private String stdInBuff = "";
    private Pump stdout = null;
    private Pump stderr = null;
    private PrintStream stdIn = null;
    private Process m_aProcess = null;
    private TestParameters param = null;
    private boolean debug = false;
    private long m_nExactStartTimeInMillisec;

    public ProcessHandler(String cmdLine) {
        this(cmdLine, null, null, null, 0L);
    }

    public ProcessHandler(String[] cmdLines) {
        this(null, null, null, null, 0L);
        this.cmdLineArray = cmdLines;
    }

    public ProcessHandler(String[] cmdLines, String[] envVars) {
        this(null, null, null, envVars, 0L);
        this.cmdLineArray = cmdLines;
    }

    public ProcessHandler(String[] cmdLines, File workDir) {
        this(null, null, workDir, null, 0L);
        this.cmdLineArray = cmdLines;
    }

    public ProcessHandler(String[] cmdLines, PrintWriter log, File workDir) {
        this(null, log, workDir, null, 0L);
        this.cmdLineArray = cmdLines;
    }

    public ProcessHandler(String cmdLine, PrintWriter log) {
        this(cmdLine, log, null, null, 0L);
    }

    public ProcessHandler(String cmdLine, int timeOut) {
        this(cmdLine, null, null, null, timeOut);
    }

    public ProcessHandler(String cmdLine, File workDir) {
        this(cmdLine, null, workDir, null, 0L);
    }

    public ProcessHandler(String cmdLine, PrintWriter log, File workDir) {
        this(cmdLine, log, workDir, null, 0L);
    }

    public ProcessHandler(String cmdLine, PrintWriter log, File workDir, String[] envVars) {
        this(cmdLine, log, workDir, envVars, 0L);
    }

    public ProcessHandler(String cmdLine, PrintWriter log, File workDir, String[] envVars, long timeOut) {
        this.cmdLine = cmdLine;
        this.workDir = workDir;
        this.log = log;
        this.cmdLine = cmdLine;
        this.envVars = envVars;
        this.log = log == null ? new PrintWriter(new OutputStreamWriter(System.out)) : log;
        this.mTimeOut = timeOut;
    }

    public ProcessHandler(String[] commands, PrintWriter log, File workDir, int shortWait, TestParameters param) {
        this(null, log, workDir, null, 0L);
        this.cmdLineArray = commands;
        this.param = param;
        this.mTimeOut = shortWait != 0 ? (long)shortWait : (long)((double)param.getInt("TimeOut") / 1.3);
        this.debug = param.getBool("DebugIsActive");
    }

    public void runCommand() {
        boolean changedText = true;
        int count = 0;
        String memText = "";
        this.executeAsynchronously();
        OfficeWatcher ow = null;
        if (this.param != null) {
            ow = (OfficeWatcher)this.param.get("Watcher");
        }
        if (ow != null) {
            ow.ping();
        }
        int hangcheck = 10;
        while (!this.isFinished() && changedText) {
            ++count;
            this.waitFor(2000L, false);
            if (ow != null) {
                ow.ping();
            }
            if (this.isFinished() || --hangcheck >= 0) continue;
            String sOutputText = this.getOutputText();
            if (sOutputText.length() == memText.length()) {
                changedText = false;
            }
            hangcheck = 10;
            memText = this.getOutputText();
        }
        if (!this.isFinished()) {
            this.dbg("runCommand Process ist not finished but there are no changes in output stream.");
            this.kill();
        }
    }

    public boolean isTimedOut() {
        return this.mbTimedOut;
    }

    private void setTimedOut(boolean bTimedOut) {
        this.mbTimedOut = bTimedOut;
    }

    public boolean executeSynchronously() {
        this.execute();
        return this.waitFor(this.mTimeOut);
    }

    public boolean executeAsynchronously() {
        this.execute();
        return this.isStarted();
    }

    public synchronized void kill() {
        if (!this.isStarted()) {
            return;
        }
        boolean exit = false;
        int counter = 1;
        while (counter < 3 && !exit) {
            this.m_aProcess.destroy();
            try {
                Thread.sleep(1000 * counter);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                int exit_Value = this.m_aProcess.exitValue();
                if (exit_Value < 1) {
                    exit = true;
                } else {
                    ++counter;
                }
                this.dbg("kill: process closed with exit code " + exit_Value);
            }
            catch (IllegalThreadStateException e) {
                if (counter < 3) {
                    this.dbg("kill: Couldn't close process after " + counter + " attempts, trying again");
                }
                ++counter;
            }
        }
        this.isStarted = false;
    }

    public static long getSystemTime() {
        long nTime = System.currentTimeMillis();
        return nTime;
    }

    private void initialExactStartTime() {
        this.m_nExactStartTimeInMillisec = ProcessHandler.getSystemTime();
    }

    public long getProcessStartTime() {
        return this.m_nExactStartTimeInMillisec;
    }

    protected void execute() {
        if (this.isStarted()) {
            throw new RuntimeException("The process handler has already been executed.");
        }
        Runtime runtime = Runtime.getRuntime();
        try {
            if (this.cmdLine == null) {
                this.log.print(utils.getDateTime() + "execute: Starting command from array: ");
                for (int i = 0; i < this.cmdLineArray.length; ++i) {
                    this.log.print(this.cmdLineArray[i]);
                    this.log.print(" ");
                }
                this.log.println("");
                this.initialExactStartTime();
                this.m_aProcess = runtime.exec(this.cmdLineArray, this.envVars);
            } else if (this.workDir != null) {
                this.log.println(utils.getDateTime() + "execute: Starting command: " + this.cmdLine + " " + this.workDir.getAbsolutePath());
                this.m_aProcess = runtime.exec(this.cmdLine, this.envVars, this.workDir);
            } else {
                this.log.println(utils.getDateTime() + "execute: Starting command: " + this.cmdLine);
                this.m_aProcess = runtime.exec(this.cmdLine, this.envVars);
            }
            this.isStarted = true;
        }
        catch (IOException e) {
            if (this.cmdLine == null) {
                this.log.println(utils.getDateTime() + "execute: The command array can't be started: " + e);
            } else {
                this.log.println(utils.getDateTime() + "execute: The command " + this.cmdLine + " can't be started: " + e);
            }
            return;
        }
        this.dbg("execute: pump io-streams");
        this.stdout = new Pump(this.m_aProcess.getInputStream(), this.log, "out > ");
        this.stderr = new Pump(this.m_aProcess.getErrorStream(), this.log, "err > ");
        this.stdIn = new PrintStream(this.m_aProcess.getOutputStream());
        this.dbg("execute: flush io-streams");
        this.flushInput();
    }

    public boolean waitFor() {
        return this.waitFor(0L);
    }

    public boolean waitFor(long timeout) {
        return this.waitFor(timeout, true);
    }

    private boolean waitFor(long timeout, boolean bKillProcessAfterTimeout) {
        if (this.isFinished()) {
            return true;
        }
        if (!this.isStarted()) {
            return false;
        }
        if (timeout == 0L) {
            try {
                this.m_aProcess.waitFor();
            }
            catch (InterruptedException e) {
                this.log.println("The process was interrupted: " + e);
            }
            this.isFinished = true;
            try {
                this.exitValue = this.m_aProcess.exitValue();
            }
            catch (IllegalThreadStateException e) {}
        } else {
            try {
                while (!this.isFinished && timeout > 0L) {
                    this.isFinished = true;
                    Thread.sleep(1000L);
                    timeout -= 1000L;
                    try {
                        this.exitValue = this.m_aProcess.exitValue();
                    }
                    catch (IllegalThreadStateException e) {
                        this.isFinished = false;
                    }
                }
                if (timeout < 0L) {
                    this.setTimedOut(true);
                    this.log.println("The process has timed out!");
                }
            }
            catch (InterruptedException ex) {
                this.log.println("The process was interrupted: " + ex);
            }
        }
        if (bKillProcessAfterTimeout && !this.isFinished) {
            this.log.println("Going to destroy the process!!");
            this.m_aProcess.destroy();
            this.log.println("Process has been destroyed!");
        }
        return this.isFinished();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushInput() {
        if (this.stdIn == null) {
            return;
        }
        String string = this.stdInBuff;
        synchronized (string) {
            this.stdIn.print(this.stdInBuff);
            this.stdIn.flush();
            this.stdInBuff = "";
        }
    }

    public String getOutputText() {
        if (this.stdout == null) {
            return "";
        }
        return this.stdout.getStringBuffer();
    }

    public String getErrorText() {
        if (this.stderr == null) {
            return "";
        }
        return this.stderr.getStringBuffer();
    }

    public void printInputText(String str) {
        this.stdInBuff = this.stdInBuff + str;
        this.flushInput();
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public int getExitCode() {
        try {
            this.exitValue = this.m_aProcess.exitValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.exitValue;
    }

    public static void shortWait(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            System.out.println("While waiting :" + e);
        }
    }

    private void dbg(String message) {
        if (this.debug) {
            this.log.println(utils.getDateTime() + "PH." + message);
        }
    }
}

