/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.ProcessHandler;
import java.util.StringTokenizer;
import lib.TestParameters;
import share.Watcher;
import util.utils;

public class OfficeWatcher
extends Thread
implements Watcher {
    public boolean finish = false;
    private TestParameters params;
    private int StoredPing = 0;
    private boolean debug = false;

    public OfficeWatcher(TestParameters param) {
        this.params = param;
        this.debug = this.params.getBool("DebugIsActive");
    }

    @Override
    public void ping() {
        try {
            ++this.StoredPing;
        }
        catch (Exception e) {
            this.StoredPing = 0;
        }
    }

    @Override
    public int getPing() {
        return this.StoredPing;
    }

    @Override
    public void run() {
        this.dbg("started");
        boolean isDone = false;
        ProcessHandler ph = (ProcessHandler)this.params.get("AppProvider");
        int timeOut = this.params.getInt("TimeOut");
        if (ph == null) {
            isDone = true;
        }
        while (!isDone) {
            timeOut = this.params.getInt("TimeOut");
            int previous = this.StoredPing;
            this.shortWait(timeOut == 0 ? 30000 : timeOut);
            if (this.StoredPing == previous && timeOut != 0) {
                isDone = true;
            }
            if (!this.finish) continue;
            return;
        }
        if (ph != null) {
            this.dbg("the Office is idle for " + timeOut / 1000 + " seconds, it probably hangs and is killed NOW.");
            String AppKillCommand = (String)this.params.get("AppKillCommand");
            if (AppKillCommand != null) {
                StringTokenizer aKillCommandToken = new StringTokenizer(AppKillCommand, ";");
                while (aKillCommandToken.hasMoreTokens()) {
                    String sKillCommand = aKillCommandToken.nextToken();
                    this.dbg("User defined an application to destroy the started process.");
                    this.dbg("Trying to execute: " + sKillCommand);
                    ProcessHandler pHdl = new ProcessHandler(sKillCommand);
                    pHdl.executeSynchronously();
                }
            }
            ph.kill();
        } else {
            this.dbg("reaeched timeout but ProcessHandler is NULL");
        }
        this.shortWait(timeOut == 0 ? 30000 : timeOut);
        this.dbg("finished");
    }

    protected void shortWait(int timeOut) {
        try {
            OfficeWatcher.sleep(timeOut);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected void dbg(String message) {
        if (this.debug) {
            System.out.println(utils.getDateTime() + "OfficeWatcher: " + message);
        }
    }
}

