/*
 * Decompiled with CFR 0.152.
 */
package helper;

import lib.TestParameters;
import share.LogWriter;
import util.utils;

public class LoggingThread
extends Thread {
    TestParameters param;
    LogWriter log = null;
    boolean finished = false;
    boolean debug = false;

    public LoggingThread(LogWriter log, TestParameters tParam) {
        this.log = log;
        this.param = tParam;
        this.debug = tParam.getBool("DebugIsActive");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int timeOut = this.param.getInt("TimeOut") / 2;
        int count = 0;
        this.finished = false;
        if (this.debug) {
            this.log.println("TimeOutLogger: " + utils.getDateTime() + " start");
        }
        while (!this.finished && count < 200) {
            try {
                if (this.debug) {
                    this.log.println("TimeOutLogger: " + utils.getDateTime() + count);
                }
                LoggingThread loggingThread = this;
                synchronized (loggingThread) {
                    this.wait(timeOut);
                }
                ++count;
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.debug) {
            this.log.println("TimeOutLogger: " + utils.getDateTime() + " finished");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        try {
            this.finished = true;
            LoggingThread loggingThread = this;
            synchronized (loggingThread) {
                this.notify();
            }
            if (this.debug) {
                this.log.println("TimeOutLogger: " + utils.getDateTime() + " try to finish ");
            }
            LoggingThread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

