/*
 * Decompiled with CFR 0.152.
 */
package helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileTools {
    public static void copyDirectory(File srcDir, File dstDir) throws IOException {
        FileTools.copyDirectory(srcDir, dstDir, new String[0]);
    }

    public static void copyDirectory(File srcDir, File dstDir, String[] ignore) throws IOException {
        for (int i = 0; i < ignore.length; ++i) {
            if (!srcDir.getName().endsWith(ignore[i])) continue;
            return;
        }
        if (srcDir.isDirectory()) {
            if (!dstDir.exists()) {
                dstDir.mkdir();
            }
            String[] files = srcDir.list();
            for (int i = 0; i < files.length; ++i) {
                FileTools.copyDirectory(new File(srcDir, files[i]), new File(dstDir, files[i]), ignore);
            }
        } else {
            FileTools.copyFile(srcDir, dstDir);
        }
    }

    public static void copyFile(File src, File dst) throws IOException {
        int len;
        FileInputStream in = new FileInputStream(src);
        FileOutputStream out = new FileOutputStream(dst);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)in).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((InputStream)in).close();
        ((OutputStream)out).close();
    }

    public static boolean deleteDir(File dir) {
        return FileTools.cleanDir(dir);
    }

    public static boolean cleanDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = FileTools.cleanDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }
}

