/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.BuildEnvTools;
import helper.ParameterNotFoundException;
import helper.ProcessHandler;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import lib.TestParameters;
import share.CwsDataExchange;
import share.LogWriter;
import util.utils;

public class CwsDataExchangeImpl
implements CwsDataExchange {
    private final String cwsName;
    private final TestParameters param;
    private final LogWriter log;
    private final BuildEnvTools bet;
    private final boolean mDebug;

    public CwsDataExchangeImpl(String cwsName, TestParameters param, LogWriter log) throws ParameterNotFoundException {
        this.cwsName = cwsName;
        this.param = param;
        this.log = log;
        this.bet = new BuildEnvTools(param, log);
        this.mDebug = param.getBool("DebugIsActive");
    }

    @Override
    public ArrayList getModules() {
        String[] commands = new String[]{"echo cwstouched starts here", "cwstouched", "echo cwstouched ends here"};
        ProcessHandler procHdl = this.bet.runCommandsInEnvironmentShell(commands, null, 20000);
        if (this.mDebug) {
            this.log.println("---> Output of getModules:");
            this.log.println(procHdl.getOutputText());
            this.log.println("<--- Output of getModules");
            this.log.println("---> Error output of getModules");
            this.log.println(procHdl.getErrorText());
            this.log.println("<--- Error output of getModules");
        }
        String[] outs = procHdl.getOutputText().split("\n");
        ArrayList<String> moduleNames = new ArrayList<String>();
        boolean bStart = false;
        for (int i = 0; i < outs.length; ++i) {
            String line = outs[i];
            if (line.startsWith("cwstouched starts here")) {
                bStart = true;
                continue;
            }
            if (line.startsWith("cwstouched ends here")) {
                bStart = false;
                continue;
            }
            if (!bStart || line.length() <= 1) continue;
            moduleNames.add(line);
        }
        return moduleNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnoApiCwsStatus(boolean status) {
        OutputStreamWriter out = null;
        String statusFile = null;
        try {
            String stat = status ? ".PASSED.OK" : ".PASSED.FAILED";
            statusFile = utils.getUsersTempDir() + System.getProperty("file.separator") + "UnoApiCwsStatus." + (String)this.param.get("Version") + "_" + this.param.get("OperatingSystem") + stat + ".txt";
            out = new FileWriter(statusFile);
            out.write(stat);
            out.flush();
            out.close();
            String[] commands = new String[]{"cwsattach " + statusFile};
            this.bet.runCommandsInEnvironmentShell(commands, null, 5000);
        }
        catch (IOException ex) {
            System.out.println("ERROR: could not attach file '" + statusFile + "' to cws\n" + ex.toString());
        }
        finally {
            try {
                out.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

