/*
 * Decompiled with CFR 0.152.
 */
package helper;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.XPropertySet;
import com.sun.star.container.ElementExistException;
import com.sun.star.container.NoSuchElementException;
import com.sun.star.container.XHierarchicalNameAccess;
import com.sun.star.container.XNameContainer;
import com.sun.star.container.XNameReplace;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.Exception;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.util.XChangesBatch;

public class ConfigHelper {
    private XMultiServiceFactory m_xSMGR = null;
    private XHierarchicalNameAccess m_xConfig = null;

    public ConfigHelper(XMultiServiceFactory xSMGR, String sConfigPath, boolean bReadOnly) throws Exception {
        this.m_xSMGR = xSMGR;
        XMultiServiceFactory xConfigRoot = UnoRuntime.queryInterface(XMultiServiceFactory.class, this.m_xSMGR.createInstance("com.sun.star.configuration.ConfigurationProvider"));
        Object[] lParams = new PropertyValue[]{new PropertyValue()};
        lParams[0].Name = "nodepath";
        lParams[0].Value = sConfigPath;
        Object aConfig = bReadOnly ? xConfigRoot.createInstanceWithArguments("com.sun.star.configuration.ConfigurationAccess", lParams) : xConfigRoot.createInstanceWithArguments("com.sun.star.configuration.ConfigurationUpdateAccess", lParams);
        this.m_xConfig = UnoRuntime.queryInterface(XHierarchicalNameAccess.class, aConfig);
        if (this.m_xConfig == null) {
            throw new Exception("Could not open configuration \"" + sConfigPath + "\"");
        }
    }

    public Object readRelativeKey(String sRelPath, String sKey) throws NoSuchElementException {
        try {
            XPropertySet xPath = UnoRuntime.queryInterface(XPropertySet.class, this.m_xConfig.getByHierarchicalName(sRelPath));
            return xPath.getPropertyValue(sKey);
        }
        catch (Exception ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    public void writeRelativeKey(String sRelPath, String sKey, Object aValue) throws NoSuchElementException {
        try {
            XPropertySet xPath = UnoRuntime.queryInterface(XPropertySet.class, this.m_xConfig.getByHierarchicalName(sRelPath));
            xPath.setPropertyValue(sKey, aValue);
        }
        catch (Exception ex) {
            throw new NoSuchElementException(ex.getMessage());
        }
    }

    public void flush() {
        try {
            XChangesBatch xBatch = UnoRuntime.queryInterface(XChangesBatch.class, (Object)this.m_xConfig);
            xBatch.commitChanges();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Object readDirectKey(XMultiServiceFactory xSMGR, String sConfigFile, String sRelPath, String sKey) throws Exception {
        ConfigHelper aConfig = new ConfigHelper(xSMGR, sConfigFile, true);
        return aConfig.readRelativeKey(sRelPath, sKey);
    }

    public static void writeDirectKey(XMultiServiceFactory xSMGR, String sConfigFile, String sRelPath, String sKey, Object aValue) throws Exception {
        ConfigHelper aConfig = new ConfigHelper(xSMGR, sConfigFile, false);
        aConfig.writeRelativeKey(sRelPath, sKey, aValue);
        aConfig.flush();
    }

    public XNameReplace getOrInsertGroup(String setName, String groupName) throws Exception {
        XNameContainer xSetCont = this.getSet(setName);
        XNameReplace xChildAccess = null;
        try {
            Object xChild = xSetCont.getByName(groupName);
            xChildAccess = UnoRuntime.queryInterface(XNameReplace.class, (Object)xSetCont);
        }
        catch (NoSuchElementException e) {
            // empty catch block
        }
        if (xChildAccess == null) {
            XSingleServiceFactory xChildfactory = UnoRuntime.queryInterface(XSingleServiceFactory.class, (Object)xSetCont);
            Object xNewChild = xChildfactory.createInstance();
            xSetCont.insertByName(groupName, xNewChild);
            xChildAccess = UnoRuntime.queryInterface(XNameContainer.class, xNewChild);
        }
        return xChildAccess;
    }

    public void updateGroupProperty(String setName, String groupName, String propName, Object propValue) throws Exception {
        XNameContainer xSetCont = this.getSet(setName);
        XPropertySet xProp = null;
        try {
            xProp = UnoRuntime.queryInterface(XPropertySet.class, xSetCont.getByName(groupName));
        }
        catch (NoSuchElementException e) {
            throw new Exception("could not get group '" + groupName + "' from set '" + setName + "':\n" + e.toString());
        }
        try {
            xProp.setPropertyValue(propName, propValue);
        }
        catch (Exception e) {
            throw new Exception("could not set property '" + propName + "' from group '" + groupName + "' from set '" + setName + "':\n" + e.toString());
        }
    }

    public void insertOrUpdateExtensibleGroupProperty(String setName, String group, String extGroup, String propName, Object propValue) throws Exception {
        Object xGroup;
        XNameContainer xSetCont = this.getSet(setName);
        XNameReplace xGroupAccess = null;
        XNameContainer xExtGroupCont = null;
        try {
            xGroup = xSetCont.getByName(group);
            xGroupAccess = UnoRuntime.queryInterface(XNameReplace.class, xGroup);
        }
        catch (NoSuchElementException e) {
            throw new Exception("could not get group '" + group + "' from set '" + setName + "':\n" + e.toString());
        }
        try {
            xGroup = xGroupAccess.getByName(extGroup);
            xExtGroupCont = UnoRuntime.queryInterface(XNameContainer.class, xGroup);
        }
        catch (NoSuchElementException e) {
            throw new Exception("could not get extensilbe group '" + extGroup + "' from group '" + group + "' from set '" + setName + "':\n" + e.toString());
        }
        try {
            xExtGroupCont.insertByName(propName, propValue);
        }
        catch (ElementExistException e) {
            xExtGroupCont.replaceByName(propName, propValue);
        }
    }

    public XNameContainer getSet(String setName) throws Exception {
        XNameReplace xCont = UnoRuntime.queryInterface(XNameReplace.class, (Object)this.m_xConfig);
        Object oSet = xCont.getByName(setName);
        if (oSet == null) {
            throw new Exception("could not get set '" + setName + ": null");
        }
        return UnoRuntime.queryInterface(XNameContainer.class, oSet);
    }
}

