/*
 * Decompiled with CFR 0.152.
 */
package helper;

import complexlib.ComplexTestCase;
import java.util.Vector;
import share.ComplexTest;
import share.DescEntry;
import share.DescGetter;
import share.LogWriter;
import util.DynamicClassLoader;

public class ComplexDescGetter
extends DescGetter {
    ComplexTest testClass = null;

    @Override
    public DescEntry[] getDescriptionFor(String entry, String DescPath, boolean debug) {
        DescEntry dEntry;
        if (entry.startsWith("-sce")) {
            DescEntry[] entries = this.getScenario(entry.substring(5), null, debug);
            return entries;
        }
        if (entry.startsWith("-o") && (dEntry = this.getDescriptionForSingleJob(entry.substring(3), null, debug)) != null) {
            return new DescEntry[]{dEntry};
        }
        System.out.println("Could not get a testjob with parameter '" + entry + "'");
        return null;
    }

    @Override
    protected DescEntry getDescriptionForSingleJob(String className, String descPath, boolean debug) {
        int index;
        DynamicClassLoader dcl = new DynamicClassLoader();
        String[] methodNames = null;
        if (debug) {
            System.out.println("Searching Class: " + className);
        }
        if ((index = className.indexOf("::")) != -1) {
            String method = className.substring(index + 2);
            className = className.substring(0, index);
            Vector<String> methods = new Vector<String>();
            String[] split = method.split("(?<=\\)),(?=\\w+)");
            for (int i = 0; i < split.length; ++i) {
                String meth = split[i];
                if (meth.endsWith("()")) {
                    meth = meth.substring(0, meth.length() - 2);
                }
                methods.add(meth);
            }
            methodNames = new String[methods.size()];
            methodNames = methods.toArray(methodNames);
        }
        try {
            this.testClass = (ComplexTestCase)dcl.getInstance(className);
        }
        catch (IllegalArgumentException e) {
            System.out.println("Error while getting description for test '" + className + "' as a Complex test.");
            return null;
        }
        catch (ClassCastException e) {
            System.out.println("The given class '" + className + "' is not a Complex test.");
            return null;
        }
        if (debug) {
            System.out.println("Got test: " + this.testClass.toString());
        }
        String testObjectName = className;
        String[] testMethodNames = null;
        if (testMethodNames == null) {
            testMethodNames = this.testClass.getTestMethodNames();
        }
        if (methodNames != null) {
            testMethodNames = methodNames;
        }
        DescEntry dEntry = this.createTestDesc(testObjectName, className, testMethodNames, null);
        return dEntry;
    }

    public DescEntry createTestDesc(String testObjectName, String className, String[] testMethodNames, LogWriter log) {
        DescEntry dEntry = new DescEntry();
        dEntry.entryName = testObjectName;
        dEntry.longName = className;
        dEntry.isOptional = false;
        dEntry.EntryType = "unit";
        dEntry.isToTest = true;
        dEntry.Logger = log;
        dEntry.SubEntryCount = testMethodNames.length;
        dEntry.SubEntries = new DescEntry[dEntry.SubEntryCount];
        for (int i = 0; i < dEntry.SubEntryCount; ++i) {
            DescEntry aEntry = new DescEntry();
            aEntry.entryName = testMethodNames[i];
            aEntry.longName = testObjectName + "::" + aEntry.entryName;
            aEntry.isOptional = false;
            aEntry.EntryType = "method";
            aEntry.isToTest = true;
            dEntry.SubEntries[i] = aEntry;
            dEntry.Logger = log;
        }
        return dEntry;
    }

    @Override
    protected String[] createScenario(String descPath, String job, boolean debug) {
        return new String[0];
    }
}

