/*
 * Decompiled with CFR 0.152.
 */
package helper;

import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Properties;
import lib.TestParameters;

public class CfgParser {
    protected boolean debug = false;
    protected String iniFile = "";

    public CfgParser(String ini) {
        if (ini != null) {
            this.iniFile = ini;
        }
    }

    public void getIniParameters(TestParameters param) {
        this.debug = param.DebugIsActive;
        Properties cfg = null;
        if (this.iniFile.equals("")) {
            cfg = this.getProperties(this.getDefaultFileName(true));
            if (cfg == null) {
                cfg = this.getProperties(this.getDefaultFileName(false));
            }
        } else {
            cfg = this.getProperties(this.iniFile);
        }
        if (cfg != null) {
            Enumeration<Object> cfgEnum = cfg.keys();
            while (cfgEnum.hasMoreElements()) {
                String pName = (String)cfgEnum.nextElement();
                String pValue = cfg.getProperty(pName);
                if (pValue instanceof String) {
                    pValue = pValue.trim();
                }
                param.put(pName.trim(), pValue);
                if (pName.equals("TestDocumentPath")) {
                    param.put("DOCPTH", pValue);
                    System.setProperty("DOCPTH", pValue);
                    continue;
                }
                if (!pName.equals("SRC_ROOT")) continue;
                System.setProperty(pName, pValue);
            }
        }
        this.debug = param.DebugIsActive;
        String os = (String)param.get("OperatingSystem");
        if (os != null && os.length() > 1) {
            Enumeration keys = param.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!key.startsWith(os)) continue;
                Object oldValue = param.get(key);
                String newKey = key.substring(os.length() + 1);
                param.remove(key);
                param.put(newKey, oldValue);
            }
        }
    }

    protected Properties getProperties(String name) {
        Properties prop = new Properties();
        if (this.debug) {
            System.out.println("Looking for " + name);
        }
        try {
            FileInputStream propFile = new FileInputStream(name);
            prop.load(propFile);
            System.out.println("Parsing properties from " + name);
            propFile.close();
        }
        catch (Exception e) {
            try {
                URL url = this.getClass().getResource("/" + name);
                if (url != null) {
                    System.out.println("Parsing properties from " + name);
                    URLConnection connection = url.openConnection();
                    InputStream in = connection.getInputStream();
                    prop.load(in);
                }
            }
            catch (Exception ex) {
                return null;
            }
        }
        return prop;
    }

    protected String getDefaultFileName(boolean home) {
        String fileSeparator = System.getProperty("file.separator");
        String path = "";
        path = home ? System.getProperty("user.home") : System.getProperty("user.dir");
        if (fileSeparator.equals("/")) {
            return path + fileSeparator + ".runner.props";
        }
        return path + fileSeparator + "runner.props";
    }
}

