/*
 * Decompiled with CFR 0.152.
 */
package helper;

import helper.StringHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import share.DescEntry;
import share.DescGetter;
import util.dbg;

public class APIDescGetter
extends DescGetter {
    private static String fullJob = null;
    private static String entryType;

    @Override
    public DescEntry[] getDescriptionFor(String job, String descPath, boolean debug) {
        if (job.startsWith("-o")) {
            if ((job = job.substring(3, job.length()).trim()).indexOf(".") < 0) {
                return null;
            }
            if (job.indexOf(",") < 0) {
                DescEntry entry = this.getDescriptionForSingleJob(job, descPath, debug);
                if (entry != null) {
                    return new DescEntry[]{entry};
                }
                return null;
            }
            ArrayList subs = this.getSubInterfaces(job);
            String partjob = job.substring(0, job.indexOf(",")).trim();
            DescEntry entry = this.getDescriptionForSingleJob(partjob, descPath, debug);
            if (entry != null) {
                for (int i = 0; i < entry.SubEntryCount; ++i) {
                    String subEntry = entry.SubEntries[i].longName;
                    int cpLength = entry.longName.length();
                    if (!subs.contains(subEntry = subEntry.substring(cpLength + 2, subEntry.length()))) continue;
                    entry.SubEntries[i].isToTest = true;
                }
                return new DescEntry[]{entry};
            }
            return null;
        }
        if (job.startsWith("-p")) {
            String[] scenario = this.createScenario(descPath, job = job.substring(3, job.length()).trim(), debug);
            if (scenario == null) {
                return null;
            }
            DescEntry[] entries = new DescEntry[scenario.length];
            for (int i = 0; i < scenario.length; ++i) {
                entries[i] = this.getDescriptionForSingleJob(scenario[i].substring(3).trim(), descPath, debug);
            }
            if (job.equals("listall")) {
                dbg.printArray(scenario);
                System.exit(0);
            }
            return entries;
        }
        if (job.startsWith("-sce")) {
            File sceFile = new File(job = job.substring(5, job.length()).trim());
            if (sceFile.exists()) {
                return this.getScenario(job, descPath, debug);
            }
            ArrayList subs = this.getSubObjects(job);
            DescEntry[] entries = new DescEntry[subs.size()];
            for (int i = 0; i < subs.size(); ++i) {
                entries[i] = this.getDescriptionForSingleJob((String)subs.get(i), descPath, debug);
            }
            return entries;
        }
        return null;
    }

    @Override
    protected DescEntry getDescriptionForSingleJob(String job, String descPath, boolean debug) {
        boolean isSingleInterface = job.indexOf("::") > 0;
        fullJob = job;
        if (isSingleInterface) {
            job = job.substring(0, job.indexOf("::"));
        }
        if (job.startsWith("bugs")) {
            DescEntry Entry2 = new DescEntry();
            Entry2.entryName = job;
            Entry2.longName = job;
            Entry2.EntryType = "bugdoc";
            Entry2.isOptional = false;
            Entry2.isToTest = true;
            Entry2.SubEntryCount = 0;
            Entry2.hasErrorMsg = false;
            Entry2.State = "non possible";
            return Entry2;
        }
        DescEntry entry = null;
        if (descPath != null) {
            if (debug) {
                System.out.println("## reading from File " + descPath);
            }
            entry = APIDescGetter.getFromDirectory(descPath, job, debug);
        } else {
            if (debug) {
                System.out.println("## reading from jar");
            }
            entry = this.getFromClassPath(job, debug);
        }
        boolean foundInterface = false;
        if (isSingleInterface && entry != null) {
            for (int i = 0; i < entry.SubEntryCount; ++i) {
                if (!entry.SubEntries[i].longName.equals(fullJob)) {
                    entry.SubEntries[i].isToTest = false;
                    continue;
                }
                foundInterface = true;
                entry.SubEntries[i].isToTest = true;
            }
        }
        if (isSingleInterface && !foundInterface || entry == null) {
            return APIDescGetter.setErrorDescription(entry, "couldn't find a description for test '" + fullJob + "'");
        }
        return entry;
    }

    protected static DescEntry[] getSubEntries(BufferedReader cvsFile, DescEntry parent, boolean debug) {
        String line = "";
        String old_ifc_name = "";
        ArrayList<DescEntry> ifc_names = new ArrayList<DescEntry>();
        ArrayList<DescEntry> meth_names = new ArrayList<DescEntry>();
        DescEntry ifcDesc = null;
        while (line != null) {
            try {
                line = cvsFile.readLine();
                if (line == null || line.startsWith("#") || line.length() <= 0) continue;
                String ifc_name = "";
                String meth_name = "";
                StringTokenizer aToken = new StringTokenizer(line, ";");
                if (aToken.countTokens() < 3) {
                    System.out.println("Wrong format: Line '" + line + "' is not supported.");
                    continue;
                }
                if (aToken.hasMoreTokens()) {
                    String string = StringHelper.removeQuoteIfExists(aToken.nextToken());
                }
                if (aToken.hasMoreTokens()) {
                    ifc_name = StringHelper.removeQuoteIfExists(aToken.nextToken());
                }
                if (aToken.hasMoreTokens()) {
                    meth_name = StringHelper.removeQuoteIfExists(aToken.nextToken());
                }
                DescEntry methDesc = APIDescGetter.createDescEntry(meth_name, ifc_name, parent);
                if (!ifc_name.equals(old_ifc_name)) {
                    if (ifcDesc != null) {
                        ifcDesc.SubEntries = APIDescGetter.getDescArray(meth_names.toArray());
                        ifcDesc.SubEntryCount = meth_names.size();
                        boolean allOptional = true;
                        for (int k = 0; k < ifcDesc.SubEntryCount; ++k) {
                            if (ifcDesc.SubEntries[k].isOptional) continue;
                            allOptional = false;
                        }
                        if (!ifcDesc.isOptional && allOptional) {
                            ifcDesc.isOptional = allOptional;
                        }
                        meth_names.clear();
                        ifc_names.add(ifcDesc);
                    }
                    ifcDesc = new DescEntry();
                    ifcDesc.isToTest = true;
                    old_ifc_name = ifc_name;
                    if (ifc_name.indexOf("#optional") > 0) {
                        ifcDesc.isOptional = true;
                        ifc_name = ifc_name.substring(0, ifc_name.indexOf("#"));
                    }
                    String className = APIDescGetter.createClassName(ifc_name);
                    ifcDesc.EntryType = entryType;
                    ifcDesc.entryName = "ifc" + className;
                    ifcDesc.longName = parent.entryName + "::" + ifc_name;
                }
                meth_names.add(methDesc);
            }
            catch (IOException ioe) {
                parent.hasErrorMsg = true;
                parent.ErrorMsg = "IOException while reading the description";
                return null;
            }
        }
        ifcDesc.SubEntries = APIDescGetter.getDescArray(meth_names.toArray());
        ifcDesc.SubEntryCount = meth_names.size();
        boolean allOptional = true;
        for (int k = 0; k < ifcDesc.SubEntryCount; ++k) {
            if (ifcDesc.SubEntries[k].isOptional) continue;
            allOptional = false;
        }
        if (!ifcDesc.isOptional && allOptional) {
            ifcDesc.isOptional = allOptional;
        }
        ifc_names.add(ifcDesc);
        return APIDescGetter.getDescArray(APIDescGetter.makeArray(ifc_names));
    }

    private static String createClassName(String _ifc_name) {
        StringTokenizer st = new StringTokenizer(_ifc_name, ":");
        String className = "";
        int count = 3;
        if (_ifc_name.startsWith("drafts")) {
            count = 4;
        }
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (i >= count) {
                if (!st.hasMoreTokens()) {
                    token = "_" + token;
                }
                className = className + "." + token;
            }
            ++i;
        }
        return className;
    }

    private static DescEntry createDescEntry(String meth_name, String ifc_name, DescEntry parent) {
        entryType = "service";
        DescEntry methDesc = new DescEntry();
        if (meth_name.indexOf("#optional") > 0) {
            methDesc.isOptional = true;
            meth_name = meth_name.substring(0, meth_name.indexOf("#"));
        }
        if (meth_name.endsWith("()")) {
            methDesc.EntryType = "method";
            entryType = "interface";
        } else {
            methDesc.EntryType = "property";
            entryType = "service";
        }
        methDesc.entryName = meth_name;
        methDesc.isToTest = true;
        String withoutHash = ifc_name;
        if (ifc_name.indexOf("#optional") > 0) {
            withoutHash = ifc_name.substring(0, ifc_name.indexOf("#"));
        }
        methDesc.longName = parent.entryName + "::" + withoutHash + "::" + meth_name;
        return methDesc;
    }

    private static void createIfcName(String ifc_name, ArrayList meth_names, DescEntry ifcDesc) {
    }

    protected static Object[] makeArray(ArrayList entries) {
        Object[] entriesArray = entries.toArray();
        ArrayList<DescEntry> returnArray = new ArrayList<DescEntry>();
        DescEntry addAtEnd = null;
        for (int k = 0; k < entriesArray.length; ++k) {
            DescEntry entry = (DescEntry)entriesArray[k];
            if (entry.entryName.equals("ifc.lang._XComponent")) {
                addAtEnd = entry;
                continue;
            }
            returnArray.add(entry);
        }
        if (addAtEnd != null) {
            returnArray.add(addAtEnd);
        }
        return returnArray.toArray();
    }

    protected static DescEntry setErrorDescription(DescEntry entry, String ErrorMsg) {
        if (entry == null) {
            entry = new DescEntry();
        }
        entry.hasErrorMsg = true;
        entry.ErrorMsg = "Error while getting description for test '" + fullJob + "' as an API test: " + ErrorMsg;
        return entry;
    }

    protected static DescEntry[] getDescArray(Object[] list) {
        DescEntry[] entries = new DescEntry[list.length];
        for (int i = 0; i < list.length; ++i) {
            entries[i] = (DescEntry)list[i];
        }
        return entries;
    }

    protected DescEntry getFromClassPath(String aEntry, boolean debug) {
        BufferedReader csvFile;
        DescEntry theEntry;
        block10: {
            int dotindex = aEntry.indexOf(46);
            if (dotindex == -1) {
                return null;
            }
            String module = null;
            String shortName = null;
            if (aEntry.indexOf(".uno") == -1) {
                module = aEntry.substring(0, aEntry.indexOf(46));
                shortName = aEntry.substring(aEntry.indexOf(46) + 1);
            } else {
                module = aEntry.substring(0, aEntry.lastIndexOf(46));
                shortName = aEntry.substring(aEntry.lastIndexOf(46) + 1);
            }
            theEntry = new DescEntry();
            theEntry.entryName = aEntry;
            theEntry.longName = aEntry;
            theEntry.isOptional = false;
            theEntry.EntryType = "component";
            theEntry.isToTest = true;
            csvFile = null;
            URL url = this.getClass().getResource("/objdsc/" + module);
            if (url == null) {
                return APIDescGetter.setErrorDescription(theEntry, "couldn't find module '" + module + "'");
            }
            try {
                URLConnection con = url.openConnection();
                String sEndsWithCSVName = "." + shortName.trim() + ".csv";
                if (con instanceof JarURLConnection) {
                    JarFile f = ((JarURLConnection)con).getJarFile();
                    Enumeration<JarEntry> e = f.entries();
                    String sStartModule = "/" + module + "/";
                    while (e.hasMoreElements()) {
                        String entry = ((Object)e.nextElement()).toString();
                        if (entry.lastIndexOf(sStartModule) == -1 || !entry.endsWith(sEndsWithCSVName)) continue;
                        InputStream input = this.getClass().getResourceAsStream("/" + entry);
                        csvFile = new BufferedReader(new InputStreamReader(input));
                        break block10;
                    }
                    break block10;
                }
                InputStream in = con.getInputStream();
                BufferedReader buf = new BufferedReader(new InputStreamReader(in));
                boolean found = false;
                while (buf.ready() && !found) {
                    String entry = buf.readLine();
                    if (!entry.endsWith(sEndsWithCSVName)) continue;
                    System.out.println("FOUND  ####");
                    InputStream input = this.getClass().getResourceAsStream("/objdsc/" + module + "/" + entry);
                    csvFile = new BufferedReader(new InputStreamReader(input));
                    found = true;
                }
                buf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (csvFile == null) {
            return APIDescGetter.setErrorDescription(theEntry, "couldn't find component '" + theEntry.entryName + "'");
        }
        DescEntry[] subEntries = APIDescGetter.getSubEntries(csvFile, theEntry, debug);
        theEntry.SubEntryCount = subEntries.length;
        theEntry.SubEntries = subEntries;
        return theEntry;
    }

    protected static DescEntry getFromDirectory(String descPath, String entry, boolean debug) {
        File modPath;
        int dotindex = entry.indexOf(46);
        if (dotindex == -1) {
            return null;
        }
        String fs = System.getProperty("file.separator");
        String module = null;
        String shortName = null;
        if (entry.indexOf(".uno") == -1) {
            module = entry.substring(0, entry.indexOf(46));
            shortName = entry.substring(entry.indexOf(46) + 1);
        } else {
            module = entry.substring(0, entry.lastIndexOf(46));
            shortName = entry.substring(entry.lastIndexOf(46) + 1);
        }
        DescEntry aEntry = new DescEntry();
        aEntry.entryName = entry;
        aEntry.longName = entry;
        aEntry.isOptional = false;
        aEntry.EntryType = "component";
        aEntry.isToTest = true;
        if (debug) {
            System.out.println("Parsing Description Path: " + descPath);
            System.out.println("Searching module: " + module);
            System.out.println("For the Component " + shortName);
        }
        if (!(modPath = new File(descPath + fs + module)).exists()) {
            return APIDescGetter.setErrorDescription(aEntry, "couldn't find module '" + module + "'");
        }
        String[] files = modPath.list();
        String found = "none";
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].endsWith("." + shortName + ".csv")) continue;
            found = files[i];
            System.out.println("found " + found);
            break;
        }
        if (found.equals("none")) {
            return APIDescGetter.setErrorDescription(aEntry, "couldn't find component '" + entry + "'");
        }
        String aUrl = descPath + fs + module + fs + found;
        BufferedReader csvFile = null;
        try {
            csvFile = new BufferedReader(new FileReader(aUrl));
        }
        catch (FileNotFoundException fnfe) {
            return APIDescGetter.setErrorDescription(aEntry, "couldn't find file '" + aUrl + "'");
        }
        DescEntry[] subEntries = APIDescGetter.getSubEntries(csvFile, aEntry, debug);
        aEntry.SubEntryCount = subEntries.length;
        aEntry.SubEntries = subEntries;
        return aEntry;
    }

    @Override
    protected ArrayList getSubInterfaces(String job) {
        ArrayList<String> namesList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(job, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.indexOf(".") < 0) {
                namesList.add(token);
            }
            ++i;
        }
        return namesList;
    }

    protected ArrayList getSubObjects(String job) {
        ArrayList<String> namesList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(job, ",");
        int i = 0;
        while (st.hasMoreTokens()) {
            namesList.add(st.nextToken());
            ++i;
        }
        return namesList;
    }

    @Override
    protected String[] createScenario(String descPath, String job, boolean debug) {
        String[] scenario = null;
        if (descPath != null) {
            if (debug) {
                System.out.println("## reading from File " + descPath);
            }
            scenario = this.getScenarioFromDirectory(descPath, job, debug);
        } else {
            if (debug) {
                System.out.println("## reading from jar");
            }
            scenario = this.getScenarioFromClassPath(job, debug);
        }
        return scenario;
    }

    protected String[] getScenarioFromDirectory(String descPath, String job, boolean debug) {
        File dirs;
        String[] modules = null;
        ArrayList<String> componentList = new ArrayList<String>();
        modules = !job.equals("unknown") && !job.equals("listall") ? new String[]{job} : (!(dirs = new File(descPath)).exists() ? null : dirs.list());
        for (int i = 0; i < modules.length; ++i) {
            File moduleDir;
            if (this.isUnusedModule(modules[i]) || !(moduleDir = new File(descPath + System.getProperty("file.separator") + modules[i])).exists()) continue;
            String[] components = moduleDir.list();
            for (int j = 0; j < components.length; ++j) {
                if (!components[j].endsWith(".csv")) continue;
                String toAdd = this.getComponentForString(components[j], modules[i]);
                toAdd = "-o " + modules[i] + "." + toAdd;
                componentList.add(toAdd);
            }
        }
        String[] scenario = new String[componentList.size()];
        Collections.sort(componentList);
        for (int i = 0; i < componentList.size(); ++i) {
            scenario[i] = (String)componentList.get(i);
        }
        return scenario;
    }

    protected String[] getScenarioFromClassPath(String job, boolean debug) {
        URL url;
        String subdir = "/";
        if (!job.equals("unknown") && !job.equals("listall")) {
            subdir = subdir + job;
        }
        if ((url = this.getClass().getResource("/objdsc" + subdir)) == null) {
            return null;
        }
        ArrayList<String> scenarioList = new ArrayList<String>();
        try {
            URLConnection con = url.openConnection();
            if (con instanceof JarURLConnection) {
                JarFile f = ((JarURLConnection)con).getJarFile();
                Enumeration<JarEntry> e = f.entries();
                while (e.hasMoreElements()) {
                    String entry = ((Object)e.nextElement()).toString();
                    if (!entry.startsWith("objdsc" + subdir) || entry.indexOf("CVS") >= 0 || entry.endsWith("/")) continue;
                    int startMod = entry.indexOf("/");
                    int endMod = entry.lastIndexOf("/");
                    String module = entry.substring(startMod + 1, endMod);
                    String component = this.getComponentForString(entry.substring(endMod + 1, entry.length()), module);
                    if (this.isUnusedModule(module)) continue;
                    scenarioList.add("-o " + module + "." + component);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] scenario = new String[scenarioList.size()];
        Collections.sort(scenarioList);
        for (int i = 0; i < scenarioList.size(); ++i) {
            scenario[i] = (String)scenarioList.get(i);
        }
        return scenario;
    }

    protected String getComponentForString(String full, String module) {
        String component = "";
        full = full.substring(0, full.length() - 4);
        int lastdot = full.lastIndexOf(".");
        component = full.substring(lastdot + 1, full.length());
        if (module.equals("file") || module.equals("xmloff")) {
            String withoutComponent = full.substring(0, lastdot);
            int preLastDot = withoutComponent.lastIndexOf(".");
            component = withoutComponent.substring(preLastDot + 1, withoutComponent.length()) + "." + component;
        }
        return component;
    }

    protected boolean isUnusedModule(String moduleName) {
        ArrayList<String> removed = new ArrayList<String>();
        removed.add("acceptor");
        removed.add("brdgfctr");
        removed.add("connectr");
        removed.add("corefl");
        removed.add("cpld");
        removed.add("defreg");
        removed.add("dynamicloader");
        removed.add("impreg");
        removed.add("insp");
        removed.add("inv");
        removed.add("invadp");
        removed.add("javaloader");
        removed.add("jen");
        removed.add("namingservice");
        removed.add("proxyfac");
        removed.add("rdbtdp");
        removed.add("remotebridge");
        removed.add("simreg");
        removed.add("smgr");
        removed.add("stm");
        removed.add("tcv");
        removed.add("tdmgr");
        removed.add("ucprmt");
        removed.add("uuresolver");
        return removed.contains(moduleName);
    }
}

