/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.FileHelper;
import graphical.IOffice;
import graphical.IniFile;
import graphical.MSOfficePostscriptCreator;
import graphical.OfficeException;
import graphical.OpenOfficeDatabaseReportExtractor;
import graphical.OpenOfficePostscriptCreator;
import graphical.ParameterHelper;
import java.util.ArrayList;

public class Office
implements IOffice {
    private ParameterHelper m_aParameterHelper;
    private String m_sDocumentName;
    private String m_sResult;
    private IOffice m_aOffice = null;

    public Office(ParameterHelper _aParam, String _sResult) {
        this.m_aParameterHelper = _aParam;
        this.m_sResult = _sResult;
        if (_aParam.getReferenceType().toLowerCase().equals("ooo") || _aParam.getReferenceType().toLowerCase().equals("pdf")) {
            this.m_aOffice = new OpenOfficePostscriptCreator(_aParam, this.m_sResult);
        } else if (_aParam.getReferenceType().toLowerCase().equals("msoffice")) {
            this.m_aOffice = new MSOfficePostscriptCreator(_aParam, this.m_sResult);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void load(String _sDocumentName) throws OfficeException {
        this.m_sDocumentName = _sDocumentName;
        String sDocumentSuffix = FileHelper.getSuffix(this.m_sDocumentName);
        if (sDocumentSuffix.toLowerCase().endsWith(".png") || sDocumentSuffix.toLowerCase().endsWith(".gif") || sDocumentSuffix.toLowerCase().endsWith(".jpg") || sDocumentSuffix.toLowerCase().endsWith(".bmp")) {
            throw new OfficeException("The given document is not a document type.");
        }
        if (this.m_aOffice == null) return;
        if (sDocumentSuffix.toLowerCase().endsWith(".odb")) {
            if (this.m_aParameterHelper.getReferenceType().toLowerCase().equals("msoffice")) {
                return;
            }
            OpenOfficeDatabaseReportExtractor aExtractor = new OpenOfficeDatabaseReportExtractor(this.m_aParameterHelper);
            ArrayList aList = aExtractor.load(this.m_sDocumentName);
            if (aList == null) throw new OfficeException("Can't open the document " + this.m_sDocumentName);
            String sIniFile = FileHelper.appendPath(this.m_sResult, "index.ini");
            IniFile aIniFile2 = new IniFile(sIniFile);
            String sSection = FileHelper.getBasename(_sDocumentName);
            aIniFile2.removeSection(sSection);
            aIniFile2.close();
            for (int i = 0; i < aList.size(); ++i) {
                String sDocumentName = (String)aList.get(i);
                this.m_aOffice.load(sDocumentName);
                this.m_aOffice.storeAsPostscript();
                IniFile aIniFile = new IniFile(sIniFile);
                int nFileCount = aIniFile.getIntValue(sSection, "reportcount", 0);
                String sValue = FileHelper.getBasename(sDocumentName);
                aIniFile.insertValue(sSection, "report" + nFileCount, sValue);
                aIniFile.insertValue(sSection, "reportcount", nFileCount + 1);
                aIniFile.close();
            }
            return;
        } else {
            this.m_aOffice.load(_sDocumentName);
        }
    }

    @Override
    public void storeAsPostscript() throws OfficeException {
        if (this.m_aOffice != null && !this.m_sDocumentName.endsWith(".odb")) {
            this.m_aOffice.storeAsPostscript();
        }
    }

    @Override
    public void start() throws OfficeException {
        if (this.m_aOffice != null) {
            this.m_aOffice.start();
        }
    }

    @Override
    public void close() throws OfficeException {
        if (this.m_aOffice != null) {
            this.m_aOffice.close();
        }
    }
}

