/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.EnhancedComplexTestCase;
import graphical.FileHelper;
import graphical.GlobalLogWriter;
import graphical.IniFile;
import graphical.OfficeException;
import graphical.ParameterHelper;
import helper.OSHelper;
import helper.ProcessHandler;
import helper.StringHelper;
import java.io.File;
import org.openoffice.Runner;
import util.utils;

public class JPEGCreator
extends EnhancedComplexTestCase {
    private static final String m_sGS_PageOutput = "%04d";

    @Override
    public String[] getTestMethodNames() {
        return new String[]{"PostscriptOrPDFToJPEG"};
    }

    public void PostscriptOrPDFToJPEG() {
        GlobalLogWriter.set(log);
        ParameterHelper aParam = new ParameterHelper(param);
        this.foreachPSorPDFinInputPath(aParam);
    }

    @Override
    public void checkOneFile(String _sDocumentName, String _sResult, ParameterHelper _aParams) throws OfficeException {
        GlobalLogWriter.println("Document: " + _sDocumentName + " results: " + _sResult);
        String sJPEGNameSchema = this.createJPEG(_sDocumentName, "", _aParams);
        int nPages = this.countPages(sJPEGNameSchema);
        if (nPages > 0) {
            this.createSmallPictures(sJPEGNameSchema);
            String sIndexFile = FileHelper.appendPath(_sResult, "index.ini");
            File aIndexFile = new File(sIndexFile);
            if (aIndexFile.exists()) {
                IniFile aIniFile = new IniFile(sIndexFile);
                String sBasename = FileHelper.getBasename(_sDocumentName);
                aIniFile.insertValue(sBasename, "jpegschema", sJPEGNameSchema);
                aIniFile.insertValue(sBasename, "pages", nPages);
                aIniFile.close();
            }
        }
    }

    public void createSmallPictures(String _sJPEGSchema) {
        int nPages = 0;
        if (_sJPEGSchema.length() > 0) {
            String sJPEGFilename;
            for (int i = 1; i < 10000 && FileHelper.exists(sJPEGFilename = JPEGCreator.getFilenameForJPEGSchema(_sJPEGSchema, i)); ++i) {
                JPEGCreator.convertToNearSameFileWithWidth340(sJPEGFilename);
                ++nPages;
            }
        }
    }

    public static void convertToNearSameFileWithWidth340(String _sJPEGFilename) {
        String sNewJPEGFilename = utils.replaceAll13(_sJPEGFilename, ".jpg", "_w340.jpg");
        JPEGCreator.convertToWidth340(_sJPEGFilename, sNewJPEGFilename);
    }

    private static void convertToWidth340(String _sFrom, String _To) {
        String sConvertEXE = "convert";
        if (OSHelper.isLinuxIntel()) {
            sConvertEXE = "convert";
        }
        if (OSHelper.isWindows()) {
            sConvertEXE = "convert.exe";
        }
        String[] sCommandArray = new String[]{sConvertEXE, _sFrom, "-filter", "Catrom", "-resize", "340x", _To};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        int nExitCode = aHandler.getExitCode();
        String sBack = aHandler.getOutputText();
        if (sBack.length() > 0) {
            GlobalLogWriter.get().println("'" + sBack + "'");
        }
    }

    String createJPEG(String _sFile, String _sAdditional, ParameterHelper _aParam) {
        File aFile;
        if (_sFile.startsWith("file:///")) {
            _sFile = FileHelper.getSystemPathFromFileURL(_sFile);
        }
        if ((aFile = new File(_sFile)).exists()) {
            String sAbsFile = aFile.getAbsolutePath();
            if (!sAbsFile.equals(_sFile)) {
                _sFile = sAbsFile;
            }
        } else {
            GlobalLogWriter.get().println("File: '" + _sFile + "' doesn't exist.");
            return "";
        }
        String sFileDir = FileHelper.getPath(_sFile);
        String sBasename = FileHelper.getBasename(_sFile);
        String sTmpDir = utils.getUsersTempDir();
        if (_aParam.getOutputPath() != null) {
            sTmpDir = _aParam.getOutputPath();
        }
        String sJPEGNameSchema = "";
        if (_sFile.toLowerCase().endsWith("ps") || _sFile.toLowerCase().endsWith("prn") || _sFile.toLowerCase().endsWith("pdf")) {
            sJPEGNameSchema = this.createJPEGsFromPostscript(sTmpDir, sFileDir, sBasename, _aParam.getResolutionInDPI());
        } else if (_sFile.toLowerCase().endsWith("jpg") || _sFile.toLowerCase().endsWith("jpeg")) {
            return _sFile;
        }
        return sJPEGNameSchema;
    }

    private String getJPEGName(String _sOutputPath, String _sBasename, int _nResolutionInDPI, String _sGS_PageOutput) {
        String sName = _sBasename + "_" + String.valueOf(_nResolutionInDPI) + "DPI_" + _sGS_PageOutput + ".jpg";
        String sJPEGName = FileHelper.appendPath(_sOutputPath, sName);
        return sJPEGName;
    }

    private String createJPEGsFromPostscript(String _sOutputPath, String _sSourcePath, String _sSourceFile, int _nResolutionInDPI) {
        FileHelper.makeDirectories("", _sOutputPath);
        String sJPEGNameSchema = this.getJPEGName(_sOutputPath, _sSourceFile, _nResolutionInDPI, m_sGS_PageOutput);
        String sPostscriptOrPDFFile = FileHelper.appendPath(_sSourcePath, _sSourceFile);
        String sGhostscriptEXE = "gs";
        if (OSHelper.isWindows()) {
            sGhostscriptEXE = "gswin32c.exe";
        }
        String[] sCommandArray = new String[]{sGhostscriptEXE, "-dNOPROMPT", "-dBATCH", "-sDEVICE=jpeg", "-r" + String.valueOf(_nResolutionInDPI), "-dNOPAUSE", "-sOutputFile=" + sJPEGNameSchema, sPostscriptOrPDFFile};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        this.assure("There seems to be a problem with ghostscript", bBackValue, true);
        int nExitCode = aHandler.getExitCode();
        if (nExitCode == 0) {
            int nPages = this.countPages(sJPEGNameSchema);
            if (nPages == 0) {
                sJPEGNameSchema = "";
            }
        } else {
            this.assure("There seems to be a problem with ghostscript and '" + sPostscriptOrPDFFile + "' exit code: " + nExitCode, false, true);
            GlobalLogWriter.println("Warning: There seems to be a problem with '" + sGhostscriptEXE + "'...");
        }
        return sJPEGNameSchema;
    }

    public static String getFilenameForJPEGSchema(String _sJPEGSchema, int _nPage) {
        if (_nPage < 1 || _nPage > 9999) {
            return "";
        }
        String sFilename = utils.replaceAll13(_sJPEGSchema, m_sGS_PageOutput, StringHelper.createValueString(_nPage, 4));
        return sFilename;
    }

    public int countPages(String _sJPEGSchema) {
        int nPages = 0;
        if (_sJPEGSchema.length() > 0) {
            String sNewJPEGFilename;
            for (int i = 1; i < 10000 && FileHelper.exists(sNewJPEGFilename = JPEGCreator.getFilenameForJPEGSchema(_sJPEGSchema, i)); ++i) {
                ++nPages;
            }
        }
        return nPages;
    }

    public static void main(String[] _args) {
        String[] args = new String[]{"-TimeOut", "3600000", "-tb", "java_complex", "-o", "graphical.JPEGCreator", "-DOC_COMPARATOR_INPUT_PATH", "C:\\CWS\\temp\\output\\Names7.odt.pdf", "-DOC_COMPARATOR_OUTPUT_PATH", "C:\\CWS\\temp\\output", "-DOC_COMPARATOR_PRINT_MAX_PAGE", "9999", "-DOC_COMPARATOR_GFX_OUTPUT_DPI_RESOLUTION", "180", "-DOC_COMPARATOR_HTML_OUTPUT_PREFIX", "http://so-gfxcmp-lin.germany.sun.com/gfxcmp_ui/cw.php?inifile=", "-AppExecutionCommand", "\"C:/Programme/sun/staroffice 9/program/soffice.exe\"  -norestore -nocrashreport -accept=pipe,name=ll93751;urp;", "-NoOffice"};
        Runner.main(args);
    }
}

