/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.EnhancedComplexTestCase;
import graphical.FileHelper;
import graphical.GlobalLogWriter;
import graphical.IniFile;
import graphical.JPEGCreator;
import graphical.NameDPIPage;
import graphical.OfficeException;
import graphical.ParameterHelper;
import graphical.PixelCounter;
import helper.OSHelper;
import helper.ProcessHandler;
import java.io.File;
import java.io.IOException;
import org.openoffice.Runner;

public class JPEGComparator
extends EnhancedComplexTestCase {
    @Override
    public String[] getTestMethodNames() {
        return new String[]{"CompareJPEGvsJPEG"};
    }

    public void CompareJPEGvsJPEG() {
        GlobalLogWriter.set(log);
        ParameterHelper aParam = new ParameterHelper(param);
        this.foreachJPEGcompareWithJPEG(aParam);
    }

    @Override
    public void checkOneFile(String _sDocumentName, String _sResult, ParameterHelper _aParams) throws OfficeException {
        String sPath = FileHelper.getPath(_sDocumentName);
        String sSectionName = FileHelper.getBasename(_sDocumentName);
        String sIniFileForRefBuildID = FileHelper.appendPath(sPath, sSectionName + ".ini");
        IniFile aIniFileForRefBuildID = new IniFile(sIniFileForRefBuildID);
        String sRefBuildID = aIniFileForRefBuildID.getValue("global", "buildid");
        aIniFileForRefBuildID.close();
        _aParams.getTestParameters().put("RefBuildId", sRefBuildID);
        String sIniFile = FileHelper.appendPath(sPath, "index.ini");
        IniFile aIniFile = new IniFile(sIniFile);
        if (aIniFile.hasValue(sSectionName, "pages")) {
            int nPages = aIniFile.getIntValue(sSectionName, "pages", 0);
            String sJPEGSchema = aIniFile.getValue(sSectionName, "jpegschema");
            for (int i = 1; i <= nPages; ++i) {
                String sJPEGFilename = JPEGCreator.getFilenameForJPEGSchema(sJPEGSchema, i);
                String sJPEGPath = FileHelper.getPath(sJPEGFilename);
                if (!sPath.equals(sJPEGPath)) {
                    GlobalLogWriter.println("Path where to find the index and where to file the JPEG pictures are not the same.");
                }
                File aFile = new File(sJPEGFilename);
                this.assure("File '" + sJPEGFilename + "' doesn't exists.", aFile.exists(), true);
                if (!aFile.exists()) continue;
                GlobalLogWriter.println("Page: " + i);
                this.checkOnePicture(sJPEGFilename, _sResult, _aParams);
            }
        } else {
            GlobalLogWriter.println("The document '" + sSectionName + "' seems to have no picture representation.");
        }
        String sResultIniFile = FileHelper.appendPath(_sResult, sSectionName);
        this.evaluateResult(sResultIniFile, _aParams);
    }

    private void evaluateResult(String _sDocument, ParameterHelper _aParams) {
        String sResultIniFile = _sDocument + ".ini";
        File aFile = new File(sResultIniFile);
        this.assure("Result file doesn't exists " + sResultIniFile, aFile.exists());
        int good = 0;
        int bad = 0;
        int ugly = 0;
        int ok_status = 1;
        IniFile aResultIniFile = new IniFile(sResultIniFile);
        int nPages = aResultIniFile.getIntValue("global", "pages", 0);
        for (int i = 0; i < nPages; ++i) {
            String sCurrentPage = "page" + String.valueOf(i + 1);
            int nPercent = aResultIniFile.getIntValue(sCurrentPage, "percent", -1);
            if (nPercent == 0) {
                ++good;
                continue;
            }
            if (nPercent <= 5) {
                ++bad;
                ok_status = 2;
                continue;
            }
            ++ugly;
            ok_status = 3;
        }
        this.assure("Error: document doesn't contains pages", nPages > 0);
        String sStatusRunThrough = "PASSED, ";
        String sPassed = "OK";
        String sStatusMessage = "From " + nPages + " page(s) are: ";
        String sGood = "";
        String sBad = "";
        String sUgly = "";
        if (good > 0) {
            sGood = " good:=" + good;
            sStatusMessage = sStatusMessage + sGood;
        }
        if (bad > 0) {
            sBad = " bad:=" + bad;
            sStatusMessage = sStatusMessage + sBad;
        }
        if (ugly > 0) {
            sUgly = " ugly:=" + ugly;
            sStatusMessage = sStatusMessage + sUgly;
        }
        sPassed = ugly > 0 ? "FAILED" : (bad > 0 ? "NEED A LOOK" : "OK");
        sStatusRunThrough = sStatusRunThrough + sPassed;
        aResultIniFile.insertValue("global", "state", sStatusRunThrough);
        aResultIniFile.insertValue("global", "info", sStatusMessage);
        aResultIniFile.close();
        _aParams.getTestParameters().put("current_state", sStatusRunThrough);
        _aParams.getTestParameters().put("current_info", sStatusMessage);
        _aParams.getTestParameters().put("current_ok_status", (Object)ok_status);
    }

    private void checkOnePicture(String _sDocumentName, String _sResult, ParameterHelper _aParams) {
        GlobalLogWriter.println("JPEG: Compare difference between '" + _sDocumentName + "'  and '" + _sResult + "'");
        File aResultFile = new File(_sResult);
        if (aResultFile.isDirectory()) {
            String sBasename = FileHelper.getBasename(_sDocumentName);
            String sResultFilename = FileHelper.appendPath(_sResult, sBasename);
            aResultFile = new File(sResultFilename);
            if (aResultFile.exists()) {
                String sInputPath = _aParams.getInputPath();
                if (sInputPath.toLowerCase().endsWith("index.ini")) {
                    // empty if block
                }
                this.compareJPEG(_sDocumentName, sResultFilename, _aParams);
            } else {
                GlobalLogWriter.println("Warning: Result JPEG doesn't exists '" + sResultFilename + "'");
            }
        } else if (aResultFile.exists()) {
            this.compareJPEG(_sDocumentName, _sResult, _aParams);
        } else {
            GlobalLogWriter.println("Warning: Result JPEG doesn't exists '" + _sResult + "'");
        }
    }

    private void compareJPEG(String _sDocumentName, String _sResult, ParameterHelper _aParams) {
        String sDifference;
        String sDestination;
        String sSource;
        NameDPIPage aNameDPIPage = NameDPIPage.interpret(_sDocumentName);
        String sSourceBasename = FileHelper.getBasename(_sDocumentName);
        String sSourcePath = FileHelper.getPath(_sDocumentName);
        String sDestinationBasename = FileHelper.getBasename(_sResult);
        String sDestinationPath = FileHelper.getPath(_sResult);
        if (!sSourcePath.equals(sDestinationPath)) {
            String sNewSourceBasename = "Original_" + sSourceBasename;
            sSource = _sDocumentName;
            sDestination = FileHelper.appendPath(sDestinationPath, sNewSourceBasename);
            FileHelper.copy(sSource, sDestination);
            sSourceBasename = sNewSourceBasename;
        }
        String sDifferenceBasename = "Difference_between_" + FileHelper.getNameNoSuffix(sSourceBasename) + "_and_" + FileHelper.getNameNoSuffix(sDestinationBasename) + ".jpg";
        sSource = FileHelper.appendPath(sDestinationPath, sSourceBasename);
        int nErr = JPEGComparator.compareJPEG(sSource, sDestination = FileHelper.appendPath(sDestinationPath, sDestinationBasename), sDifference = FileHelper.appendPath(sDestinationPath, sDifferenceBasename));
        if (nErr == 0 && FileHelper.exists(sDifference)) {
            int nResult = this.identify(sDifference);
            int nPercentColorDiffer = 0;
            String sResult = "NO";
            if (nResult != 1) {
                try {
                    nPercentColorDiffer = JPEGComparator.estimateGfx(sSource, sDestination, sDifference);
                }
                catch (IOException e) {
                    GlobalLogWriter.println("Can't estimate the different colors. " + e.getMessage());
                }
            } else {
                sResult = "YES";
            }
            String sResultFile = FileHelper.appendPath(sDestinationPath, aNameDPIPage.Name + ".ini");
            int nPage = aNameDPIPage.Page;
            if (nPage < 0) {
                nPage = 0;
            }
            IniFile aResultIni = new IniFile(sResultFile);
            String[] aComment = new String[]{"; This file is automatically created by a graphical.JPEGComparator run", "; ", "; If you see this file in a browser you may have forgotten to set the follows in the property file", "; DOC_COMPARATOR_HTML_OUTPUT_PREFIX=http://<computer>/gfxcmp_ui/cw.php?inifile=", "; Please check the documentation if you got confused.", "; ", "; "};
            aResultIni.insertFirstComment(aComment);
            int nMaxPage = Math.max(nPage, aResultIni.getIntValue("global", "pages", 0));
            aResultIni.insertValue("global", "pages", nMaxPage);
            String sRefBuildId = (String)_aParams.getTestParameters().get("RefBuildId");
            if (sRefBuildId == null) {
                sRefBuildId = "";
            }
            aResultIni.insertValue("global", "refbuildid", sRefBuildId);
            aResultIni.insertValue("global", "diffdiff", "no");
            aResultIni.insertValue("global", "basename", aNameDPIPage.Name);
            aResultIni.insertValue("global", "dpi", aNameDPIPage.DPI);
            String sSection = "page" + String.valueOf(nPage);
            aResultIni.insertValue(sSection, "oldgfx", sSource);
            aResultIni.insertValue(sSection, "newgfx", sDestination);
            aResultIni.insertValue(sSection, "diffgfx", sDifference);
            aResultIni.insertValue(sSection, "percent", nPercentColorDiffer);
            aResultIni.insertValue(sSection, "BM", "false");
            aResultIni.insertValue(sSection, "result", sResult);
            aResultIni.close();
        }
    }

    public static int estimateGfx(String _sOldGfx, String _sNewGfx, String _sDiffGfx) throws IOException {
        int nNotWhiteCount_OldGraphic = PixelCounter.countNotWhitePixelsFromImage(_sOldGfx);
        int nNotWhiteCount_NewGraphic = PixelCounter.countNotWhitePixelsFromImage(_sNewGfx);
        int nNotBlackCount_DiffGraphic = PixelCounter.countNotBlackPixelsFromImage(_sDiffGfx);
        int nMinNotWhiteCount = Math.min(nNotWhiteCount_NewGraphic, nNotWhiteCount_OldGraphic);
        if (nMinNotWhiteCount == 0 && (nMinNotWhiteCount = Math.max(nNotWhiteCount_NewGraphic, nNotWhiteCount_OldGraphic)) == 0) {
            nMinNotWhiteCount = 1;
        }
        int nPercent = Math.abs(nNotBlackCount_DiffGraphic * 100 / nMinNotWhiteCount);
        GlobalLogWriter.get().println("Graphics check, pixel based:" + String.valueOf(nPercent) + "% pixel differ ");
        return nPercent;
    }

    private static int compareJPEG(String _sOldGfx, String _sNewGfx, String _sDiffGfx) {
        String sComposite = "composite";
        if (OSHelper.isWindows()) {
            sComposite = "composite.exe";
        }
        String[] sCommandArray = new String[]{sComposite, "-compose", "difference", _sOldGfx, _sNewGfx, _sDiffGfx};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        int nExitCode = aHandler.getExitCode();
        if (nExitCode != 0) {
            GlobalLogWriter.println("'" + sComposite + "' return with ");
            String sBack = aHandler.getOutputText();
            GlobalLogWriter.get().println("'" + sBack + "'");
        } else {
            File aDiffFile = new File(_sDiffGfx);
            if (aDiffFile.exists()) {
                JPEGCreator.convertToNearSameFileWithWidth340(_sDiffGfx);
            }
        }
        return nExitCode;
    }

    int identify(String _sDiffGfx) {
        int nResult = 0;
        String sIM_Format = "%k";
        String sIdentify = "identify";
        if (OSHelper.isWindows()) {
            sIdentify = "identify.exe";
        }
        String[] sCommandArray = new String[]{sIdentify, "-format", sIM_Format, _sDiffGfx};
        ProcessHandler aHandler = new ProcessHandler(sCommandArray);
        boolean bBackValue = aHandler.executeSynchronously();
        int nExitCode = aHandler.getExitCode();
        String sBack = aHandler.getOutputText();
        GlobalLogWriter.get().println("'" + sBack + "'");
        try {
            int nIdx = sBack.indexOf("\n");
            if (nIdx > 0) {
                sBack = sBack.substring(0, nIdx);
            }
            nResult = Integer.valueOf(sBack);
        }
        catch (NumberFormatException e) {
            GlobalLogWriter.get().println("identify(): Number format exception");
            nResult = 0;
        }
        return nResult;
    }

    public static void main(String[] _args) {
        String[] args = new String[]{"-TimeOut", "3600000", "-tb", "java_complex", "-o", "graphical.JPEGComparator", "-DOC_COMPARATOR_INPUT_PATH", "C:\\CWS\\temp\\output\\index.ini", "-DOC_COMPARATOR_OUTPUT_PATH", "C:\\CWS\\temp\\output2", "-DOC_COMPARATOR_HTML_OUTPUT_PREFIX", "http://so-gfxcmp-lin.germany.sun.com/gfxcmp_ui/cw.php?inifile=", "-NoOffice"};
        Runner.main(args);
    }
}

