/*
 * Decompiled with CFR 0.152.
 */
package graphical;

import graphical.GlobalLogWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Enumeration;

public class IniFile
implements Enumeration {
    private String m_sFilename;
    private ArrayList m_aList;
    boolean m_bListContainUnsavedChanges = false;
    private int m_aEnumerationPos = 0;

    public IniFile(String _sFilename) {
        this.m_sFilename = _sFilename;
        this.m_aList = this.loadLines();
        this.m_aEnumerationPos = this.findNextSection(0);
    }

    public void insertFirstComment(String[] _aList) {
        if (this.m_aList.size() == 0) {
            for (int i = 0; i < _aList.length; ++i) {
                this.m_aList.add(_aList[i]);
            }
        }
    }

    private ArrayList loadLines() {
        File aFile = new File(this.m_sFilename);
        ArrayList<String> aLines = new ArrayList<String>();
        if (!aFile.exists()) {
            GlobalLogWriter.get().println("couldn't find file '" + this.m_sFilename + "', will be created.");
            return aLines;
        }
        RandomAccessFile aReader = null;
        try {
            aReader = new RandomAccessFile(aFile, "r");
            String aLine = "";
            while (aLine != null) {
                aLine = aReader.readLine();
                if (aLine == null || aLine.length() <= 0) continue;
                aLines.add(aLine);
            }
        }
        catch (FileNotFoundException fne) {
            GlobalLogWriter.get().println("couldn't open file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + fne.getMessage());
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Exception occurs while reading from file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
        try {
            aReader.close();
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Couldn't close file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
        return aLines;
    }

    public boolean is() {
        return this.m_aList.size() > 1;
    }

    public boolean hasValue(String _sSectionName, String _sKey) {
        int n = this.findKey(_sSectionName, _sKey);
        return n > 0;
    }

    private boolean isRemark(String _sLine) {
        return _sLine.length() < 2 || _sLine.startsWith("#") || _sLine.startsWith(";");
    }

    private String getItem(int i) {
        return (String)this.m_aList.get(i);
    }

    private String buildSectionName(String _sSectionName) {
        String sFindSection = "[" + _sSectionName + "]";
        return sFindSection;
    }

    private String sectionToString(String _sSectionName) {
        String sKeyName = _sSectionName;
        if (sKeyName.startsWith("[") && sKeyName.endsWith("]")) {
            sKeyName = sKeyName.substring(1, sKeyName.length() - 1);
        }
        return sKeyName;
    }

    private String toLowerIfNeed(String _sName) {
        return _sName.toLowerCase();
    }

    private int findSection(String _sSection) {
        String sFindSection = this.toLowerIfNeed(this.buildSectionName(_sSection));
        for (int i = 0; i < this.m_aList.size(); ++i) {
            String sLine = this.toLowerIfNeed(this.getItem(i).trim());
            if (this.isRemark(sLine)) continue;
            if (sFindSection.equals("[]")) {
                return i - 1;
            }
            if (!sLine.startsWith(sFindSection)) continue;
            return i;
        }
        return -1;
    }

    public boolean hasSection(String _sSection) {
        int i = this.findSection(_sSection);
        return i != -1;
    }

    private int findKey(String _sSection, String _sKey) {
        int i = this.findSection(_sSection);
        if (i == -1) {
            return -1;
        }
        return this.findKeyFromKnownSection(i, _sKey);
    }

    private int findKeyFromKnownSection(int _nSectionIndex, String _sKey) {
        _sKey = this.toLowerIfNeed(_sKey);
        for (int j = _nSectionIndex + 1; j < this.m_aList.size(); ++j) {
            String sKey;
            String sLine = this.getItem(j).trim();
            if (this.isRemark(sLine)) continue;
            if (sLine.startsWith("[")) break;
            int nEqual = sLine.indexOf("=");
            if (nEqual < 0 || !(sKey = this.toLowerIfNeed(sLine.substring(0, nEqual).trim())).equals(_sKey)) continue;
            return j;
        }
        return -1;
    }

    private int findLastKnownKeyIndex(int _nSectionIndex, String _sKey) {
        int i;
        _sKey = this.toLowerIfNeed(_sKey);
        for (int j = i = _nSectionIndex + 1; j < this.m_aList.size(); ++j) {
            String sKey;
            String sLine = this.getItem(j).trim();
            if (this.isRemark(sLine)) continue;
            if (sLine.startsWith("[")) {
                return j;
            }
            int nEqual = sLine.indexOf("=");
            if (nEqual < 0 || !(sKey = this.toLowerIfNeed(sLine.substring(0, nEqual).trim())).equals(_sKey)) continue;
            return j;
        }
        return i;
    }

    private String getValue(int _nIndex) {
        String sLine = this.getItem(_nIndex).trim();
        if (this.isRemark(sLine)) {
            return "";
        }
        int nEqual = sLine.indexOf("=");
        if (nEqual >= 0) {
            String sKey = sLine.substring(0, nEqual).trim();
            String sValue = sLine.substring(nEqual + 1).trim();
            return sValue;
        }
        return "";
    }

    public String getValue(String _sSection, String _sKey) {
        String sValue = "";
        int m_nCurrentPosition = this.findKey(_sSection, _sKey);
        if (m_nCurrentPosition == -1) {
            return "";
        }
        sValue = this.getValue(m_nCurrentPosition);
        return sValue;
    }

    public int getIntValue(String _sSection, String _sKey, int _nDefault) {
        String sValue = this.getValue(_sSection, _sKey);
        int nValue = _nDefault;
        if (sValue.length() > 0) {
            try {
                nValue = Integer.valueOf(sValue);
            }
            catch (NumberFormatException e) {
                GlobalLogWriter.get().println("IniFile.getIntValue(): Caught a number format exception, return the default value.");
            }
        }
        return nValue;
    }

    public void close() {
        this.store();
    }

    public void store() {
        if (!this.m_bListContainUnsavedChanges) {
            return;
        }
        File aFile = new File(this.m_sFilename);
        if (aFile.exists()) {
            aFile.delete();
            if (aFile.exists()) {
                GlobalLogWriter.get().println("Couldn't delete the file " + this.m_sFilename);
                return;
            }
        }
        try {
            RandomAccessFile aWriter = new RandomAccessFile(aFile, "rw");
            for (int i = 0; i < this.m_aList.size(); ++i) {
                String sLine = this.getItem(i);
                if (sLine.startsWith("[")) {
                    aWriter.writeByte(10);
                }
                aWriter.writeBytes(sLine);
                aWriter.writeByte(10);
            }
            aWriter.close();
        }
        catch (FileNotFoundException fne) {
            GlobalLogWriter.get().println("couldn't open file for writing " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + fne.getMessage());
        }
        catch (IOException ie) {
            GlobalLogWriter.get().println("Exception occurs while writing to file " + this.m_sFilename);
            GlobalLogWriter.get().println("Message: " + ie.getMessage());
        }
    }

    public void insertValue(String _sSection, String _sKey, int _nValue) {
        this.insertValue(_sSection, _sKey, String.valueOf(_nValue));
    }

    public void insertValue(String _sSection, String _sKey, long _nValue) {
        this.insertValue(_sSection, _sKey, String.valueOf(_nValue));
    }

    public void insertValue(String _sSection, String _sKey, String _sValue) {
        int i = this.findSection(_sSection);
        if (i == -1) {
            String sFindSection = this.buildSectionName(_sSection);
            this.m_aList.add(sFindSection);
            if (_sKey.length() > 0) {
                String sKeyValuePair = _sKey + "=" + _sValue;
                this.m_aList.add(sKeyValuePair);
            }
            this.m_bListContainUnsavedChanges = true;
            return;
        }
        int j = this.findKeyFromKnownSection(i, _sKey);
        if (j == -1) {
            j = this.findLastKnownKeyIndex(i, _sKey);
            if (_sKey.length() > 0) {
                String sKeyValuePair = _sKey + "=" + _sValue;
                this.m_aList.add(j, sKeyValuePair);
                this.m_bListContainUnsavedChanges = true;
            }
            return;
        }
        String sKeyValuePair = _sKey + "=" + _sValue;
        this.m_aList.set(j, sKeyValuePair);
        this.m_bListContainUnsavedChanges = true;
    }

    public void removeSection(String _sSectionToRemove) {
        int i = this.findSection(_sSectionToRemove);
        if (i == -1) {
            return;
        }
        int j = this.findNextSection(i + 1);
        if (j == -1) {
            j = this.m_aList.size();
        }
        for (int k = i; k < j; ++k) {
            this.m_aList.remove(i);
        }
        this.m_bListContainUnsavedChanges = true;
    }

    public static void main(String[] args) {
        String sTempFile = System.getProperty("java.io.tmpdir");
        sTempFile = sTempFile + "inifile";
        IniFile aIniFile = new IniFile(sTempFile);
        String sValue = aIniFile.getValue("Section", "Key");
        aIniFile.insertValue("Section", "Key2", "a new value in a existing section");
        aIniFile.insertValue("Section", "Key", "replaced value");
        aIniFile.insertValue("New Section", "Key", "a new key value pair");
        aIniFile.insertValue("New Section", "Key2", "a new second key value pair");
        String sValue2 = aIniFile.getValue("Section2", "Key");
        aIniFile.removeSection("Section");
        aIniFile.removeSection("New Section");
        aIniFile.close();
    }

    @Override
    public boolean hasMoreElements() {
        return this.m_aEnumerationPos >= 0 && this.m_aEnumerationPos < this.m_aList.size();
    }

    private int findNextSection(int i) {
        if (i >= 0) {
            while (i < this.m_aList.size()) {
                String sLine = (String)this.m_aList.get(i);
                if (sLine.startsWith("[")) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    public Object nextElement() {
        int nLineWithSection = this.findNextSection(this.m_aEnumerationPos);
        if (nLineWithSection != -1) {
            String sSection = (String)this.m_aList.get(nLineWithSection);
            this.m_aEnumerationPos = this.findNextSection(nLineWithSection + 1);
            sSection = this.sectionToString(sSection);
            return sSection;
        }
        this.m_aEnumerationPos = this.m_aList.size();
        return null;
    }

    public int getElementCount() {
        int nCount = 0;
        int nPosition = 0;
        while ((nPosition = this.findNextSection(nPosition)) != -1) {
            ++nCount;
            ++nPosition;
        }
        return nCount;
    }
}

